/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rvm;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSettings;

public class LocalRvmPathsSettings
implements RvmSettings {
    public static final String SHARE_RVM_PATH = "/usr/share/rvm";
    private static final Logger LOG = Logger.getInstance(LocalRvmPathsSettings.class);
    private static final String[] KNOW_RVM_HOME_PATHS = new String[]{"/usr/local/rvm"};
    private static final String RVMRC_EXPORT_GEM_PATH = "export rvm_gems_path=\"${HOME}/.rvm/gems\"";
    private RVMInstallationType myRVMInstallationType = RVMInstallationType.SINGLE;
    private final NullableLazyValue<VirtualFile> myGemsFolderProvider = NullableLazyValue.lazyNullable(this::computeGemsFolder);
    private final NullableLazyValue<VirtualFile> myInterpretersFolderProvider = NullableLazyValue.lazyNullable(this::computeInterpretersFolder);
    private final NullableLazyValue<VirtualFile> myRVMHomeProvider = NullableLazyValue.lazyNullable(this::computeRvmHome);
    private static final AtomicBoolean myInitializing = new AtomicBoolean();

    private static boolean isPooledThreadWithReadAction() {
        Application application = ApplicationManager.getApplication();
        return application.isReadAccessAllowed() && !application.isDispatchThread();
    }

    void initialize() {
        if (!LocalRvmPathsSettings.isPooledThreadWithReadAction()) {
            this.getRvmExecutable();
            this.getInterpretersFolder();
            this.getGemsFolder();
        } else if (!myInitializing.getAndSet(true)) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    this.initialize();
                }
                finally {
                    myInitializing.set(false);
                }
            });
        }
    }

    @Nullable
    public VirtualFile getRvmHome() {
        return this.getLazyValueSafely(this.myRVMHomeProvider);
    }

    @Nullable
    public VirtualFile getInterpretersFolder() {
        return this.getLazyValueSafely(this.myInterpretersFolderProvider);
    }

    @Nullable
    private VirtualFile computeInterpretersFolder() {
        VirtualFile rvmHome = this.getRvmHome();
        return rvmHome == null ? null : rvmHome.findChild("rubies");
    }

    @Nullable
    public VirtualFile getGemsFolder() {
        return this.getLazyValueSafely(this.myGemsFolderProvider);
    }

    @Nullable
    private <T> T getLazyValueSafely(@NotNull NullableLazyValue<T> lazyValue) {
        if (lazyValue == null) {
            LocalRvmPathsSettings.$$$reportNull$$$0(0);
        }
        if (lazyValue.isComputed()) {
            return (T)lazyValue.getValue();
        }
        if (LocalRvmPathsSettings.isPooledThreadWithReadAction()) {
            LOG.debug("Initializing lazy values safely to avoid the deadlock.");
            this.initialize();
            return null;
        }
        return (T)lazyValue.getValue();
    }

    @Nullable
    public VirtualFile getRvmExecutable() {
        VirtualFile rvmHome = this.getRvmHome();
        if (rvmHome == null) {
            return null;
        }
        VirtualFile rvmBin = rvmHome.findChild("/bin");
        if (rvmBin == null || !rvmBin.isDirectory()) {
            return null;
        }
        return rvmBin.findChild("rvm");
    }

    @Override
    @Nullable
    public String getRvmHomePath() {
        return (String)ObjectUtils.doIfNotNull((Object)this.getRvmHome(), VirtualFile::getPath);
    }

    public boolean isMixedMode() {
        return this.myRVMInstallationType == RVMInstallationType.MIXED_MODE;
    }

    private boolean ensureMixedMode() {
        VirtualFile userHome = VfsUtil.getUserHomeDir();
        if (userHome == null) {
            return false;
        }
        VirtualFile rvmrcFile = userHome.findChild(".rvmrc");
        if (rvmrcFile == null) {
            return false;
        }
        String rvmrcFileContent = LoadTextUtil.loadText((VirtualFile)rvmrcFile).toString();
        if (StringUtil.contains((CharSequence)rvmrcFileContent, (CharSequence)RVMRC_EXPORT_GEM_PATH)) {
            this.myRVMInstallationType = RVMInstallationType.MIXED_MODE;
            return true;
        }
        return false;
    }

    @Nullable
    private VirtualFile computeGemsFolder() {
        VirtualFile rvmHome;
        VirtualFile userHomeRVM;
        if (this.isMixedMode() && (userHomeRVM = LocalRvmPathsSettings.findUserHomeRVM()) != null) {
            VirtualFile gemFolder = userHomeRVM.findChild("gems");
            if (gemFolder != null) {
                return gemFolder;
            }
            LOG.warn("Cannot find gems folder for Mixed Mode installed RVM in /usr/share/rvm");
        }
        return (rvmHome = this.getRvmHome()) == null ? null : rvmHome.findChild("gems");
    }

    private void doDecideMultiUserOrMixed() {
        this.myRVMInstallationType = RVMInstallationType.MULTI_USER;
        this.ensureMixedMode();
    }

    @Nullable
    private VirtualFile computeRvmHome() {
        if (SystemInfo.isWindows) {
            return null;
        }
        String customRVMPath = LocalRvmPathsSettings.determineCustomRvmPath();
        if (customRVMPath != null) {
            VirtualFile rvmHome;
            String customRVMUrl = VirtualFileUtil.constructLocalUrl(customRVMPath);
            if (customRVMPath.startsWith(SHARE_RVM_PATH)) {
                this.doDecideMultiUserOrMixed();
            }
            if ((rvmHome = VirtualFileManager.getInstance().refreshAndFindFileByUrl(customRVMUrl)) == null) {
                LOG.warn("Cannot find custom rvm home directory: " + customRVMPath);
            }
            return rvmHome;
        }
        VirtualFile rvmHome = LocalRvmPathsSettings.findShareRVM();
        if (rvmHome != null) {
            this.doDecideMultiUserOrMixed();
            return rvmHome;
        }
        rvmHome = LocalRvmPathsSettings.findUserHomeRVM();
        if (rvmHome != null) {
            return rvmHome;
        }
        String systemWideRVMPath = LocalRvmPathsSettings.determineNonLocalRvmPath();
        if (systemWideRVMPath != null) {
            LOG.info("System wide RVM detected: " + systemWideRVMPath);
            String systemWideRVMUrl = VirtualFileUtil.constructLocalUrl(systemWideRVMPath);
            rvmHome = VirtualFileManager.getInstance().refreshAndFindFileByUrl(systemWideRVMUrl);
            if (rvmHome == null) {
                LOG.warn("Cannot find rvm home directory: " + systemWideRVMPath);
            }
            return rvmHome;
        }
        LOG.info("RVM installation wasn't detected.");
        return null;
    }

    @Override
    public boolean isRvmSupportEnabled() {
        if (!SystemInfo.isUnix) {
            return false;
        }
        VirtualFile rvmInterpretersDir = this.getInterpretersFolder();
        return rvmInterpretersDir != null && rvmInterpretersDir.isDirectory();
    }

    public static LocalRvmPathsSettings getInstance() {
        return (LocalRvmPathsSettings)ApplicationManager.getApplication().getService(LocalRvmPathsSettings.class);
    }

    @Nullable
    private static VirtualFile findShareRVM() {
        Path shareRvmPath = Path.of(SHARE_RVM_PATH, new String[0]);
        if (!Files.isDirectory(shareRvmPath, new LinkOption[0])) {
            LOG.debug("Share rvm directory doesn't exist: " + String.valueOf(shareRvmPath));
            return null;
        }
        if (LocalRvmPathsSettings.isEmptyDir(shareRvmPath)) {
            LOG.debug("Share rvm directory is empty: " + String.valueOf(shareRvmPath));
            return null;
        }
        VirtualFile shareRvmVirtualFile = VfsUtil.findFile((Path)shareRvmPath, (boolean)true);
        if (shareRvmVirtualFile == null) {
            LOG.warn("Couldn't find an existing share rvm directory in VFS: " + String.valueOf(shareRvmPath));
        }
        return shareRvmVirtualFile;
    }

    @Nullable
    private static VirtualFile findUserHomeRVM() {
        Path userHomePath = Path.of(SystemProperties.getUserHome(), new String[0]);
        Path rvmHomePath = userHomePath.resolve(".rvm");
        if (!Files.isDirectory(rvmHomePath, new LinkOption[0])) {
            LOG.debug("Local rvm directory doesn't exist: " + String.valueOf(rvmHomePath));
            return null;
        }
        if (LocalRvmPathsSettings.isEmptyDir(rvmHomePath)) {
            LOG.debug("Local rvm directory is empty: " + String.valueOf(rvmHomePath));
            return null;
        }
        VirtualFile rvmHomeVirtualFile = VfsUtil.findFile((Path)rvmHomePath, (boolean)true);
        if (rvmHomeVirtualFile == null) {
            LOG.warn("Couldn't find an existing local rvm directory in VFS: " + String.valueOf(rvmHomePath));
        }
        return rvmHomeVirtualFile;
    }

    @Nullable
    private static String determineCustomRvmPath() {
        if (SystemInfo.isWindows) {
            throw new UnsupportedOperationException("RVM support isn't implemented for Windows");
        }
        String customRvmPath = EnvironmentUtil.getValue((String)"rvm_path");
        return !StringUtil.isEmpty((String)customRvmPath) ? customRvmPath : null;
    }

    @Nullable
    private static String determineNonLocalRvmPath() {
        if (SystemInfo.isWindows) {
            throw new UnsupportedOperationException("RVM support isn't implemented for Windows");
        }
        for (String knowRvmHomePath : KNOW_RVM_HOME_PATHS) {
            String markerPath = knowRvmHomePath + "/rubies";
            File file = new File(markerPath);
            if (!file.exists()) continue;
            return knowRvmHomePath;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isEmptyDir(Path dir) {
        try (Stream<Path> entries = Files.list(dir);){
            if (!entries.findFirst().isEmpty()) return true;
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOG.warn("Failed to check if directory '/usr/share/rvm' is empty: " + e.getMessage());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lazyValue", "org/jetbrains/plugins/ruby/version/management/rvm/LocalRvmPathsSettings", "getLazyValueSafely"));
    }

    static enum RVMInstallationType {
        SINGLE,
        MULTI_USER,
        MIXED_MODE;

    }
}

