/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rbenv;

import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.version.management.RubySdkConfig;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;

final class RbenvVersionSdkConfigFactory
implements RubySdkConfig.Factory {
    public static final String RBENV_VERSION_FILE_NAME = ".rbenv-version";
    private static final List<String> SOURCE_FILENAMES = Collections.singletonList(".rbenv-version");

    RbenvVersionSdkConfigFactory() {
    }

    @Override
    @NotNull
    public Collection<String> getSourceFilenames() {
        List<String> list = SOURCE_FILENAMES;
        if (list == null) {
            RbenvVersionSdkConfigFactory.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public RubySdkConfig createFromRoot(@NotNull VirtualFile root, @NotNull RubyVersionManagerHandler vmHandler) {
        VirtualFile file;
        if (root == null) {
            RbenvVersionSdkConfigFactory.$$$reportNull$$$0(1);
        }
        if (vmHandler == null) {
            RbenvVersionSdkConfigFactory.$$$reportNull$$$0(2);
        }
        if ((file = root.findChild(RBENV_VERSION_FILE_NAME)) == null) {
            return null;
        }
        String content = LoadTextUtil.loadText((VirtualFile)file).toString().strip();
        if (content.isEmpty()) {
            return null;
        }
        String version = RubyVersionUtil.normalizeVersionForVms(content);
        return new RubySdkConfig(version, null, RBENV_VERSION_FILE_NAME, vmHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvVersionSdkConfigFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFilenames";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvVersionSdkConfigFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFromRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

