/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rbenv;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.version.management.RubySdkConfig;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.RubyVersionAndGemsetSdkConfigFactory;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandlerBase;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.SdkInstaller;
import org.jetbrains.plugins.ruby.version.management.ShimsBasedVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.rbenv.RbenvSdkData;
import org.jetbrains.plugins.ruby.version.management.rbenv.RbenvSdkInstaller;
import org.jetbrains.plugins.ruby.version.management.rbenv.RbenvVersionSdkConfigFactory;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

public final class RbenvVersionManagerHandler
extends RubyVersionManagerHandlerBase<RbenvSdkData>
implements ShimsBasedVersionManagerHandler {
    private static final Logger LOG = Logger.getInstance(RbenvVersionManagerHandler.class);
    @NonNls
    private static final String RBENV_GEMSET = "RBENV_GEMSETS";
    private static final String SHIMS_RELATIVE_PATH = "shims";
    static final String INSTALLATIONS_RELATIVE_PATH = "versions";
    static final List<String> DEFAULT_RBENV_HOMES = Collections.singletonList("~/.rbenv/bin");
    static final List<String> POSSIBLE_RBENV_PATHS = ContainerUtil.map(DEFAULT_RBENV_HOMES, it -> it + "/rbenv");
    private static final List<RbenvSdkInstaller> SDK_INSTALLERS = Collections.singletonList(new RbenvSdkInstaller());

    @Override
    @NotNull
    protected List<String> getAdditionalPathsToSearch() {
        List<String> list = DEFAULT_RBENV_HOMES;
        if (list == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    public String getVersionManagerExecutableName() {
        return "rbenv";
    }

    @Override
    @NotNull
    protected List<String> patchCommands(@NotNull RubyRunner rubyRunner, @NotNull String versionManagerPath, @NotNull String distributionId, @NotNull List<String> commandsToPatch, @NotNull Map<String, String> env) {
        if (rubyRunner == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(1);
        }
        if (versionManagerPath == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(2);
        }
        if (distributionId == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(3);
        }
        if (commandsToPatch == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(4);
        }
        if (env == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(5);
        }
        if (!commandsToPatch.isEmpty()) {
            commandsToPatch.set(0, Paths.get(commandsToPatch.get(0), new String[0]).getFileName().toString());
        }
        List<String> list = rubyRunner.getCommandsSequence(ContainerUtil.prepend(commandsToPatch, (Object[])new String[]{"env", "RBENV_VERSION=" + distributionId, versionManagerPath, "exec"}));
        if (list == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    public Path computeShimsPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(7);
        }
        Path path = RbenvVersionManagerHandler.computeHomePath(sdk).resolve(SHIMS_RELATIVE_PATH);
        if (path == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(8);
        }
        return path;
    }

    private static Path computeHomePath(@NotNull Sdk sdk) {
        if (sdk == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(9);
        }
        return RbenvVersionManagerHandler.computeHomeByInterpreterPath(RubySdkAdditionalData.notNullFrom(sdk).getInterpreterPath(sdk));
    }

    @Override
    @NotNull
    protected List<String> getAvailableDistributionsCommands(@NotNull RubyRunner runner, @NotNull String versionManagerPath) {
        if (runner == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(10);
        }
        if (versionManagerPath == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(11);
        }
        List<String> list = Arrays.asList(versionManagerPath, INSTALLATIONS_RELATIVE_PATH, "--bare", "--skip-aliases");
        if (list == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    @NotNull
    protected List<String> processAvailableDistributionsOutput(@NotNull List<String> rawOutput) {
        if (rawOutput == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(13);
        }
        List list = ContainerUtil.filter(rawOutput, s -> !StringUtil.equals((CharSequence)s, (CharSequence)"system") && !StringUtil.startsWithChar((CharSequence)s, (char)'-'));
        if (list == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    @NotNull
    public RbenvSdkData createAdditionalData() {
        return new RbenvSdkData(this);
    }

    @Override
    @Nullable
    protected RubyVersionManagerSdkData doLoadLegacy(@NotNull Element rootElement, @NotNull String interpreterPath) {
        if (rootElement == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(15);
        }
        if (interpreterPath == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(16);
        }
        String rbenvGemsetName = rootElement.getAttributeValue(RBENV_GEMSET);
        if (RbenvGemsetManager.isRbenvSdkPath(interpreterPath) || rbenvGemsetName != null) {
            return ((RbenvSdkData)this.createAdditionalData().withDistributionId(RbenvVersionManagerHandler.getVersionFromInterpreterPath(interpreterPath))).withGemsetName(rbenvGemsetName);
        }
        return null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    static String computeRootFor(@Nullable Path pathToRbenv, @NotNull RubyRunner runner) {
        if (runner == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(17);
        }
        if (pathToRbenv == null) {
            return null;
        }
        try {
            LOG.debug("Getting rbenv root from " + pathToRbenv.toString());
            ProcessOutput processOutput = runner.execute((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(pathToRbenv.toString(), "root").inSameThread(RubyRunner.DEFAULT_EXECUTION_TIMEOUT, RBundle.message((String)"version.manager.rbenv.fetching.root")));
            assert (processOutput != null);
            if (processOutput.getExitCode() != 0) {
                LOG.warn("Error getting rbenv root from script, error code " + processOutput.getExitCode() + "; STDOUT: " + processOutput.getStdout() + "; STDERR: " + processOutput.getStderr());
                return null;
            }
            List stdoutLines = processOutput.getStdoutLines();
            String firstLine = stdoutLines.isEmpty() ? null : (String)stdoutLines.get(0);
            return StringUtil.isEmpty((String)firstLine) ? null : firstLine;
        }
        catch (ExecutionException e) {
            LOG.warn("Error getting rbenv root result", (Throwable)e);
            return null;
        }
    }

    @Override
    @NotNull
    public RbenvSdkData createAdditionalData(@NotNull RubySdkInfo sdkInfo) {
        if (sdkInfo == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(18);
        }
        RbenvSdkData rbenvSdkData = ((RbenvSdkData)super.createAdditionalData(sdkInfo)).withGemsetName(sdkInfo.getGemSet());
        if (rbenvSdkData == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(19);
        }
        return rbenvSdkData;
    }

    @Contract(pure=true)
    @NotNull
    public static RbenvVersionManagerHandler getInstance() {
        RbenvVersionManagerHandler rbenvVersionManagerHandler = Objects.requireNonNull((RbenvVersionManagerHandler)RubyVersionManagerHandler.findHandler(o -> o instanceof RbenvVersionManagerHandler));
        if (rbenvVersionManagerHandler == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(20);
        }
        return rbenvVersionManagerHandler;
    }

    @Override
    public boolean canRunArbitraryCommand() {
        return false;
    }

    @Contract(pure=true)
    @NotNull
    private static Path computeHomeByInterpreterPath(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(21);
        }
        Path run2 = Paths.get(interpreterPath, new String[0]);
        for (int i = 0; i < 4; ++i) {
            if ((run2 = run2.getParent()) != null) continue;
            throw new NullPointerException("Interpreter path supposed to be valid, e.g: /home/user/.rbenv/versions/2.5.1/bin/ruby");
        }
        Path path = run2;
        if (path == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(22);
        }
        return path;
    }

    @Override
    @NotNull
    protected String getStarterScriptName() {
        return "rbenv_starter.sh";
    }

    @Override
    protected Collection<Class<? extends RubySdkConfig.Factory>> getSdkConfigFactories() {
        return List.of(RubyVersionAndGemsetSdkConfigFactory.class, RbenvVersionSdkConfigFactory.class);
    }

    @Override
    @NotNull
    public Object getConfigIgnoredRequestor() {
        Object object = RbenvGemsetManager.RBENV_GEMSETS_CONFIG_REQUESTOR;
        if (object == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(23);
        }
        return object;
    }

    @Override
    @NotNull
    public Collection<? extends SdkInstaller> getInstallers() {
        List<RbenvSdkInstaller> list = SDK_INSTALLERS;
        if (list == null) {
            RbenvVersionManagerHandler.$$$reportNull$$$0(24);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7, 9, 10, 11, 13, 15, 16, 17, 18, 21 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvVersionManagerHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyRunner";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandsToPatch";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawOutput";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPathsToSearch";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvVersionManagerHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "patchCommands";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeShimsPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributionsCommands";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "processAvailableDistributionsOutput";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalData";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "computeHomeByInterpreterPath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigIgnoredRequestor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "patchCommands";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeShimsPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeHomePath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDistributionsCommands";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processAvailableDistributionsOutput";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doLoadLegacy";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "computeRootFor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalData";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "computeHomeByInterpreterPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 7, 9, 10, 11, 13, 15, 16, 17, 18, 21 -> new IllegalArgumentException(string);
        };
    }
}

