/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rbenv;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.ui.RubySdkGemsetsSettings;
import org.jetbrains.plugins.ruby.gem.workspace.sync.RubySdkGemLibraryManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.RubyFileSystemUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.SdkRefresherVmBase;
import org.jetbrains.plugins.ruby.version.management.rbenv.RbenvSdkData;
import org.jetbrains.plugins.ruby.version.management.rbenv.RbenvVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

@VisibleForTesting
public final class RbenvSdkRefresher
extends SdkRefresherVmBase {
    private static final Logger LOG = Logger.getInstance(RbenvSdkRefresher.class);
    private static final Map<Path, String> ROOTS_MAP = new ConcurrentHashMap<Path, String>();

    @NotNull
    public static RbenvSdkRefresher getInstance() {
        RbenvSdkRefresher rbenvSdkRefresher = (RbenvSdkRefresher)EP_NAME.findExtensionOrFail(RbenvSdkRefresher.class);
        if (rbenvSdkRefresher == null) {
            RbenvSdkRefresher.$$$reportNull$$$0(0);
        }
        return rbenvSdkRefresher;
    }

    @Override
    protected void doAdditionalInitialization() {
        this.getInstallationsRoots().stream().flatMap(it -> Stream.of(it.getChildren())).filter(it -> it.isDirectory()).forEach(it -> this.addGemsetsToWatchRoots((VirtualFile)it));
    }

    @NotNull
    public RbenvVersionManagerHandler getVersionManagerHandler() {
        RbenvVersionManagerHandler rbenvVersionManagerHandler = RbenvVersionManagerHandler.getInstance();
        if (rbenvVersionManagerHandler == null) {
            RbenvSdkRefresher.$$$reportNull$$$0(1);
        }
        return rbenvVersionManagerHandler;
    }

    private void addGemsetsToWatchRoots(@NotNull VirtualFile rubyHome) {
        VirtualFile gemsetsDirectory;
        if (rubyHome == null) {
            RbenvSdkRefresher.$$$reportNull$$$0(2);
        }
        if ((gemsetsDirectory = rubyHome.findChild("gemsets")) == null || !gemsetsDirectory.isDirectory()) {
            LOG.debug("No gemset directory for " + String.valueOf(rubyHome));
            return;
        }
        this.addRootToWatch(gemsetsDirectory);
    }

    @Override
    @NotNull
    protected List<String> getPossibleVersionManagersPaths() {
        List<String> list = RbenvVersionManagerHandler.POSSIBLE_RBENV_PATHS;
        if (list == null) {
            RbenvSdkRefresher.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    protected Stream<? extends RubySdkInfo> getSdkInfosForInterpreterHome(@NotNull String versionManagerPathName, @NotNull VirtualFile interpreterHome) {
        if (versionManagerPathName == null) {
            RbenvSdkRefresher.$$$reportNull$$$0(4);
        }
        if (interpreterHome == null) {
            RbenvSdkRefresher.$$$reportNull$$$0(5);
        }
        LOG.debug("Processing potential home " + String.valueOf(interpreterHome));
        Stream<RubySdkInfo> result = Stream.of(new RubySdkInfo(versionManagerPathName, interpreterHome, null));
        VirtualFile gemsetsDir = interpreterHome.findChild("gemsets");
        if (gemsetsDir != null) {
            this.myLog.debug("Got a gemset directory: " + String.valueOf(gemsetsDir));
            result = Stream.concat(result, Stream.of(gemsetsDir.getChildren()).filter(it -> it.isDirectory() && !FileTypeManager.getInstance().isFileIgnored(it)).map(it -> {
                this.myLog.debug("Found gemset: " + String.valueOf(it));
                return new RubySdkInfo(versionManagerPathName, interpreterHome, it.getName());
            }));
        }
        Stream<RubySdkInfo> stream = result;
        if (stream == null) {
            RbenvSdkRefresher.$$$reportNull$$$0(6);
        }
        return stream;
    }

    @Override
    protected void runPostCreateSdkAction(@NotNull RubySdkInfo sdkInfo) {
        if (sdkInfo == null) {
            RbenvSdkRefresher.$$$reportNull$$$0(7);
        }
        if (!RbenvGemsetManager.isGemsetSdk(sdkInfo)) {
            RubyFileSystemUtil.addRootToWatch(sdkInfo.getInterpreterHome().getPath(), false, RubyPluginUtil.getUnloadAwareDisposable());
        }
        this.addGemsetsToWatchRoots(sdkInfo.getInterpreterHome());
    }

    @Override
    @Nullable
    public String suggestSdkName(@NotNull String executablePath, @NotNull String distributionId, @NotNull RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
        String baseName;
        if (executablePath == null) {
            RbenvSdkRefresher.$$$reportNull$$$0(8);
        }
        if (distributionId == null) {
            RbenvSdkRefresher.$$$reportNull$$$0(9);
        }
        if (versionManagerSdkAdditionalData == null) {
            RbenvSdkRefresher.$$$reportNull$$$0(10);
        }
        if ((baseName = super.suggestSdkName(executablePath, distributionId, versionManagerSdkAdditionalData)) == null) {
            return null;
        }
        String gemset = ((RbenvSdkData)versionManagerSdkAdditionalData).getGemsetName();
        if (gemset != null && !StringUtil.isEmpty((String)gemset)) {
            return baseName + " [" + gemset + "]";
        }
        return baseName;
    }

    @Override
    public void onProjectOpened(@NotNull Project project) {
        if (project == null) {
            RbenvSdkRefresher.$$$reportNull$$$0(11);
        }
        RbenvGemsetManager.RBENV_PLUGIN_INSTALLED.drop();
        MessageBusConnection projectConnection = project.getMessageBus().connect(RubyPluginUtil.getUnloadAwareDisposable(project));
        RbenvSdkRefresher.configureGemsetsAfterProjectOpened(project, projectConnection);
    }

    private static void configureGemsetsAfterProjectOpened(@NotNull Project project, @NotNull MessageBusConnection projectConnection) {
        Module[] rubyModules;
        if (project == null) {
            RbenvSdkRefresher.$$$reportNull$$$0(12);
        }
        if (projectConnection == null) {
            RbenvSdkRefresher.$$$reportNull$$$0(13);
        }
        for (Module module : rubyModules = RModuleUtil.getInstance().getAllModulesWithRubySupport(project)) {
            RbenvGemsetManager.excludeLocalGemsets(module);
            RbenvGemsetsConfigFileListener gemsetsListener = new RbenvGemsetsConfigFileListener(module);
            projectConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)gemsetsListener);
        }
    }

    @Override
    @NotNull
    protected List<String> getInstallationsRootsPathNames() {
        this.myLog.debug("Seeking for installation root");
        String rbenvRoot = (String)ObjectUtils.doIfNotNull((Object)this.getVersionManagerPath(), versionManagerPath -> ROOTS_MAP.computeIfAbsent((Path)versionManagerPath, it -> StringUtil.notNullize((String)RbenvVersionManagerHandler.computeRootFor(it, RubyLocalRunner.getRunner(null)))));
        if (rbenvRoot == null || rbenvRoot.isEmpty()) {
            this.myLog.debug("Could not find rbenv root");
            List<String> list = Collections.emptyList();
            if (list == null) {
                RbenvSdkRefresher.$$$reportNull$$$0(14);
            }
            return list;
        }
        this.myLog.debug("Found root at " + rbenvRoot);
        List<String> list = Collections.singletonList(Paths.get(rbenvRoot, new String[0]).resolve("versions").toString());
        if (list == null) {
            RbenvSdkRefresher.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 7, 8, 9, 10, 11, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvSdkRefresher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyHome";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPathName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterHome";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executablePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerSdkAdditionalData";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectConnection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionManagerHandler";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvSdkRefresher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleVersionManagersPaths";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkInfosForInterpreterHome";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallationsRootsPathNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addGemsetsToWatchRoots";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSdkInfosForInterpreterHome";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runPostCreateSdkAction";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "suggestSdkName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onProjectOpened";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "configureGemsetsAfterProjectOpened";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 7, 8, 9, 10, 11, 12, 13 -> new IllegalArgumentException(string);
        };
    }

    private static class RbenvGemsetsConfigFileListener
    implements BulkFileListener {
        private final Module myModule;

        RbenvGemsetsConfigFileListener(@NotNull Module module) {
            if (module == null) {
                RbenvGemsetsConfigFileListener.$$$reportNull$$$0(0);
            }
            this.myModule = module;
        }

        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                RbenvGemsetsConfigFileListener.$$$reportNull$$$0(1);
            }
            for (VFileEvent vFileEvent : events) {
                if (!(vFileEvent instanceof VFileCreateEvent) && !(vFileEvent instanceof VFileContentChangeEvent)) continue;
                this.applyGemsetConfigChanged(vFileEvent);
            }
        }

        private void applyGemsetConfigChanged(@NotNull VFileEvent event) {
            if (event == null) {
                RbenvGemsetsConfigFileListener.$$$reportNull$$$0(2);
            }
            if (event.getRequestor() == RbenvGemsetManager.RBENV_GEMSETS_CONFIG_REQUESTOR || event.getFile() == null) {
                return;
            }
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(this.myModule);
            if (sdk == null) {
                return;
            }
            if (RbenvGemsetManager.isRbenvGemsetConfig(this.myModule, event.getFile())) {
                List<String> gemsets = RbenvGemsetManager.getCommandLineRbenvGemsets(this.myModule, sdk);
                MultiMap<String, String> map = RubySdkGemsetsSettings.getInstance().getOrCreateModuleSdkGemsetsMap(this.myModule);
                map.put((Object)sdk.getHomePath(), gemsets);
                RubySdkGemsetsSettings.getInstance().putModuleSdkGemsetsMap(this.myModule, map);
                RubySdkGemLibraryManager.getInstance().refresh();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvSdkRefresher$RbenvGemsetsConfigFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyGemsetConfigChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

