/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.notification.problem;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.version.management.RubySdkConfig;
import org.jetbrains.plugins.ruby.version.management.notification.action.ModuleAction;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H&J\n\u0010\u0014\u001a\u0004\u0018\u00010\bH&J\u0016\u0010\u0015\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0004J:\u0010\u0019\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00132\b\b\u0001\u0010\u001a\u001a\u00020\u00122\b\b\u0001\u0010\u001b\u001a\u00020\u00122\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001d\"\u00020\u0001H\u0004\u00a2\u0006\u0002\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/ruby/version/management/notification/problem/ModuleSdkProblem;", "", "module", "Lcom/intellij/openapi/module/Module;", "currentSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "actions", "", "Lorg/jetbrains/plugins/ruby/version/management/notification/action/ModuleAction;", "<init>", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/util/List;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getCurrentSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getActions", "()Ljava/util/List;", "getDescription", "", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "getBestAction", "getSdkConfigsDescription", "sdkConfigs", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/plugins/ruby/version/management/RubySdkConfig;", "messageWithCurrentSdk", "keyWithCurrentSdk", "key", "params", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "intellij.ruby.backend"})
public abstract class ModuleSdkProblem {
    @NotNull
    private final Module module;
    @Nullable
    private final Sdk currentSdk;
    @NotNull
    private final List<ModuleAction> actions;

    public ModuleSdkProblem(@NotNull Module module, @Nullable Sdk currentSdk, @NotNull List<? extends ModuleAction> actions) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        this.module = module;
        this.currentSdk = currentSdk;
        this.actions = actions;
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @Nullable
    protected final Sdk getCurrentSdk() {
        return this.currentSdk;
    }

    @NotNull
    public List<ModuleAction> getActions() {
        return this.actions;
    }

    @NotNull
    public abstract String getDescription();

    @Nullable
    public abstract ModuleAction getBestAction();

    @NotNull
    protected final String getSdkConfigsDescription(@NotNull Sequence<RubySdkConfig> sdkConfigs) {
        Intrinsics.checkNotNullParameter(sdkConfigs, (String)"sdkConfigs");
        return SequencesKt.joinToString$default((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map(sdkConfigs, ModuleSdkProblem::getSdkConfigsDescription$lambda$0)), null, null, null, (int)0, null, null, (int)63, null);
    }

    @NotNull
    protected final String messageWithCurrentSdk(@PropertyKey(resourceBundle="messages.RBundle") @NotNull String keyWithCurrentSdk, @PropertyKey(resourceBundle="messages.RBundle") @NotNull String key, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)keyWithCurrentSdk, (String)"keyWithCurrentSdk");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.currentSdk != null) {
            Object[] paramsWithCurrentSdk = ArraysKt.plus((Object[])Arrays.copyOf(params, params.length), (Object)this.currentSdk.getName());
            String string = RBundle.message((String)keyWithCurrentSdk, (Object[])Arrays.copyOf(paramsWithCurrentSdk, paramsWithCurrentSdk.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        String string = RBundle.message((String)key, (Object[])Arrays.copyOf(params, params.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final String getSdkConfigsDescription$lambda$0(RubySdkConfig it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.append((HtmlChunk)HtmlChunk.text((String)it.getFullName()).wrapWith("b"));
        builder2.append(HtmlChunk.text((String)(" (" + it.source() + ")")));
        return builder2.toString();
    }
}

