/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.chruby;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandlerBase;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.chruby.ChrubySdkData;

public final class ChrubyVersionManagerHandler
extends RubyVersionManagerHandlerBase<ChrubySdkData> {
    private static final Logger LOG = Logger.getInstance(ChrubyVersionManagerHandler.class);
    static final String DEFAULT_MANAGER_PATH = "/usr/local/share/chruby/chruby.sh";

    @Override
    @NotNull
    public String getId() {
        return "chruby";
    }

    @Override
    @NotNull
    public String getVersionManagerExecutableName() {
        return "chruby.sh";
    }

    @Override
    @NotNull
    protected List<String> patchCommands(@NotNull RubyRunner rubyRunner, @NotNull String versionManagerPath, @NotNull String distributionId, @NotNull List<String> commandsToPatch, @NotNull Map<String, String> env) {
        if (rubyRunner == null) {
            ChrubyVersionManagerHandler.$$$reportNull$$$0(0);
        }
        if (versionManagerPath == null) {
            ChrubyVersionManagerHandler.$$$reportNull$$$0(1);
        }
        if (distributionId == null) {
            ChrubyVersionManagerHandler.$$$reportNull$$$0(2);
        }
        if (commandsToPatch == null) {
            ChrubyVersionManagerHandler.$$$reportNull$$$0(3);
        }
        if (env == null) {
            ChrubyVersionManagerHandler.$$$reportNull$$$0(4);
        }
        ArrayList<String> chrubySetUp = new ArrayList<String>(Arrays.asList("chruby", distributionId));
        String rubyOpt = env.get("RUBYOPT");
        if (StringUtil.isNotEmpty((String)rubyOpt)) {
            commandsToPatch = ContainerUtil.prepend(commandsToPatch, (Object[])new String[]{"env", "RUBYOPT=" + rubyOpt});
        }
        List<String> list = rubyRunner.getCommandsSequence(Arrays.asList(".", versionManagerPath), chrubySetUp, commandsToPatch);
        if (list == null) {
            ChrubyVersionManagerHandler.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    protected boolean isMyPath(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            ChrubyVersionManagerHandler.$$$reportNull$$$0(6);
        }
        return interpreterPath.endsWith("/" + this.getVersionManagerExecutableName());
    }

    @Override
    @NotNull
    public ChrubySdkData createAdditionalData() {
        return new ChrubySdkData(this);
    }

    @Override
    @NotNull
    protected List<String> getAvailableDistributionsCommands(@NotNull RubyRunner runner, @NotNull String versionManagerPath) {
        if (runner == null) {
            ChrubyVersionManagerHandler.$$$reportNull$$$0(7);
        }
        if (versionManagerPath == null) {
            ChrubyVersionManagerHandler.$$$reportNull$$$0(8);
        }
        List<String> list = runner.wrapWithShell(false, false, ". " + versionManagerPath + " && chruby");
        if (list == null) {
            ChrubyVersionManagerHandler.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @NotNull
    protected List<String> processAvailableDistributionsOutput(@NotNull List<String> rawOutput) {
        if (rawOutput == null) {
            ChrubyVersionManagerHandler.$$$reportNull$$$0(10);
        }
        List list = ContainerUtil.map(rawOutput, it -> it.trim().replace("^\\*\\s*", ""));
        if (list == null) {
            ChrubyVersionManagerHandler.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @Nullable
    protected RubyVersionManagerSdkData doLoadLegacy(@NotNull Element rootElement, @NotNull String interpreterPath) {
        if (rootElement == null) {
            ChrubyVersionManagerHandler.$$$reportNull$$$0(12);
        }
        if (interpreterPath == null) {
            ChrubyVersionManagerHandler.$$$reportNull$$$0(13);
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public static ChrubyVersionManagerHandler getInstance() {
        ChrubyVersionManagerHandler chrubyVersionManagerHandler = Objects.requireNonNull((ChrubyVersionManagerHandler)RubyVersionManagerHandler.findHandler(o -> o instanceof ChrubyVersionManagerHandler));
        if (chrubyVersionManagerHandler == null) {
            ChrubyVersionManagerHandler.$$$reportNull$$$0(14);
        }
        return chrubyVersionManagerHandler;
    }

    @Override
    @NotNull
    protected String getStarterScriptName() {
        return "chruby_starter.sh";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 9, 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyRunner";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandsToPatch";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/chruby/ChrubyVersionManagerHandler";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawOutput";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/chruby/ChrubyVersionManagerHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "patchCommands";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributionsCommands";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "processAvailableDistributionsOutput";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "patchCommands";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMyPath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDistributionsCommands";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAvailableDistributionsOutput";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doLoadLegacy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 9, 11, 14 -> new IllegalStateException(string);
        };
    }
}

