/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.asdf;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.version.management.RubySdkConfig;
import org.jetbrains.plugins.ruby.version.management.RubyVersionAndGemsetSdkConfigFactory;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandlerBase;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.SdkInstaller;
import org.jetbrains.plugins.ruby.version.management.ShimsBasedVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.asdf.AsdfSdkData;
import org.jetbrains.plugins.ruby.version.management.asdf.AsdfSdkInstaller;
import org.jetbrains.plugins.ruby.version.management.asdf.ToolVersionsConfigFile;

public final class AsdfVersionManagerHandler
extends RubyVersionManagerHandlerBase<AsdfSdkData>
implements ShimsBasedVersionManagerHandler {
    @NotNull
    static final Path DEFAULT_HOME_PATH = Path.of(SystemProperties.getUserHome(), ".asdf");
    @NotNull
    static final Path INSTALLATIONS_RELATIVE_PATH = Path.of("installs", "ruby");
    @NotNull
    private static final Path BINARY_RELATIVE_PATH = Path.of("bin", "asdf");
    @NotNull
    private static final Path SHIMS_RELATIVE_PATH = Path.of("shims", new String[0]);
    @NotNull
    private static final String ASDF_RUBY_VERSION_ENV = "ASDF_RUBY_VERSION";
    private static final List<AsdfSdkInstaller> SDK_INSTALLERS = Collections.singletonList(new AsdfSdkInstaller());
    @NotNull
    static final Path DEFAULT_BIN_PATH = DEFAULT_HOME_PATH.resolve(BINARY_RELATIVE_PATH);

    @Override
    @NotNull
    public AsdfSdkData createAdditionalData() {
        return new AsdfSdkData(this);
    }

    @Override
    @NotNull
    public String getVersionManagerExecutableName() {
        return "asdf";
    }

    @Override
    protected boolean isMyPath(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(0);
        }
        return interpreterPath.endsWith("/" + this.getVersionManagerExecutableName());
    }

    @Override
    @NotNull
    protected List<String> getAvailableDistributionsCommands(@NotNull RubyRunner runner, @NotNull String versionManagerPath) {
        if (runner == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(1);
        }
        if (versionManagerPath == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(2);
        }
        List<String> list = Arrays.asList(versionManagerPath, "list", "ruby");
        if (list == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    protected List<String> processAvailableDistributionsOutput(@NotNull List<String> rawOutput) {
        if (rawOutput == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(4);
        }
        List<String> list = rawOutput.stream().map(s -> StringUtil.trim((String)s)).map(s -> StringUtil.trimStart((String)s, (String)"*")).filter(s -> StringUtil.isNotEmpty((String)s)).collect(Collectors.toList());
        if (list == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public Path computeShimsPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(6);
        }
        Path path = AsdfVersionManagerHandler.computeHomeByInterpreterPath(RubySdkAdditionalData.notNullFrom(sdk).getInterpreterPath(sdk)).resolve(SHIMS_RELATIVE_PATH);
        if (path == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(7);
        }
        return path;
    }

    @Override
    @NotNull
    protected List<String> patchCommands(@NotNull RubyRunner rubyRunner, @NotNull String versionManagerPath, @NotNull String distributionId, @NotNull List<String> commandsToPatch, @NotNull Map<String, String> env) {
        if (rubyRunner == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(8);
        }
        if (versionManagerPath == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(9);
        }
        if (distributionId == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(10);
        }
        if (commandsToPatch == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(11);
        }
        if (env == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(12);
        }
        if (!commandsToPatch.isEmpty()) {
            commandsToPatch.set(0, Paths.get(commandsToPatch.get(0), new String[0]).getFileName().toString());
        }
        String asdfBinPath = PathUtil.getParentPath((String)versionManagerPath);
        List<String> list = rubyRunner.getCommandsSequence(List.of("declare", "asdf_bin_path=" + asdfBinPath), List.of("export", "PATH=$PATH:$asdf_bin_path"), List.of("export", "ASDF_RUBY_VERSION=" + distributionId), ContainerUtil.prepend(commandsToPatch, (Object[])new String[]{versionManagerPath, "exec"}));
        if (list == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    @Nullable
    protected RubyVersionManagerSdkData<?> doLoadLegacy(@NotNull Element rootElement, @NotNull String interpreterPath) {
        if (rootElement == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(14);
        }
        if (interpreterPath == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(15);
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public static AsdfVersionManagerHandler getInstance() {
        AsdfVersionManagerHandler asdfVersionManagerHandler = Objects.requireNonNull((AsdfVersionManagerHandler)AsdfVersionManagerHandler.findHandler(o -> o instanceof AsdfVersionManagerHandler));
        if (asdfVersionManagerHandler == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(16);
        }
        return asdfVersionManagerHandler;
    }

    @Contract(pure=true)
    @NotNull
    private static Path computeHomeByInterpreterPath(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(17);
        }
        Path run2 = Paths.get(interpreterPath, new String[0]);
        for (int i = 0; i < 5; ++i) {
            if ((run2 = run2.getParent()) != null) continue;
            throw new NullPointerException("Interpreter path supposed to be valid, e.g: /home/user/.asdf/installs/ruby/2.5.1/bin/ruby");
        }
        Path path = run2;
        if (path == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(18);
        }
        return path;
    }

    @Override
    @NotNull
    protected String getStarterScriptName() {
        return "asdf_starter.sh";
    }

    @Override
    protected Collection<Class<? extends RubySdkConfig.Factory>> getSdkConfigFactories() {
        return List.of(ToolVersionsConfigFile.SdkConfigFactory.class, RubyVersionAndGemsetSdkConfigFactory.class);
    }

    @Override
    @NotNull
    public Collection<? extends SdkInstaller> getInstallers() {
        List<AsdfSdkInstaller> list = SDK_INSTALLERS;
        if (list == null) {
            AsdfVersionManagerHandler.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 13, 16, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPath";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/asdf/AsdfVersionManagerHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawOutput";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyRunner";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandsToPatch";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/asdf/AsdfVersionManagerHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributionsCommands";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "processAvailableDistributionsOutput";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeShimsPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "patchCommands";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "computeHomeByInterpreterPath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMyPath";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDistributionsCommands";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processAvailableDistributionsOutput";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeShimsPath";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "patchCommands";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doLoadLegacy";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "computeHomeByInterpreterPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 13, 16, 18, 19 -> new IllegalStateException(string);
        };
    }
}

