/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;

public interface SdkRefresher {
    public static final ExtensionPointName<SdkRefresher> EP_NAME = new ExtensionPointName("org.jetbrains.plugins.ruby.rubySdkRefresher");
    @NotNull
    public static final KeyWithDefaultValue<Boolean> isSdkRefreshRequestedKey = KeyWithDefaultValue.create((String)"isRubySdkRefreshRequested", (Object)false);

    @Contract(value="null -> false")
    public boolean isManagedSdk(@Nullable Sdk var1);

    public void refreshSDKs();

    public void refreshAsynchronously();

    @Nullable
    public String suggestSdkName(@NotNull String var1, @NotNull String var2, @NotNull RubyVersionManagerSdkData var3);

    public void initializeIfNecessary();

    default public void onProjectOpened(@NotNull Project project) {
        if (project == null) {
            SdkRefresher.$$$reportNull$$$0(0);
        }
    }

    public void enable();

    public boolean isEnabled();

    public static void forEach(@NotNull Consumer<? super SdkRefresher> action) {
        if (action == null) {
            SdkRefresher.$$$reportNull$$$0(1);
        }
        SdkRefresher.getRefreshers().forEach(action);
    }

    public static boolean isAutoRefreshable(@Nullable Sdk sdk) {
        return ContainerUtil.exists(SdkRefresher.getRefreshers(), it -> it.isManagedSdk(sdk));
    }

    public static boolean isAllEnabled() {
        return !ContainerUtil.exists(SdkRefresher.getRefreshers(), it -> !it.isEnabled());
    }

    @NotNull
    public static List<? extends SdkRefresher> getRefreshers() {
        List list = EP_NAME.getExtensionList();
        if (list == null) {
            SdkRefresher.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/SdkRefresher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/SdkRefresher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefreshers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onProjectOpened";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

