/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.version.management.RubySdkConfig;
import org.jetbrains.plugins.ruby.version.management.SdkActionHandler;
import org.jetbrains.plugins.ruby.version.management.SdkActionHandlerVmInstall;
import org.jetbrains.plugins.ruby.version.management.SdkActionHandlerVmUninstall;
import org.jetbrains.plugins.ruby.version.management.SdkInstaller;
import org.jetbrains.plugins.ruby.version.management.SdkRefresherVmBase;

public abstract class SdkInstallerVmBase
implements SdkInstaller {
    private static final Logger LOG = Logger.getInstance(SdkInstallerVmBase.class);

    @NotNull
    protected abstract SdkRefresherVmBase getSdkRefresher();

    @NotNull
    protected abstract List<String> getInstallCommand(@NotNull String var1, @NotNull String var2);

    @NotNull
    protected abstract List<String> getUninstallCommand(@NotNull String var1, @NotNull String var2);

    @Nullable
    protected String getVersionManagerPath() {
        Path path = this.getSdkRefresher().getVersionManagerPath();
        if (path == null) {
            return null;
        }
        return path.toString();
    }

    @Override
    public boolean isAvailable() {
        String versionManagerPath = this.getVersionManagerPath();
        if (versionManagerPath == null) {
            LOG.debug("Installer unavailable: version manager executable not found");
        }
        return versionManagerPath != null;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.getSdkRefresher().getVersionManagerHandler().getId();
        if (string == null) {
            SdkInstallerVmBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    public SdkActionHandler createInstallHandler(@NotNull Module module, @NotNull RubySdkConfig sdkConfig) {
        String versionManagerPath;
        if (module == null) {
            SdkInstallerVmBase.$$$reportNull$$$0(1);
        }
        if (sdkConfig == null) {
            SdkInstallerVmBase.$$$reportNull$$$0(2);
        }
        if ((versionManagerPath = this.getVersionManagerPath()) == null) {
            LOG.debug("Version manager executable not found, install handler not created");
            return null;
        }
        String version = sdkConfig.distName();
        return new SdkActionHandlerVmInstall(module, version, this.getInstallCommand(versionManagerPath, version), this);
    }

    @Override
    @Nullable
    public SdkActionHandler createUninstallHandler(@NotNull Module module, @NotNull String version) {
        String versionManagerPath;
        if (module == null) {
            SdkInstallerVmBase.$$$reportNull$$$0(3);
        }
        if (version == null) {
            SdkInstallerVmBase.$$$reportNull$$$0(4);
        }
        if ((versionManagerPath = this.getVersionManagerPath()) == null) {
            LOG.debug("Version manager executable not found, uninstall handler not created");
            return null;
        }
        return new SdkActionHandlerVmUninstall(module, version, this.getUninstallCommand(versionManagerPath, version), this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/SdkInstallerVmBase";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkConfig";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/SdkInstallerVmBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createInstallHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUninstallHandler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

