/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.version.management.RubySdkConfig;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;

public abstract class RubyVersionManagerSdkDataBase<Data extends RubyVersionManagerSdkDataBase<Data>>
extends RubyVersionManagerSdkData<Data> {
    @Tag(value="distribution-id")
    @Nullable
    protected String myDistributionId;
    @Tag(value="version-manager-path")
    @Nullable
    private String myVersionManagerPath;

    public RubyVersionManagerSdkDataBase(@NotNull RubyVersionManagerHandler<Data> handler) {
        if (handler == null) {
            RubyVersionManagerSdkDataBase.$$$reportNull$$$0(0);
        }
        super(handler);
    }

    @Override
    @NotNull
    protected Data copyTo(@NotNull Data target) {
        if (target == null) {
            RubyVersionManagerSdkDataBase.$$$reportNull$$$0(1);
        }
        RubyVersionManagerSdkData rubyVersionManagerSdkData = ((RubyVersionManagerSdkDataBase)((RubyVersionManagerSdkDataBase)target).withVersionManagerPath(this.getVersionManagerPath())).withDistributionId(this.getDistributionId());
        if (rubyVersionManagerSdkData == null) {
            RubyVersionManagerSdkDataBase.$$$reportNull$$$0(2);
        }
        return (Data)rubyVersionManagerSdkData;
    }

    @Override
    public boolean areGemsUserLocal(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyVersionManagerSdkDataBase.$$$reportNull$$$0(3);
        }
        return true;
    }

    @NotNull
    public String getVersionManagerPath() {
        String string = Objects.requireNonNull(this.myVersionManagerPath, "Getting before setting in " + this.getClass().getSimpleName());
        if (string == null) {
            RubyVersionManagerSdkDataBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    public final boolean hasVersionManagerPath() {
        return StringUtil.isNotEmpty((String)this.myVersionManagerPath);
    }

    @NotNull
    public Data withVersionManagerPath(@NotNull String versionManagerPath) {
        if (versionManagerPath == null) {
            RubyVersionManagerSdkDataBase.$$$reportNull$$$0(5);
        }
        this.assertWritable();
        this.myVersionManagerPath = versionManagerPath;
        RubyVersionManagerSdkDataBase rubyVersionManagerSdkDataBase = (RubyVersionManagerSdkDataBase)this.self();
        if (rubyVersionManagerSdkDataBase == null) {
            RubyVersionManagerSdkDataBase.$$$reportNull$$$0(6);
        }
        return (Data)rubyVersionManagerSdkDataBase;
    }

    @NotNull
    public String getDistributionId() {
        String string = Objects.requireNonNull(this.myDistributionId, "Getting before setting" + this.getClass().getSimpleName());
        if (string == null) {
            RubyVersionManagerSdkDataBase.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public Data withDistributionId(@NotNull String distributionId) {
        if (distributionId == null) {
            RubyVersionManagerSdkDataBase.$$$reportNull$$$0(8);
        }
        this.assertWritable();
        this.myDistributionId = distributionId;
        RubyVersionManagerSdkDataBase rubyVersionManagerSdkDataBase = (RubyVersionManagerSdkDataBase)this.self();
        if (rubyVersionManagerSdkDataBase == null) {
            RubyVersionManagerSdkDataBase.$$$reportNull$$$0(9);
        }
        return (Data)rubyVersionManagerSdkDataBase;
    }

    @Override
    public boolean isMatching(@NotNull RubySdkConfig sdkConfig, @NotNull Sdk sdk) {
        if (sdkConfig == null) {
            RubyVersionManagerSdkDataBase.$$$reportNull$$$0(10);
        }
        if (sdk == null) {
            RubyVersionManagerSdkDataBase.$$$reportNull$$$0(11);
        }
        return this.isMatchingVmHandler(sdkConfig) && StringUtil.startsWith((CharSequence)RubyVersionUtil.normalizeVersionForVms(this.getDistributionId()), (CharSequence)sdkConfig.distName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RubyVersionManagerSdkDataBase base = (RubyVersionManagerSdkDataBase)o;
        return Objects.equals(this.myDistributionId, base.myDistributionId) && Objects.equals(this.myVersionManagerPath, base.myVersionManagerPath);
    }

    public int hashCode() {
        int result = this.myVersionManagerPath != null ? this.myVersionManagerPath.hashCode() : 0;
        result = 31 * result + (this.myDistributionId != null ? this.myDistributionId.hashCode() : 0);
        return result;
    }

    @NotNull
    public static RubyVersionManagerSdkDataBase notNullFrom(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyVersionManagerSdkDataBase.$$$reportNull$$$0(12);
        }
        RubyVersionManagerSdkDataBase<?> rubyVersionManagerSdkDataBase = Objects.requireNonNull(RubyVersionManagerSdkDataBase.from(sdk));
        if (rubyVersionManagerSdkDataBase == null) {
            RubyVersionManagerSdkDataBase.$$$reportNull$$$0(13);
        }
        return rubyVersionManagerSdkDataBase;
    }

    @Contract(value="null -> null")
    @Nullable
    public static RubyVersionManagerSdkDataBase<?> from(@Nullable Sdk sdk) {
        return (RubyVersionManagerSdkDataBase)ObjectUtils.tryCast((Object)RubyVersionManagerSdkData.from(sdk), RubyVersionManagerSdkDataBase.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 7, 9, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/RubyVersionManagerSdkDataBase";
                break;
            }
            case 3: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/RubyVersionManagerSdkDataBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionManagerPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withVersionManagerPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistributionId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withDistributionId";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "areGemsUserLocal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withVersionManagerPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withDistributionId";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isMatching";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "notNullFrom";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 7, 9, 13 -> new IllegalStateException(string);
        };
    }
}

