/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.version.management.RubySdkConfig;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;

public final class RubyVersionAndGemsetSdkConfigFactory
implements RubySdkConfig.Factory {
    private static final String SOURCE_STRING = ".ruby-version + .ruby-gemset";
    private static final List<String> SOURCE_FILENAMES = List.of(".ruby-version", ".ruby-gemset");

    @Override
    @NotNull
    public Collection<String> getSourceFilenames() {
        List<String> list = SOURCE_FILENAMES;
        if (list == null) {
            RubyVersionAndGemsetSdkConfigFactory.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public RubySdkConfig createFromRoot(@NotNull VirtualFile root, @NotNull RubyVersionManagerHandler vmHandler) {
        String rubyGemset;
        VirtualFile rubyVersionFile;
        if (root == null) {
            RubyVersionAndGemsetSdkConfigFactory.$$$reportNull$$$0(1);
        }
        if (vmHandler == null) {
            RubyVersionAndGemsetSdkConfigFactory.$$$reportNull$$$0(2);
        }
        if ((rubyVersionFile = root.findChild(".ruby-version")) == null) {
            return null;
        }
        String rubyVersion = LoadTextUtil.loadText((VirtualFile)rubyVersionFile).toString().strip();
        if (rubyVersion.isEmpty()) {
            return null;
        }
        String distName = RubyVersionUtil.normalizeVersionForVms(rubyVersion);
        String[] versionAndGemset = distName.split("@");
        if (versionAndGemset.length > 1) {
            return new RubySdkConfig(versionAndGemset[0], versionAndGemset[1], ".ruby-version", vmHandler);
        }
        VirtualFile rubyGemsetFile = root.findChild(".ruby-gemset");
        if (rubyGemsetFile != null && !(rubyGemset = LoadTextUtil.loadText((VirtualFile)rubyGemsetFile).toString().strip()).isEmpty()) {
            return new RubySdkConfig(distName, rubyGemset, SOURCE_STRING, vmHandler);
        }
        return new RubySdkConfig(distName, null, ".ruby-version", vmHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/RubyVersionAndGemsetSdkConfigFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFilenames";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/RubyVersionAndGemsetSdkConfigFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFromRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

