/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkType;

public class RubySdkInfo {
    @NotNull
    private final String myPathToVersionManager;
    @NotNull
    private final VirtualFile myInterpreterHome;
    @Nullable
    private final RubySdkType mySdkType;
    @Nullable
    private final String myRubyName;
    @Nullable
    private final String myGemSet;

    public RubySdkInfo(@NotNull String pathToVersionManager, @NotNull VirtualFile interpreterHome, @Nullable String gemSet) {
        if (pathToVersionManager == null) {
            RubySdkInfo.$$$reportNull$$$0(0);
        }
        if (interpreterHome == null) {
            RubySdkInfo.$$$reportNull$$$0(1);
        }
        this.myPathToVersionManager = pathToVersionManager;
        this.myInterpreterHome = interpreterHome;
        this.myGemSet = gemSet;
        String name = StringUtil.toLowerCase((String)this.myInterpreterHome.getName());
        if (name.startsWith("ruby") || name.startsWith("ree") || name.startsWith("macruby") || name.startsWith("rbx") || name.matches("^\\d.*")) {
            this.myRubyName = "ruby";
            this.mySdkType = RubySdkType.getInstance();
        } else if (name.startsWith("jruby")) {
            this.myRubyName = "jruby";
            this.mySdkType = JRubySdkType.getInstance();
        } else if (name.startsWith("ir")) {
            this.myRubyName = "ir";
            this.mySdkType = RubySdkType.getInstance();
        } else if (name.startsWith("maglev")) {
            this.myRubyName = "maglev-ruby";
            this.mySdkType = RubySdkType.getInstance();
        } else if (name.startsWith("truffleruby")) {
            this.myRubyName = "truffleruby";
            this.mySdkType = RubySdkType.getInstance();
        } else {
            this.myRubyName = null;
            this.mySdkType = null;
        }
    }

    @Nullable
    public String getRubyName() {
        return this.myRubyName;
    }

    @Nullable
    public final String getGemSet() {
        return this.myGemSet;
    }

    @NotNull
    public VirtualFile getInterpreterHome() {
        VirtualFile virtualFile = this.myInterpreterHome;
        if (virtualFile == null) {
            RubySdkInfo.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @NotNull
    public String getPathToVersionManager() {
        String string = this.myPathToVersionManager;
        if (string == null) {
            RubySdkInfo.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public RubySdkType getSdkType() {
        return this.mySdkType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RubySdkInfo info = (RubySdkInfo)o;
        return this.myInterpreterHome.equals(info.myInterpreterHome) && Objects.equals((Object)this.mySdkType, (Object)info.mySdkType) && Objects.equals(this.myGemSet, info.myGemSet);
    }

    public int hashCode() {
        int result = this.myInterpreterHome.hashCode();
        result = 31 * result + (this.mySdkType != null ? this.mySdkType.hashCode() : 0);
        result = 31 * result + (this.myGemSet != null ? this.myGemSet.hashCode() : 0);
        return result;
    }

    @Nullable
    public VirtualFile getRubyExecutable() {
        StringBuilder executableName = new StringBuilder();
        executableName.append(this.myRubyName);
        if (SystemInfo.isWindows) {
            executableName.append(".exe");
        }
        return this.myInterpreterHome.findFileByRelativePath("bin/" + String.valueOf(executableName));
    }

    public String toString() {
        return "RubySdkInfo{myPathToVersionManager='" + this.myPathToVersionManager + "', myInterpreterHome=" + String.valueOf(this.myInterpreterHome) + ", mySdkType=" + String.valueOf((Object)this.mySdkType) + ", myRubyName='" + this.myRubyName + "', myGemSet='" + this.myGemSet + "'}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToVersionManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterHome";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/RubySdkInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/RubySdkInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterHome";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToVersionManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

