/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.utils;

import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.SplitterProportionsData;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.GuiUtils;
import com.intellij.util.PlatformUtils;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.ui.SdkComparator;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

public final class RubyUIUtil {
    public static final @NlsContexts.ConfigurableName @NlsSafe String RUBY_UI_NAME = "Ruby";
    @NlsSafe
    public static final @NlsActions.ActionText String RAILS_UI_NAME = "Rails";
    @NlsSafe
    public static final @NlsActions.ActionText String RSPEC_UI_NAME = "Rspec";
    private static final Predicate<Sdk> IS_PURE_RBENV_SDK = sdk -> !RbenvGemsetManager.isGemsetSdk(sdk);

    private RubyUIUtil() {
    }

    public static void makeSplitterSettingsExternalizable(JSplitPane splitPane, String serializationID, Disposable disposable) {
        SplitterProportionsDataImpl splitterProportions = new SplitterProportionsDataImpl();
        splitterProportions.externalizeFromDimensionService(serializationID);
        Container container = splitPane.getParent();
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)splitPane);
        final Splitter splitter = (Splitter)container.getComponent(0);
        SwingUtilities.invokeLater(() -> RubyUIUtil.lambda$makeSplitterSettingsExternalizable$1((SplitterProportionsData)splitterProportions, container, splitter, serializationID));
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                splitter.dispose();
            }
        });
    }

    public static CollectionComboBoxModel<Sdk> createSdkComboBoxModel(@NotNull Collection<Sdk> sdks, @Nullable Sdk selectedSdk) {
        if (sdks == null) {
            RubyUIUtil.$$$reportNull$$$0(0);
        }
        List items = sdks.stream().filter(IS_PURE_RBENV_SDK).sorted(SdkComparator.SDK_COMPARATOR).collect(Collectors.toList());
        return new CollectionComboBoxModel(items, (Object)selectedSdk);
    }

    public static DisplayPriority getDisplayPriority() {
        return PlatformUtils.isRubyMine() ? DisplayPriority.KEY_LANGUAGE_SETTINGS : DisplayPriority.LANGUAGE_SETTINGS;
    }

    public static int showYesNoDialogFromEDT(@Nullable Project project, @NlsContexts.DialogMessage @NotNull String message, @NlsContexts.DialogTitle @NotNull String title, @Nullable Icon icon) {
        if (message == null) {
            RubyUIUtil.$$$reportNull$$$0(1);
        }
        if (title == null) {
            RubyUIUtil.$$$reportNull$$$0(2);
        }
        MessageDialogBuilder.YesNo dialog = MessageDialogBuilder.yesNo((String)title, (String)message, (Icon)icon);
        return RubyUIUtil.showYesNoDialogFromEDT(dialog, project);
    }

    public static int showYesNoDialogFromEDT(@Nullable Project project, @NlsContexts.DialogMessage @NotNull String message, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Button @NotNull String yesText, @NlsContexts.Button @NotNull String noText, @Nullable Icon icon) {
        if (message == null) {
            RubyUIUtil.$$$reportNull$$$0(3);
        }
        if (title == null) {
            RubyUIUtil.$$$reportNull$$$0(4);
        }
        if (yesText == null) {
            RubyUIUtil.$$$reportNull$$$0(5);
        }
        if (noText == null) {
            RubyUIUtil.$$$reportNull$$$0(6);
        }
        MessageDialogBuilder.YesNo dialog = MessageDialogBuilder.yesNo((String)title, (String)message, (Icon)icon);
        dialog.yesText(yesText);
        dialog.noText(noText);
        return RubyUIUtil.showYesNoDialogFromEDT(dialog, project);
    }

    private static int showYesNoDialogFromEDT(@NotNull MessageDialogBuilder.YesNo dialog, @Nullable Project project) {
        if (dialog == null) {
            RubyUIUtil.$$$reportNull$$$0(7);
        }
        int[] resultContainer = new int[]{0};
        ApplicationManager.getApplication().invokeAndWait(() -> {
            resultContainer[0] = dialog.ask(project) ? 0 : 1;
        });
        return resultContainer[0];
    }

    private static /* synthetic */ void lambda$makeSplitterSettingsExternalizable$1(final SplitterProportionsData splitterProportions, final Container container, Splitter splitter, final String serializationID) {
        splitterProportions.restoreSplitterProportions((Component)container);
        splitter.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("proportion")) {
                    splitterProportions.saveSplitterProportions((Component)container);
                    splitterProportions.externalizeToDimensionService(serializationID);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yesText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/utils/RubyUIUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createSdkComboBoxModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showYesNoDialogFromEDT";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

