/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class ProjectQueues
implements Disposable {
    @NotNull
    private final Project myProject;
    private final Map<@NlsSafe String, BackgroundTaskQueue> myBackgroundQueues;
    private final Map<String, MergingUpdateQueue> myMergingUpdateQueues;
    private volatile boolean myDisposed;

    public ProjectQueues(@NotNull Project project) {
        if (project == null) {
            ProjectQueues.$$$reportNull$$$0(0);
        }
        this.myBackgroundQueues = new ConcurrentHashMap<String, BackgroundTaskQueue>();
        this.myMergingUpdateQueues = new ConcurrentHashMap<String, MergingUpdateQueue>();
        this.myDisposed = false;
        this.myProject = project;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ProjectQueues.$$$reportNull$$$0(1);
        }
        return project;
    }

    public void queue(@NlsContexts.ProgressTitle @NotNull String queueTitle, @NotNull Task.Backgroundable task) {
        if (queueTitle == null) {
            ProjectQueues.$$$reportNull$$$0(2);
        }
        if (task == null) {
            ProjectQueues.$$$reportNull$$$0(3);
        }
        if (this.myDisposed) {
            throw new AssertionError((Object)"Already disposed");
        }
        this.myBackgroundQueues.computeIfAbsent(queueTitle, title -> new BackgroundTaskQueue(this.getProject(), title)).run(task);
    }

    @TestOnly
    public void waitForExecutedInTests(@NotNull String title) {
        if (title == null) {
            ProjectQueues.$$$reportNull$$$0(4);
        }
        BackgroundTaskQueue queue = this.myBackgroundQueues.get(title);
        queue.waitForTasksToFinish();
    }

    public void queue(@NotNull String queueTitle, @NotNull Update update, @NotNull Supplier<? extends MergingUpdateQueue> queueProducer) {
        if (queueTitle == null) {
            ProjectQueues.$$$reportNull$$$0(5);
        }
        if (update == null) {
            ProjectQueues.$$$reportNull$$$0(6);
        }
        if (queueProducer == null) {
            ProjectQueues.$$$reportNull$$$0(7);
        }
        if (this.myDisposed) {
            throw new AssertionError((Object)"Already disposed");
        }
        this.myMergingUpdateQueues.computeIfAbsent(queueTitle, it -> {
            MergingUpdateQueue newQueue = (MergingUpdateQueue)queueProducer.get();
            Disposer.register((Disposable)this, (Disposable)newQueue);
            return newQueue;
        }).queue(update);
    }

    public void dispose() {
        this.myDisposed = true;
    }

    @NotNull
    public static ProjectQueues getInstance(@NotNull Project project) {
        if (project == null) {
            ProjectQueues.$$$reportNull$$$0(8);
        }
        ProjectQueues projectQueues = (ProjectQueues)project.getService(ProjectQueues.class);
        if (projectQueues == null) {
            ProjectQueues.$$$reportNull$$$0(9);
        }
        return projectQueues;
    }

    @NotNull
    public static ProjectQueues getInstance(@NotNull Module module) {
        if (module == null) {
            ProjectQueues.$$$reportNull$$$0(10);
        }
        return ProjectQueues.getInstance(module.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/util/ProjectQueues";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queueTitle";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queueProducer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/util/ProjectQueues";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "queue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "waitForExecutedInTests";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 9 -> new IllegalStateException(string);
        };
    }
}

