/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.util;

import com.intellij.openapi.util.Pair;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BiOptional<A, B> {
    private static final BiOptional<?, ?> EMPTY = new BiOptional();
    @Nullable
    private final A myFirst;
    @Nullable
    private final B mySecond;

    private BiOptional() {
        this.myFirst = null;
        this.mySecond = null;
    }

    private BiOptional(@NotNull A first, @NotNull B second) {
        if (first == null) {
            BiOptional.$$$reportNull$$$0(0);
        }
        if (second == null) {
            BiOptional.$$$reportNull$$$0(1);
        }
        this.myFirst = first;
        this.mySecond = second;
    }

    @NotNull
    public BiOptional<A, B> filter(@NotNull BiPredicate<? super A, ? super B> predicate) {
        if (predicate == null) {
            BiOptional.$$$reportNull$$$0(2);
        }
        return this.isPresent() && predicate.test(this.myFirst, this.mySecond) ? this : BiOptional.empty();
    }

    @NotNull
    public Pair<A, B> get() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return new Pair(this.myFirst, this.mySecond);
    }

    @NotNull
    public A getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        A a = Objects.requireNonNull(this.myFirst);
        if (a == null) {
            BiOptional.$$$reportNull$$$0(3);
        }
        return a;
    }

    @NotNull
    public B getSecond() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        B b = Objects.requireNonNull(this.mySecond);
        if (b == null) {
            BiOptional.$$$reportNull$$$0(4);
        }
        return b;
    }

    @NotNull
    public Optional<A> first() {
        Optional<A> optional = Optional.ofNullable(this.myFirst);
        if (optional == null) {
            BiOptional.$$$reportNull$$$0(5);
        }
        return optional;
    }

    @NotNull
    public <U, S> BiOptional<U, S> flatMap(@NotNull BiFunction<? super A, ? super B, BiOptional<? extends U, ? extends S>> mapper) {
        if (mapper == null) {
            BiOptional.$$$reportNull$$$0(6);
        }
        if (!this.isPresent()) {
            return BiOptional.empty();
        }
        BiOptional<? extends U, ? extends S> biOptional = mapper.apply(this.myFirst, this.mySecond);
        if (biOptional == null) {
            BiOptional.$$$reportNull$$$0(7);
        }
        return biOptional;
    }

    public void ifPresent(@NotNull BiConsumer<A, B> consumer) {
        if (consumer == null) {
            BiOptional.$$$reportNull$$$0(8);
        }
        if (!this.isEmpty()) {
            consumer.accept(this.myFirst, this.mySecond);
        }
    }

    public boolean isEmpty() {
        return this.myFirst == null || this.mySecond == null;
    }

    public boolean isPresent() {
        return this.myFirst != null && this.mySecond != null;
    }

    @NotNull
    public <U> Optional<U> map(@NotNull BiFunction<? super A, ? super B, ? extends U> mapper) {
        if (mapper == null) {
            BiOptional.$$$reportNull$$$0(9);
        }
        Optional<Object> optional = this.isPresent() ? Optional.ofNullable(mapper.apply(this.myFirst, this.mySecond)) : Optional.empty();
        if (optional == null) {
            BiOptional.$$$reportNull$$$0(10);
        }
        return optional;
    }

    @NotNull
    public Optional<B> second() {
        Optional<B> optional = Optional.ofNullable(this.mySecond);
        if (optional == null) {
            BiOptional.$$$reportNull$$$0(11);
        }
        return optional;
    }

    @NotNull
    public static <A, B> BiOptional<A, B> empty() {
        BiOptional<?, ?> biOptional = EMPTY;
        if (biOptional == null) {
            BiOptional.$$$reportNull$$$0(12);
        }
        return biOptional;
    }

    @NotNull
    public static <A, B> BiOptional<A, B> of(@Nullable A first, @Nullable B second) {
        return first != null && second != null ? new BiOptional<A, B>(first, second) : BiOptional.empty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 7, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/util/BiOptional";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/util/BiOptional";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirst";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecond";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "first";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "flatMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "second";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "flatMap";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ifPresent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 7, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

