/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.structure.RubyStructureViewModel;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;
import org.jetbrains.plugins.ruby.testing.testunit.structure.RTUnitStructureViewElement;

public class RTUnitStructureViewModel
extends RubyStructureViewModel {
    protected static final Class[] TUNIT_SUITABLE_CLASSES = (Class[])Arrays.copyOf(SUITABLE_CLASSES, SUITABLE_CLASSES.length + 1, Class[].class);
    private final boolean myAllowTestClosureSyntax;

    public RTUnitStructureViewModel(RFile psiFile, @Nullable Editor editor, boolean allowTestClosureSyntax) {
        super(psiFile, editor);
        this.myAllowTestClosureSyntax = allowTestClosureSyntax;
    }

    @Override
    protected boolean isSuitable(PsiElement element) {
        return super.isSuitable(element) || (element instanceof RCall || element instanceof RBlockCall) && (TestUnitUtil.isTestClosureCall((RPossibleCall)element) || TestUnitUtil.isTestClosureSetupTeardownCall((RPossibleCall)element));
    }

    @Override
    @NotNull
    public StructureViewTreeElement getRoot() {
        return new RTUnitStructureViewElement((RPsiElement)this.getPsiFile(), false);
    }

    @Override
    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        if (super.isAlwaysLeaf(element)) {
            return true;
        }
        Object value = element.getValue();
        return value instanceof RPossibleCall && (TestUnitUtil.isTestClosureCall((RPossibleCall)value) || TestUnitUtil.isTestClosureSetupTeardownCall((RPossibleCall)value));
    }

    @Override
    public boolean isAutoExpand(@NotNull StructureViewTreeElement element) {
        if (element == null) {
            RTUnitStructureViewModel.$$$reportNull$$$0(0);
        }
        return super.isAutoExpand(element) || element.getValue() instanceof RContainer;
    }

    @Override
    protected Class @NotNull [] getSuitableClasses() {
        Class[] classArray = this.myAllowTestClosureSyntax ? TUNIT_SUITABLE_CLASSES : SUITABLE_CLASSES;
        if (classArray == null) {
            RTUnitStructureViewModel.$$$reportNull$$$0(1);
        }
        return classArray;
    }

    static {
        RTUnitStructureViewModel.TUNIT_SUITABLE_CLASSES[RTUnitStructureViewModel.SUITABLE_CLASSES.length] = RBlockCall.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/testunit/structure/RTUnitStructureViewModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/structure/RTUnitStructureViewModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAutoExpand";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

