/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit.structure;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.structure.RubyStructureViewElement;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

public class RTUnitStructureViewElement
extends RubyStructureViewElement {
    private static final Logger LOG = Logger.getInstance(RTUnitStructureViewElement.class);

    public RTUnitStructureViewElement(@Nullable RPsiElement element, boolean inherited) {
        super(element, inherited);
    }

    @Override
    protected List<? extends RPsiElement> getElementPsiChildren() {
        RPsiElement element = (RPsiElement)this.getElement();
        return element instanceof RContainer ? ((RContainer)element).getStatements() : Collections.emptyList();
    }

    @Override
    protected boolean processPsiChild(@NotNull RPsiElement child, @NotNull Collection<RPsiElement> elements) {
        RPossibleCall possibleCall;
        if (child == null) {
            RTUnitStructureViewElement.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            RTUnitStructureViewElement.$$$reportNull$$$0(1);
        }
        if (super.processPsiChild(child, elements)) {
            return true;
        }
        if ((child instanceof RCall || child instanceof RBlockCall) && (TestUnitUtil.isTestClosureCall(possibleCall = (RPossibleCall)child) || TestUnitUtil.isTestClosureSetupTeardownCall(possibleCall))) {
            elements.add(child);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected RubyStructureViewElement createTreeElement(@NotNull RPsiElement psiElement, boolean inherited) {
        if (psiElement == null) {
            RTUnitStructureViewElement.$$$reportNull$$$0(2);
        }
        return new RTUnitStructureViewElement(psiElement, inherited);
    }

    @Override
    @NotNull
    public ItemPresentation getPresentation() {
        RMethod rMethod;
        RPsiElement element = (RPsiElement)this.getElement();
        if (element instanceof RPossibleCall) {
            RPossibleCall possibleCall = (RPossibleCall)element;
            Object openedAndCloseIcons = TestUnitUtil.isTestClosureCall(possibleCall) ? Pair.create((Object)AllIcons.Nodes.Test, (Object)AllIcons.Nodes.Test) : (TestUnitUtil.isTestClosureSetupTeardownCall(possibleCall) ? Pair.create((Object)AllIcons.Nodes.Method, (Object)AllIcons.Nodes.Method) : null);
            if (openedAndCloseIcons != null) {
                ItemPresentation presentation = RTUnitStructureViewElement.getPresentation(element);
                return new PresentationData(presentation.getPresentableText(), null, (Icon)openedAndCloseIcons.second, null);
            }
        } else if (element instanceof RMethod && TestUnitUtil.isUnitTestMethod(rMethod = (RMethod)element) && rMethod.getVisibility() == Visibility.PUBLIC) {
            ItemPresentation presentation = RTUnitStructureViewElement.getPresentation(element);
            Icon icon = AllIcons.Nodes.Test;
            return new PresentationData(presentation.getPresentableText(), null, icon, null);
        }
        ItemPresentation itemPresentation = super.getPresentation();
        if (itemPresentation == null) {
            RTUnitStructureViewElement.$$$reportNull$$$0(3);
        }
        return itemPresentation;
    }

    private static ItemPresentation getPresentation(RPsiElement value) {
        ItemPresentation presentation = value.getPresentation();
        if (presentation == null) {
            LOG.error("Presentation isn't defined for " + value.getClass().getName() + ".\n" + value.getText());
        }
        return presentation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/testunit/structure/RTUnitStructureViewElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/structure/RTUnitStructureViewElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processPsiChild";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTreeElement";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

