/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit.structure;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.structure.RubyFileStructureViewProvider;
import org.jetbrains.plugins.ruby.testing.RubyTestFrameworkDetector;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;
import org.jetbrains.plugins.ruby.testing.testunit.structure.MinitestSpecStructureViewModel;

public final class MinitestSpecStructureViewProvider
implements RubyFileStructureViewProvider {
    @Override
    @Nullable
    public StructureViewBuilder createStructureViewBuilder(final @NotNull RFile file) {
        RubyTestFrameworkDetector.Result framework;
        if (file == null) {
            MinitestSpecStructureViewProvider.$$$reportNull$$$0(0);
        }
        if ((framework = (RubyTestFrameworkDetector.Result)((Object)ReadAction.compute(() -> {
            if (!file.isValid()) {
                return null;
            }
            return RubyTestFrameworkDetector.detectFrameworkForFile(file);
        }))) != RubyTestFrameworkDetector.Result.MINITEST || !TestUnitUtil.isFileWithValidMinitestFileName((PsiFile)file)) {
            return null;
        }
        MyVisitor visitor = new MyVisitor();
        file.acceptChildren((PsiElementVisitor)visitor);
        if (visitor.containsExampleGroup()) {
            return new TreeBasedStructureViewBuilder(){

                @NotNull
                public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                    return new MinitestSpecStructureViewModel(file, editor);
                }

                public boolean isRootNodeShown() {
                    return false;
                }
            };
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/ruby/testing/testunit/structure/MinitestSpecStructureViewProvider", "createStructureViewBuilder"));
    }

    private static class MyVisitor
    extends RubyRecursiveElementVisitor {
        private ThreeState myContainsExampleGroup = ThreeState.UNSURE;

        private MyVisitor() {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (this.myContainsExampleGroup == ThreeState.UNSURE) {
                super.visitElement(element);
            }
        }

        public void visitRDoBlockCall(@NotNull RDoBlockCall rDoBlockCall) {
            if (rDoBlockCall == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if (TestUnitUtil.MINITEST_SPEC_GROUP_CALL_SHORT_NAMES.contains(rDoBlockCall.getCommand())) {
                this.myContainsExampleGroup = ThreeState.YES;
            } else if ("test".equals(rDoBlockCall.getCommand())) {
                this.myContainsExampleGroup = ThreeState.NO;
            } else {
                super.visitRDoBlockCall(rDoBlockCall);
            }
        }

        public void visitRMethod(@NotNull RMethod rMethod) {
            if (rMethod == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if (TestUnitUtil.isUnitTestMethod(rMethod)) {
                this.myContainsExampleGroup = ThreeState.NO;
            } else {
                super.visitRMethod(rMethod);
            }
        }

        public boolean containsExampleGroup() {
            return this.myContainsExampleGroup == ThreeState.YES;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rDoBlockCall";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rMethod";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/structure/MinitestSpecStructureViewProvider$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRDoBlockCall";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

