/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit.runConfigurations;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationExtensionsManager;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.testing.RubyTestFrameworkDetector;
import org.jetbrains.plugins.ruby.testing.RubyTestFrameworksUtil;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.shoulda.ShouldaUtil;
import org.jetbrains.plugins.ruby.testing.testunit.RTestUnitUtil;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RTestUnitRunConfiguration;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitRunConfigurationType;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

public final class TestUnitRunConfigurationProducer
extends LazyRunConfigurationProducer<RTestUnitRunConfiguration> {
    public static final String TESTUNIT_FOLDER_LOADPATH_ARG = "-Itest";

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = TestUnitRunConfigurationType.getInstance().getConfigurationFactories()[0];
        if (configurationFactory == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    @Nullable
    private static VirtualFile getTestScriptFile(Location<?> location) {
        PsiElement locationElement = location.getPsiElement();
        RFile containingFile = RubyPsiUtil.getRFile(locationElement);
        if (containingFile == null || location.getVirtualFile() == null) {
            return null;
        }
        VirtualFile file = containingFile.getVirtualFile();
        assert (file != null);
        if (!TestUnitUtil.isFileWithValidTestUnitFileName((PsiFile)containingFile) && !TestUnitUtil.isFileWithValidMinitestFileName((PsiFile)containingFile)) {
            return null;
        }
        return file;
    }

    @NotNull
    private static List<String> getLoadPathArgument(String workingDir) {
        if (workingDir == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                TestUnitRunConfigurationProducer.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<String> folderList = new ArrayList<String>();
        if (FileUtil.exists((String)(workingDir + File.separator + "lib"))) {
            folderList.add("lib");
        }
        if (FileUtil.exists((String)(workingDir + File.separator + "test"))) {
            folderList.add("test");
        }
        if (folderList.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                TestUnitRunConfigurationProducer.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = ContainerUtil.map(folderList, it -> "-I" + it);
        if (list == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean setupConfigurationFromContext(@NotNull RTestUnitRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Location location;
        if (configuration == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (sourceElement == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if ((location = context.getLocation()) == null) {
            return false;
        }
        List<VirtualFile> files = TestUnitRunConfigurationProducer.getFilesFromContextAndLocation(context, location);
        if (files.isEmpty()) {
            return false;
        }
        PsiElement locationElement = location.getPsiElement();
        RFile containingFile = RubyPsiUtil.getRFile(locationElement);
        PsiDirectory containingDirectory = (PsiDirectory)ObjectUtils.tryCast((Object)locationElement, PsiDirectory.class);
        if (containingDirectory == null && (containingFile == null || TestUnitRunConfigurationProducer.isRSpecFile(containingFile))) {
            return false;
        }
        if (containingDirectory != null && (!context.containsMultipleSelection() || TestUnitRunConfigurationProducer.isRSpecDirectory(containingDirectory))) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)locationElement);
        if (!RModuleUtil.getInstance().hasRubySupport(module)) {
            return false;
        }
        String name = RubyTestFrameworksUtil.createConfName(files);
        String methodFilterName = null;
        AbstractRubyTestsRunConfigurationParams.TestType testType = null;
        RPsiElement rPsiElement = RubyPsiUtilCore.getCoveringRPsiElement((PsiElement)locationElement);
        if (rPsiElement != null || containingDirectory != null) {
            RContainer currentContainer = (RContainer)PsiTreeUtil.getParentOfType((PsiElement)rPsiElement, RContainer.class, (boolean)false);
            RClass outerClass = (RClass)PsiTreeUtil.getParentOfType((PsiElement)currentContainer, RClass.class, (boolean)false);
            if (currentContainer instanceof RMethod && RTestUnitUtil.hasValidTestNameAndNotSingleton((RMethod)currentContainer) && outerClass != null && RTestUnitUtil.isUnitTestCaseLikeClass(outerClass) && outerClass == currentContainer.getParentContainer()) {
                String containerName = currentContainer.getName();
                methodFilterName = (String)ObjectUtils.doIfNotNull((Object)containerName, TestUnitUtil::wrapWithRegexpStartEnd);
                name = currentContainer.getFQN().getShortName();
                testType = AbstractRubyTestsRunConfigurationParams.TestType.TEST_METHOD;
            } else if (rPsiElement != null && TestUnitUtil.isInMinitestSpecExampleOrGroupRegion((PsiElement)rPsiElement)) {
                Pair<String, String> nameAndFilter = TestUnitUtil.determineMinitestSpecConfigurationNameAndFilter(module, (PsiElement)rPsiElement);
                if (nameAndFilter != null) {
                    name = (String)nameAndFilter.first;
                    methodFilterName = (String)nameAndFilter.second;
                    testType = AbstractRubyTestsRunConfigurationParams.TestType.TEST_METHOD;
                }
            } else if (outerClass != null && RTestUnitUtil.isUnitTestCaseLikeClass(outerClass)) {
                Ref testNameRef = new Ref((Object)name);
                Ref methodNameRef = new Ref();
                TestUnitRunConfigurationProducer.determineParamsForLocationsInClass(rPsiElement, (Ref<String>)testNameRef, (Ref<String>)methodNameRef);
                name = (String)testNameRef.get();
                methodFilterName = (String)methodNameRef.get();
                testType = methodFilterName != null ? AbstractRubyTestsRunConfigurationParams.TestType.TEST_METHOD : AbstractRubyTestsRunConfigurationParams.TestType.TEST_SCRIPT;
            } else if (rPsiElement instanceof RConstant && outerClass != null && rPsiElement.getParent().equals(outerClass.getClassName())) {
                return false;
            }
            if (testType == null) {
                testType = files.size() > 1 ? AbstractRubyTestsRunConfigurationParams.TestType.CUSTOM_SET_OF_FILES : AbstractRubyTestsRunConfigurationParams.TestType.TEST_SCRIPT;
            }
            configuration.setGeneratedName(name);
            configuration.setModule(module);
            TestUnitRunConfigurationProducer.determineAndSetWorkingDir(configuration, module, (VirtualFile)ObjectUtils.coalesce((Object)((VirtualFile)ObjectUtils.doIfNotNull((Object)containingFile, PsiFile::getVirtualFile)), (Object)((VirtualFile)ObjectUtils.doIfNotNull((Object)containingDirectory, PsiDirectory::getVirtualFile))));
            TestUnitRunConfigurationProducer.initUnitTestConfiguration(files, testType, methodFilterName, configuration, module);
            RubyRunConfigurationExtensionsManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, location);
            return true;
        }
        return false;
    }

    private static void determineParamsForLocationsInClass(@NotNull RPsiElement rPsiElement, @NotNull Ref<String> testNameRef, @NotNull Ref<String> methodNameFilterRef) {
        String blockName;
        RClass rClass;
        RClass testUnitClass;
        if (rPsiElement == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (testNameRef == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (methodNameFilterRef == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        if ((testUnitClass = (RClass)PsiTreeUtil.findFirstParent((PsiElement)rPsiElement, (boolean)false, elem -> {
            RClass cl;
            return elem instanceof RClass && RTestUnitUtil.isUnitTestCaseDescendant(cl = (RClass)elem);
        })) != null && TestUnitUtil.isInTestClosureRegion((PsiElement)rPsiElement)) {
            String testName = TestUnitUtil.determineCurrentTestNameByTestUnitTestClosure((PsiElement)rPsiElement);
            if (testName != null) {
                methodNameFilterRef.set((Object)TestUnitUtil.wrapWithRegexpStartEnd(RubyTextUtil.escapeRegexSpecialCharacters((String)testName, (Character[])new Character[0])));
                testNameRef.set((Object)testName);
            }
            return;
        }
        RName testClassName = null;
        if (rPsiElement instanceof RClass && !RTestUnitUtil.isUnitTestCaseDescendant(rClass = (RClass)rPsiElement)) {
            testClassName = rClass.getClassName();
        } else if (rPsiElement instanceof RConstant) {
            RClass classParent = (RClass)PsiTreeUtil.getParentOfType((PsiElement)rPsiElement, RClass.class);
            RName name = (RName)PsiTreeUtil.getParentOfType((PsiElement)rPsiElement, RName.class, (boolean)false);
            if (classParent != null && name != null && name.equals(classParent.getClassName()) && !RTestUnitUtil.isUnitTestCaseDescendant(classParent)) {
                testClassName = name;
            }
        }
        if (testClassName != null) {
            testNameRef.set((Object)testClassName.getName());
            methodNameFilterRef.set((Object)((String)ObjectUtils.doIfNotNull((Object)TestUnitUtil.determineTestNamespace((PsiElement)testClassName), TestUnitUtil::createTestFilterForNamespace)));
            return;
        }
        boolean inShouldaTestRegion = ShouldaUtil.isProbablyInCoveringTestScopeRegion((PsiElement)rPsiElement);
        if (inShouldaTestRegion) {
            String exampleName = ShouldaUtil.determineCurrentExampleName((PsiElement)rPsiElement);
            String methodNameFilter = ShouldaUtil.getShouldaTestNameFilter((PsiElement)rPsiElement);
            if (exampleName != null && methodNameFilter != null) {
                methodNameFilterRef.set((Object)methodNameFilter);
                testNameRef.set((Object)exampleName);
                return;
            }
        }
        if (TestUnitUtil.isInActiveSupportTestClosureRegion((PsiElement)rPsiElement) && (blockName = TestUnitUtil.determineCurrentTestNameByRailsTestClosure((PsiElement)rPsiElement)) != null) {
            methodNameFilterRef.set((Object)TestUnitUtil.wrapWithRegexpStartEnd(RubyTextUtil.escapeRegexSpecialCharacters((String)blockName, (Character[])new Character[0])));
            testNameRef.set((Object)blockName);
        }
    }

    private static void initUnitTestConfiguration(List<VirtualFile> files, AbstractRubyTestsRunConfigurationParams.TestType testType, @Nullable String methodFilterName, AbstractRubyRunConfiguration<?> configuration, @NotNull Module module) {
        if (module == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        RTestUnitRunConfiguration conf = (RTestUnitRunConfiguration)configuration;
        assert (testType != null);
        conf.setTestType(testType);
        conf.setTestScriptPath(files.get(0).getPath());
        conf.setTestScriptsPaths(ContainerUtil.map(files, it -> it.getPath()));
        switch (testType) {
            case TEST_METHOD: {
                conf.setTestMethodFilter(methodFilterName);
                break;
            }
        }
        RunConfigurationUtil.setRailsDefaultTestEnvironment(conf, module);
        JRubySdkUtil.enableObjectSpaceIfNotOverriddenByUser(conf);
    }

    static void determineAndSetWorkingDir(@NotNull AbstractRubyRunConfiguration<?> conf, @NotNull Module module, @Nullable VirtualFile contextVirtualFile) {
        if (conf == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        if (module == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        if (!StringUtil.isEmptyOrSpaces((String)conf.getWorkingDirectory())) {
            return;
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        String workDirPath = contentRoots.length == 0 ? null : (contentRoots.length == 1 || contextVirtualFile == null ? contentRoots[0].getPath() : Arrays.stream(contentRoots).filter(root -> VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)contextVirtualFile, (boolean)false)).findAny().orElse(contentRoots[0]).getPath());
        if (!Registry.is((String)"ruby.tests.disable.loadpath.argument")) {
            if (RailsFacetUtil.hasRailsSupport(module)) {
                conf.addRubyArgs(TESTUNIT_FOLDER_LOADPATH_ARG);
            } else {
                conf.addRubyArgs(ArrayUtil.toStringArray(TestUnitRunConfigurationProducer.getLoadPathArgument(workDirPath)));
            }
        }
        conf.setWorkingDirectory(workDirPath);
    }

    public boolean isConfigurationFromContext(@NotNull RTestUnitRunConfiguration configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(13);
        }
        if (context == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(14);
        }
        RTestUnitRunConfiguration fromContext = (RTestUnitRunConfiguration)configuration.clone();
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        Ref ref = new Ref((Object)location.getPsiElement());
        if (this.setupConfigurationFromContext(fromContext, context, (Ref<PsiElement>)ref)) {
            if (!(fromContext.getTestType().equals((Object)configuration.getTestType()) && StringUtil.equals((CharSequence)fromContext.getTestScriptPath(), (CharSequence)configuration.getTestScriptPath()) && TestUnitRunConfigurationProducer.isSameElements(fromContext.getTestScriptsPaths(), configuration.getTestScriptsPaths()) && StringUtil.equals((CharSequence)fromContext.getTestsFolderPath(), (CharSequence)configuration.getTestsFolderPath()))) {
                return false;
            }
            if (configuration.getTestType() == AbstractRubyTestsRunConfigurationParams.TestType.TEST_METHOD) {
                String methodName = configuration.getTestMethodFilter();
                String fromContextMethodName = fromContext.getTestMethodFilter();
                return StringUtil.equals((CharSequence)methodName, (CharSequence)fromContextMethodName);
            }
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> boolean isSameElements(@NotNull Collection<? extends T> list1, @NotNull Collection<? extends T> list2) {
        if (list1 == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(15);
        }
        if (list2 == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(16);
        }
        return list1.size() == list2.size() && list1.containsAll(list2);
    }

    private static boolean isRSpecFile(@NotNull RFile file) {
        if (file == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(17);
        }
        return RSpecUtil.isFileWithRSpecTestFileName(file.getVirtualFile()) && RubyTestFrameworkDetector.detectFrameworkForFile(file) == RubyTestFrameworkDetector.Result.RSPEC;
    }

    private static boolean isRSpecDirectory(@NotNull PsiDirectory directory) {
        if (directory == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(18);
        }
        return directory.getVirtualFile().getPath().contains("/spec") && RubyTestFrameworkDetector.detectFrameworkForFolder(directory) == RubyTestFrameworkDetector.Result.RSPEC;
    }

    @NotNull
    private static List<VirtualFile> getFilesFromContextAndLocation(@NotNull ConfigurationContext context, @NotNull Location<?> location) {
        List<VirtualFile> files;
        if (context == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(19);
        }
        if (location == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(20);
        }
        if ((files = RubyTestFrameworksUtil.getAndFlattenAllSelectedFiles(context.getDataContext(), (Condition<? super VirtualFile>)((Condition)file -> TestUnitUtil.isFileWithValidTestUnitFileName(file) || TestUnitUtil.isFileWithValidMinitestFileName(file)))).isEmpty()) {
            List list = ContainerUtil.createMaybeSingletonList((Object)TestUnitRunConfigurationProducer.getTestScriptFile(location));
            if (list == null) {
                TestUnitRunConfigurationProducer.$$$reportNull$$$0(21);
            }
            return list;
        }
        List<VirtualFile> list = files;
        if (list == null) {
            TestUnitRunConfigurationProducer.$$$reportNull$$$0(22);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/TestUnitRunConfigurationProducer";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rPsiElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNameRef";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodNameFilterRef";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadPathArgument";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/TestUnitRunConfigurationProducer";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesFromContextAndLocation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "determineParamsForLocationsInClass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "initUnitTestConfiguration";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "determineAndSetWorkingDir";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isSameElements";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isRSpecFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isRSpecDirectory";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFilesFromContextAndLocation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> new IllegalArgumentException(string);
        };
    }
}

