/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit.runConfigurations;

import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.settings.SettingsExternalizer;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RTestUnitRunConfiguration;

public class RTestUnitRunConfigurationExternalizer
extends SettingsExternalizer {
    private static final RTestUnitRunConfigurationExternalizer myInstance = new RTestUnitRunConfigurationExternalizer();
    @NonNls
    public static final String RTEST_RUN_CONFIG_SETTINGS_ID = "RTEST_RUN_CONFIG_SETTINGS_ID";
    @NonNls
    private static final String TESTS_FOLDER_PATH = "TESTS_FOLDER_PATH";
    @NonNls
    private static final String TEST_SCRIPT_PATH = "TEST_SCRIPT_PATH";
    @NonNls
    private static final String TEST_SCRIPTS_PATHS = "TEST_SCRIPTS_PATHS";
    @NonNls
    private static final String TEST_FILE_MASK = "TEST_FILE_MASK";
    @NonNls
    private static final String TEST_METHOD_NAME = "TEST_METHOD_NAME";
    @NonNls
    private static final String TEST_TEST_TYPE = "TEST_TEST_TYPE";
    @NonNls
    private static final String DRB = "DRB";
    @NonNls
    private static final String ZEUS = "ZEUS";
    @NonNls
    private static final String SPRING = "SPRING";
    @NonNls
    private static final String RUNNER_OPTIONS = "RUNNER_OPTIONS";

    public void writeExternal(RTestUnitRunConfiguration config, Element elem) {
        this.writeOption(TESTS_FOLDER_PATH, config.getTestsFolderPath(), elem);
        this.writeOption(TEST_SCRIPT_PATH, config.getTestScriptPath(), elem);
        this.writeOption(TEST_SCRIPTS_PATHS, StringUtil.join(config.getTestScriptsPaths(), (String)"||"), elem);
        this.writeOption(TEST_FILE_MASK, config.getTestFileMask(), elem);
        this.writeOption(TEST_METHOD_NAME, config.getTestMethodFilter(), elem);
        this.writeOption(TEST_TEST_TYPE, config.getTestType().toString(), elem);
        PreLoadUtil.PreLoadServer server = config.getPreloadServer();
        this.writeOption(DRB, String.valueOf(server == PreLoadUtil.PreLoadServer.DRb), elem);
        this.writeOption(ZEUS, String.valueOf(server == PreLoadUtil.PreLoadServer.Zeus), elem);
        this.writeOption(SPRING, String.valueOf(server == PreLoadUtil.PreLoadServer.Spring), elem);
        this.writeOption(RUNNER_OPTIONS, config.getRunnerOptions(), elem);
    }

    public void readExternal(RTestUnitRunConfiguration config, Element elem) {
        Map<String, String> optionsByName = this.buildOptionsByElement(elem);
        config.setTestsFolderPath(optionsByName.get(TESTS_FOLDER_PATH));
        config.setTestScriptPath(optionsByName.get(TEST_SCRIPT_PATH));
        config.setTestScriptsPaths(RTestUnitRunConfigurationExternalizer.getScriptPathsOrOnePath(optionsByName.get(TEST_SCRIPTS_PATHS), optionsByName.get(TEST_SCRIPT_PATH)));
        config.setTestFileMask(optionsByName.get(TEST_FILE_MASK));
        config.setTestMethodFilter(optionsByName.get(TEST_METHOD_NAME));
        String typeValue = optionsByName.get(TEST_TEST_TYPE);
        if ("TEST_SCRIPT".equals(typeValue)) {
            config.setTestType(AbstractRubyTestsRunConfigurationParams.TestType.CUSTOM_SET_OF_FILES);
        } else if (typeValue != null) {
            config.setTestType(Enum.valueOf(AbstractRubyTestsRunConfigurationParams.TestType.class, typeValue));
        }
        if (Boolean.valueOf(optionsByName.get(DRB)).booleanValue()) {
            config.setPreloadServer(PreLoadUtil.PreLoadServer.DRb);
        } else if (Boolean.valueOf(optionsByName.get(ZEUS)).booleanValue()) {
            config.setPreloadServer(PreLoadUtil.PreLoadServer.Zeus);
        } else if (Boolean.valueOf(optionsByName.get(SPRING)).booleanValue()) {
            config.setPreloadServer(PreLoadUtil.PreLoadServer.Spring);
        }
        config.setRunnerOptions(optionsByName.get(RUNNER_OPTIONS));
    }

    public static RTestUnitRunConfigurationExternalizer getInstance() {
        return myInstance;
    }

    @Override
    @NotNull
    public String getID() {
        return RTEST_RUN_CONFIG_SETTINGS_ID;
    }

    @NotNull
    private static List<String> getScriptPathsOrOnePath(@Nullable String scriptsOption, @NotNull String oneScriptOption) {
        List paths;
        if (oneScriptOption == null) {
            RTestUnitRunConfigurationExternalizer.$$$reportNull$$$0(0);
        }
        if ((paths = StringUtil.split((String)StringUtil.notNullize((String)scriptsOption), (String)"||")).isEmpty()) {
            List<String> list = List.of(oneScriptOption);
            if (list == null) {
                RTestUnitRunConfigurationExternalizer.$$$reportNull$$$0(1);
            }
            return list;
        }
        List list = paths;
        if (list == null) {
            RTestUnitRunConfigurationExternalizer.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oneScriptOption";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/RTestUnitRunConfigurationExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/RTestUnitRunConfigurationExternalizer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptPathsOrOnePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getScriptPathsOrOnePath";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

