/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit.runConfigurations;

import com.intellij.DynamicBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommonRunParamsEditor;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUIUtil;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RTestUnitRunConfiguration;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RTestUnitRunConfigurationParams;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

public class RTestUnitRunConfigurationEditor
extends SettingsEditor<RTestUnitRunConfiguration>
implements RTestUnitRunConfigurationParams,
PanelWithAnchor {
    private JPanel myConfigurationPanel;
    private JRadioButton myAllInFolderRB;
    private JRadioButton myTestMethodRB;
    private JRadioButton myTestScriptsRB;
    private JBLabel myTestTypeComponent;
    private LabeledComponent myTestMethodComponent;
    private LabeledComponent myTestFolderComponent;
    private LabeledComponent myTestScriptComponent;
    private LabeledComponent myTestScriptsPathsComponent;
    private LabeledComponent myTestFileMaskComponent;
    private JComponent myAnchor;
    private JPanel myCommonOptionsPanel;
    private LabeledComponent myRunnerOptionsComponent;
    private LabeledComponent myPreloadServerComponent;
    private JComboBox myPreloadServer;
    private TextFieldWithBrowseButton myTestFolderTextField;
    private TextFieldWithBrowseButton myTestsScriptsPathsTextField;
    private TextFieldWithBrowseButton myTestScriptTextField;
    private JTextField myTestMethodTextField;
    private JTextField myTestFileMaskTextField;
    private RawCommandLineEditor myRunnerOptionsTextField;
    private final Project myProject;
    private final RubyCommonRunParamsEditor myCommonEditor;

    public RTestUnitRunConfigurationEditor(Project project, RTestUnitRunConfiguration configuration) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myCommonEditor = new RubyCommonRunParamsEditor(configuration);
        this.myCommonOptionsPanel.add((Component)this.myCommonEditor.getMainPanel(), "Center");
        this.initComponents();
        this.setupAnchor();
    }

    private void initComponents() {
        String title = RBundle.message((String)"run.configuration.messages.select.folder.path");
        RunConfigurationUIUtil.addFolderChooser(title, this.myTestFolderTextField, this.myProject);
        title = RBundle.message((String)"run.configuration.messages.select.ruby.script.path");
        RunConfigurationUIUtil.addFileChooser(title, this.myTestScriptTextField, this.myProject);
        ActionListener testTypeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RTestUnitRunConfigurationEditor.this.setTestType(RTestUnitRunConfigurationEditor.this.getTestType());
            }
        };
        this.myAllInFolderRB.addActionListener(testTypeListener);
        this.myTestScriptsRB.addActionListener(testTypeListener);
        this.myTestMethodRB.addActionListener(testTypeListener);
        this.myPreloadServer.setModel(new EnumComboBoxModel(PreLoadUtil.PreLoadServer.class));
    }

    private LabeledComponent createTestMethodComponent() {
        this.myTestMethodTextField = new JTextField();
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent((JComponent)this.myTestMethodTextField);
        myComponent.setText(RBundle.message((String)"run.configuration.tests.messages.method.name"));
        return myComponent;
    }

    private void createUIComponents() {
        this.myTestMethodComponent = this.createTestMethodComponent();
        Ref testsFolderTextFieldWrapper = new Ref();
        this.myTestFolderComponent = RunConfigurationUIUtil.createTestFolderComponent((Ref<? super TextFieldWithBrowseButton>)testsFolderTextFieldWrapper);
        this.myTestFolderTextField = (TextFieldWithBrowseButton)testsFolderTextFieldWrapper.get();
        Ref testScriptTextFieldWrapper = new Ref();
        this.myTestScriptComponent = RunConfigurationUIUtil.createScriptPathComponent((Ref<? super TextFieldWithBrowseButton>)testScriptTextFieldWrapper, RBundle.message((String)"run.configuration.messages.script.path"));
        this.myTestScriptTextField = (TextFieldWithBrowseButton)testScriptTextFieldWrapper.get();
        Ref scriptsPathsFieldWrapper = new Ref();
        this.myTestScriptsPathsComponent = RunConfigurationUIUtil.createMultiFileChooserTextField((Ref<? super TextFieldWithBrowseButton>)scriptsPathsFieldWrapper, RBundle.message((String)"run.configuration.tests.dialog.components.files"), this.myProject, (FileType)RubyFileType.RUBY, (Condition<? super VirtualFile>)((Condition)file -> TestUnitUtil.isFileWithValidTestUnitFileName(file)));
        this.myTestsScriptsPathsTextField = (TextFieldWithBrowseButton)scriptsPathsFieldWrapper.get();
        Ref testFileMaskTextFieldWrapper = new Ref();
        String text = RBundle.message((String)"run.configuration.tests.dialog.components.search.mask");
        this.myTestFileMaskComponent = RunConfigurationUIUtil.createTextFieldLabeledComponent((Ref<? super JTextField>)testFileMaskTextFieldWrapper, text);
        this.myTestFileMaskTextField = (JTextField)testFileMaskTextFieldWrapper.get();
        Ref runnerOptionsTextFieldWrapper = new Ref();
        this.myRunnerOptionsComponent = RunConfigurationUIUtil.createRawEditorComponent((Ref<? super RawCommandLineEditor>)runnerOptionsTextFieldWrapper, RBundle.message((String)"run.configuration.tests.runner.options"));
        this.myRunnerOptionsTextField = (RawCommandLineEditor)runnerOptionsTextFieldWrapper.get();
        this.myPreloadServer = new ComboBox();
        this.myPreloadServerComponent = LabeledComponent.create((JComponent)this.myPreloadServer, (String)RBundle.message((String)"preload.use.server"));
    }

    protected void resetEditorFrom(@NotNull RTestUnitRunConfiguration config) {
        if (config == null) {
            RTestUnitRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        RTestUnitRunConfiguration.copyParams(config, this);
        this.myCommonEditor.resetEditorFrom(config);
    }

    protected void applyEditorTo(@NotNull RTestUnitRunConfiguration config) throws ConfigurationException {
        if (config == null) {
            RTestUnitRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        RTestUnitRunConfiguration.copyParams(this, config);
        this.myCommonEditor.applyEditorTo(config);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myConfigurationPanel;
        if (jPanel == null) {
            RTestUnitRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public JComponent getPanel() {
        return this.myConfigurationPanel;
    }

    public String getPath() {
        return FileUtil.toSystemIndependentName((String)this.myTestFolderTextField.getText().trim());
    }

    @Override
    public String getTestsFolderPath() {
        return FileUtil.toSystemIndependentName((String)this.myTestFolderTextField.getText().trim());
    }

    @Override
    public String getTestScriptPath() {
        return FileUtil.toSystemIndependentName((String)this.myTestScriptTextField.getText().trim());
    }

    @Override
    public String getTestFileMask() {
        return this.myTestFileMaskTextField.getText();
    }

    @Override
    public String getRunnerOptions() {
        return this.myRunnerOptionsTextField.getText();
    }

    @Override
    public String getTestMethodFilter() {
        return this.myTestMethodTextField.getText().trim();
    }

    public void setPath(String value) {
        this.myTestFolderTextField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)value)));
    }

    @Override
    public void setTestsFolderPath(String path) {
        this.myTestFolderTextField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)path)));
    }

    @Override
    public void setTestScriptPath(String path) {
        this.myTestScriptTextField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)path)));
    }

    @Override
    public void setTestFileMask(String name) {
        this.myTestFileMaskTextField.setText(StringUtil.notNullize((String)name));
    }

    @Override
    public void setRunnerOptions(String runnerOptions) {
        this.myRunnerOptionsTextField.setText(StringUtil.notNullize((String)runnerOptions));
    }

    @Override
    @NotNull
    public List<String> getTestScriptsPaths() {
        List<String> list = RunConfigurationUIUtil.splitFilenames(this.myTestsScriptsPathsTextField.getText());
        if (list == null) {
            RTestUnitRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void setTestScriptsPaths(@NotNull List<String> paths) {
        if (paths == null) {
            RTestUnitRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        this.myTestsScriptsPathsTextField.setText(RunConfigurationUIUtil.joinFilenames(paths));
    }

    @Override
    public void setTestMethodFilter(String name) {
        this.myTestMethodTextField.setText(StringUtil.notNullize((String)name));
    }

    @Override
    public AbstractRubyTestsRunConfigurationParams.TestType getTestType() {
        if (this.myAllInFolderRB.isSelected()) {
            return AbstractRubyTestsRunConfigurationParams.TestType.ALL_IN_FOLDER;
        }
        if (this.myTestScriptsRB.isSelected()) {
            return AbstractRubyTestsRunConfigurationParams.TestType.CUSTOM_SET_OF_FILES;
        }
        return AbstractRubyTestsRunConfigurationParams.TestType.TEST_METHOD;
    }

    @Override
    public void setTestType(@NotNull AbstractRubyTestsRunConfigurationParams.TestType testType) {
        if (testType == null) {
            RTestUnitRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        this.clearTestTypeSettings(testType);
        switch (testType) {
            case ALL_IN_FOLDER: {
                this.myAllInFolderRB.setSelected(true);
                this.myTestFolderComponent.setVisible(true);
                this.myTestFileMaskComponent.setVisible(true);
                this.myTestScriptsPathsComponent.setVisible(false);
                this.myTestMethodComponent.setVisible(false);
                break;
            }
            case TEST_SCRIPT: 
            case CUSTOM_SET_OF_FILES: {
                this.myTestScriptsRB.setSelected(true);
                this.myTestScriptComponent.setVisible(false);
                this.myTestScriptsPathsComponent.setVisible(true);
                this.myTestFolderComponent.setVisible(false);
                this.myTestFileMaskComponent.setVisible(false);
                this.myTestMethodComponent.setVisible(false);
                break;
            }
            case TEST_METHOD: {
                this.myTestMethodRB.setSelected(true);
                this.myTestMethodComponent.setVisible(true);
                this.myTestScriptComponent.setVisible(true);
                this.myTestScriptsPathsComponent.setVisible(false);
                this.myTestFolderComponent.setVisible(false);
                this.myTestFileMaskComponent.setVisible(false);
            }
        }
    }

    @Override
    @NotNull
    public PreLoadUtil.PreLoadServer getPreloadServer() {
        PreLoadUtil.PreLoadServer preLoadServer = (PreLoadUtil.PreLoadServer)((Object)Objects.requireNonNull(this.myPreloadServer.getSelectedItem()));
        if (preLoadServer == null) {
            RTestUnitRunConfigurationEditor.$$$reportNull$$$0(6);
        }
        return preLoadServer;
    }

    @Override
    public void setPreloadServer(@NotNull PreLoadUtil.PreLoadServer server) {
        if (server == null) {
            RTestUnitRunConfigurationEditor.$$$reportNull$$$0(7);
        }
        this.myPreloadServer.setSelectedItem((Object)server);
    }

    private void clearTestTypeSettings(AbstractRubyTestsRunConfigurationParams.TestType newTestType) {
        if (newTestType == AbstractRubyTestsRunConfigurationParams.TestType.ALL_IN_FOLDER) {
            this.setTestScriptPath("");
            this.setTestFileMask(RTestUnitRunConfiguration.DEFAULT_TESTS_SEARCH_MASK);
        } else {
            this.setTestsFolderPath("");
            this.setTestFileMask("");
        }
        this.setTestMethodFilter("");
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.myTestMethodComponent.setAnchor(anchor);
        this.myTestTypeComponent.setAnchor(anchor);
        this.myCommonEditor.setAnchor(anchor);
        this.myTestFileMaskComponent.setAnchor(anchor);
        this.myTestFolderComponent.setAnchor(anchor);
        this.myTestScriptComponent.setAnchor(anchor);
        this.myTestScriptsPathsComponent.setAnchor(anchor);
        this.myRunnerOptionsComponent.setAnchor(anchor);
        this.myPreloadServerComponent.setAnchor(anchor);
    }

    private void setupAnchor() {
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myCommonEditor, this.myTestMethodComponent, this.myTestFileMaskComponent, this.myTestFolderComponent, this.myTestScriptComponent, this.myTestScriptsPathsComponent, this.myRunnerOptionsComponent, this.myPreloadServerComponent});
        this.myTestTypeComponent.setAnchor(this.myAnchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JBLabel jBLabel;
        JRadioButton jRadioButton3;
        JPanel jPanel2;
        this.createUIComponents();
        this.myConfigurationPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAllInFolderRB = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/RBundle", RTestUnitRunConfigurationEditor.class).getString("run.configuration.tests.dialog.rb.allInFolder"));
        jPanel3.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTestTypeComponent = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/RBundle", RTestUnitRunConfigurationEditor.class).getString("run.configuration.test.form.testtype.title"));
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestScriptsRB = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/RBundle", RTestUnitRunConfigurationEditor.class).getString("run.configuration.tests.dialog.rb.files"));
        jPanel3.add((Component)jRadioButton2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTestMethodRB = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/RBundle", RTestUnitRunConfigurationEditor.class).getString("run.configuration.tests.dialog.rb.method"));
        jPanel3.add((Component)jRadioButton, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        LabeledComponent labeledComponent = this.myTestMethodComponent;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/RBundle", RTestUnitRunConfigurationEditor.class).getString("run.configuration.tests.dialog.components.method"));
        jPanel4.add((Component)labeledComponent, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent labeledComponent2 = this.myTestFolderComponent;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/RBundle", RTestUnitRunConfigurationEditor.class).getString("run.configuration.tests.dialog.components.folder"));
        jPanel4.add((Component)labeledComponent2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent labeledComponent3 = this.myTestFileMaskComponent;
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText(DynamicBundle.getBundle((String)"messages/RBundle", RTestUnitRunConfigurationEditor.class).getString("run.configuration.tests.dialog.components.search.mask"));
        jPanel4.add((Component)labeledComponent3, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent labeledComponent4 = this.myTestScriptsPathsComponent;
        labeledComponent4.setLabelLocation("West");
        labeledComponent4.setText(DynamicBundle.getBundle((String)"messages/RBundle", RTestUnitRunConfigurationEditor.class).getString("run.configuration.tests.dialog.components.files"));
        jPanel4.add((Component)labeledComponent4, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent labeledComponent5 = this.myTestScriptComponent;
        labeledComponent5.setLabelLocation("West");
        labeledComponent5.setText(DynamicBundle.getBundle((String)"messages/RBundle", RTestUnitRunConfigurationEditor.class).getString("run.configuration.tests.dialog.components.file"));
        jPanel4.add((Component)labeledComponent5, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myCommonOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(4, 0, 1, 1, 0, 1, 0, 7, null, null, null));
        LabeledComponent labeledComponent6 = this.myRunnerOptionsComponent;
        labeledComponent6.setLabelLocation("West");
        labeledComponent6.setText(DynamicBundle.getBundle((String)"messages/RBundle", RTestUnitRunConfigurationEditor.class).getString("run.configuration.tests.runner.options"));
        labeledComponent6.setToolTipText("");
        jPanel2.add((Component)labeledComponent6, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent labeledComponent7 = this.myPreloadServerComponent;
        labeledComponent7.setLabelLocation("West");
        labeledComponent7.setText(DynamicBundle.getBundle((String)"messages/RBundle", RTestUnitRunConfigurationEditor.class).getString("preload.use.server"));
        jPanel2.add((Component)labeledComponent7, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myConfigurationPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/RTestUnitRunConfigurationEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/RTestUnitRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestScriptsPaths";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreloadServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTestScriptsPaths";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setTestType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setPreloadServer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6 -> new IllegalStateException(string);
        };
    }
}

