/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit.runConfigurations;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.statistics.FusCollectSettingChangesRunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractTestRunConfigurationWithTestPath;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.statistic.RubyRunConfigurationSettingChangesCollector;
import org.jetbrains.plugins.ruby.testing.PreloadedTestRunConfiguration;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RTestUnitRunCommandLineState;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RTestUnitRunConfigurationEditor;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RTestUnitRunConfigurationExternalizer;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RTestUnitRunConfigurationParams;

public class RTestUnitRunConfiguration
extends AbstractTestRunConfigurationWithTestPath<RTestUnitRunConfiguration>
implements RTestUnitRunConfigurationParams,
PreloadedTestRunConfiguration,
FusCollectSettingChangesRunConfiguration {
    public static final String DEFAULT_TESTS_SEARCH_MASK = "**/{*_test,test_*,*_spec}." + RubyFileType.RUBY.getDefaultExtension();
    private String myTestMethodFilter = "";
    @NotNull
    private PreLoadUtil.PreLoadServer myPreloadServer = PreLoadUtil.PreLoadServer.None;
    private String myRunnerOptions = "";
    @NotNull
    private List<String> myTestScriptsPaths = Collections.emptyList();

    public RTestUnitRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
        this.registerLog("RUBY_TESTUNIT");
    }

    @Override
    protected String getSerializationId() {
        return "RTEST_RUN_CONFIG_SETTINGS_ID";
    }

    @Override
    @NotNull
    protected SettingsEditor<RTestUnitRunConfiguration> createConfigurationEditor() {
        return new RTestUnitRunConfigurationEditor(this.getProject(), this);
    }

    @Override
    protected RubyAbstractCommandLineState createCommandLineState(@NotNull ExecutionEnvironment env) throws ExecutionException {
        if (env == null) {
            RTestUnitRunConfiguration.$$$reportNull$$$0(0);
        }
        return new RTestUnitRunCommandLineState(this, env);
    }

    @Override
    protected void validateConfiguration() throws RuntimeConfigurationException {
        RunConfigurationUtil.inspectSDK(this);
        RunConfigurationUtil.inspectWorkingDirectory(false, this);
        switch (this.getTestType()) {
            case ALL_IN_FOLDER: {
                this.inspectTestsFolder();
                if (!StringUtil.isEmpty((String)this.getTestFileMask())) break;
                throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.test.no.mask", (Object[])new Object[]{DEFAULT_TESTS_SEARCH_MASK}));
            }
            case TEST_METHOD: {
                this.inspectTestScript();
                this.inspectMethod();
                break;
            }
            case TEST_SCRIPT: {
                this.inspectTestScript();
            }
        }
        PreLoadUtil.checkPreloadServerSupportEnabled(this.myPreloadServer);
    }

    private void inspectTestScript() throws RuntimeConfigurationError {
        String scriptPath = this.getTestScriptPath().trim();
        VirtualFile script = LocalFileSystem.getInstance().findFileByPath(scriptPath);
        if (StringUtil.isEmpty((String)scriptPath)) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.test.script.not.specified"));
        }
        if (script == null || !script.exists()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.test.script.not.exists"));
        }
        if (script.isDirectory()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.test.script.is.dir"));
        }
    }

    private void inspectMethod() throws RuntimeConfigurationError {
        String methodName = this.getTestMethodFilter().trim();
        if (StringUtil.isEmpty((String)methodName)) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.test.method.name.not.specified"));
        }
    }

    private void inspectTestsFolder() throws RuntimeConfigurationError {
        String folderPath = this.getTestsFolderPath().trim();
        if (StringUtil.isEmpty((String)folderPath)) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.test.folder.not.specified"));
        }
        File folder = new File(folderPath);
        if (!folder.exists()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.test.folder.not.exists"));
        }
        if (!folder.isDirectory()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.test.folder.not.dir"));
        }
    }

    @Override
    public String getTestMethodFilter() {
        return this.myTestMethodFilter;
    }

    @Override
    public void setTestMethodFilter(@Nullable String name) {
        this.myTestMethodFilter = StringUtil.notNullize((String)name);
    }

    @Override
    public String getRunnerOptions() {
        return this.myRunnerOptions;
    }

    @Override
    public void setRunnerOptions(String runnerOptions) {
        this.myRunnerOptions = StringUtil.notNullize((String)runnerOptions);
    }

    @Override
    @NotNull
    public List<String> getTestScriptsPaths() {
        String path;
        if (this.myTestScriptsPaths.isEmpty() && !(path = this.getTestScriptPath()).isEmpty() && this.getTestType() == AbstractRubyTestsRunConfigurationParams.TestType.TEST_SCRIPT) {
            this.myTestScriptsPaths.add(path);
            this.setTestType(AbstractRubyTestsRunConfigurationParams.TestType.CUSTOM_SET_OF_FILES);
        }
        List<String> list = Collections.unmodifiableList(this.myTestScriptsPaths);
        if (list == null) {
            RTestUnitRunConfiguration.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public void setTestScriptsPaths(@NotNull List<String> paths) {
        if (paths == null) {
            RTestUnitRunConfiguration.$$$reportNull$$$0(2);
        }
        this.myTestScriptsPaths = new ArrayList<String>(paths);
    }

    @Override
    @NotNull
    public PreLoadUtil.PreLoadServer getPreloadServer() {
        PreLoadUtil.PreLoadServer preLoadServer = this.myPreloadServer;
        if (preLoadServer == null) {
            RTestUnitRunConfiguration.$$$reportNull$$$0(3);
        }
        return preLoadServer;
    }

    @Override
    public void setPreloadServer(@NotNull PreLoadUtil.PreLoadServer server) {
        if (server == null) {
            RTestUnitRunConfiguration.$$$reportNull$$$0(4);
        }
        this.myPreloadServer = server;
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            RTestUnitRunConfiguration.$$$reportNull$$$0(5);
        }
        super.readExternal(element);
        RTestUnitRunConfigurationExternalizer.getInstance().readExternal(this, element);
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            RTestUnitRunConfiguration.$$$reportNull$$$0(6);
        }
        super.writeExternal(element);
        RTestUnitRunConfigurationExternalizer.getInstance().writeExternal(this, element);
    }

    @Override
    protected String getLogTitle() {
        return "TestUnit log";
    }

    @Override
    public boolean isBundlerContextAllowed() {
        return RTestUnitRunConfiguration.isBundlerContextAllowed(this.getPreloadServer(), this.getModule());
    }

    public static void copyParams(RTestUnitRunConfigurationParams fromParams, RTestUnitRunConfigurationParams toParams) {
        AbstractTestRunConfigurationWithTestPath.copyParams(fromParams, toParams);
        toParams.setPreloadServer(fromParams.getPreloadServer());
        toParams.setTestMethodFilter(fromParams.getTestMethodFilter());
        toParams.setTestScriptsPaths(fromParams.getTestScriptsPaths());
        toParams.setRunnerOptions(fromParams.getRunnerOptions());
    }

    @Override
    @NotNull
    protected String doGetActionName() {
        String string = RBundle.message((String)"minitest.run.configuration.prefix", (Object[])new Object[]{this.getName()});
        if (string == null) {
            RTestUnitRunConfiguration.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public SupportedTestFramework getTestFramework() {
        SupportedTestFramework supportedTestFramework = SupportedTestFramework.TEST_UNIT;
        if (supportedTestFramework == null) {
            RTestUnitRunConfiguration.$$$reportNull$$$0(8);
        }
        return supportedTestFramework;
    }

    public boolean isGUIRunnerEnabled() {
        String options = this.getRunnerOptions();
        for (String option : RTestUnitRunCommandLineState.CUSTOM_RUNNER_OPTIONS) {
            if (!RTestUnitRunConfiguration.containsOptionKey(options, option)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean shouldAttachTestRunnerConsole() {
        return this.isGUIRunnerEnabled();
    }

    @Override
    @Nullable
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        if (executor == null) {
            RTestUnitRunConfiguration.$$$reportNull$$$0(9);
        }
        if (this.shouldAttachTestRunnerConsole()) {
            SMTRunnerConsoleProperties result = Objects.requireNonNull(super.createTestConsoleProperties(executor));
            result.setIdBasedTestTree(true);
            return result;
        }
        return null;
    }

    @Override
    public void collectSettingChangesOnApply(@NotNull FusCollectSettingChangesRunConfiguration oldRunConfiguration) {
        if (oldRunConfiguration == null) {
            RTestUnitRunConfiguration.$$$reportNull$$$0(10);
        }
        super.collectSettingChangesOnApply(oldRunConfiguration);
        if (this.getClass() == oldRunConfiguration.getClass()) {
            RTestUnitRunConfiguration oldRspecConfiguration = (RTestUnitRunConfiguration)oldRunConfiguration;
            PreLoadUtil.PreLoadServer newPreloadServerType = this.getPreloadServer();
            PreLoadUtil.PreLoadServer oldPreloadServerType = oldRspecConfiguration.getPreloadServer();
            if (oldPreloadServerType != newPreloadServerType) {
                RubyRunConfigurationSettingChangesCollector.logPreloadServerChange(this.getType(), oldPreloadServerType, newPreloadServerType);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/RTestUnitRunConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/runConfigurations/RTestUnitRunConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestScriptsPaths";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreloadServer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetActionName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFramework";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLineState";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTestScriptsPaths";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setPreloadServer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectSettingChangesOnApply";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 7, 8 -> new IllegalStateException(string);
        };
    }
}

