/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.testing.testunit.RTestUnitConstants;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

public final class RTestUnitUtil {
    @NonNls
    public static final String TEST_UNIT_SCRIPT = "testunit";
    @NonNls
    public static final String TEST_UNIT_GEM = "test-unit";
    public static final String TEST_METHOD_NAME_PREFIX = "test";
    private static final FQN MINITEST_CASE_FQN_PRE50 = FQN.Builder.fromString((String)"MiniTest::Unit::TestCase");
    private static final FQN MINITEST_CASE_FQN = FQN.Builder.fromString((String)"Minitest::Test");
    private static final FQN TEST_UNIT_TEST_CASE_FQN = FQN.Builder.fromString((String)"Test::Unit::TestCase");

    private RTestUnitUtil() {
    }

    private static boolean isUserTestCase(@NotNull Symbol classSymbol, @Nullable RClass invocationPoint, @NotNull FQN testCaseFqn) {
        if (classSymbol == null) {
            RTestUnitUtil.$$$reportNull$$$0(0);
        }
        if (testCaseFqn == null) {
            RTestUnitUtil.$$$reportNull$$$0(1);
        }
        return RTestUnitUtil.isUserTestCase(classSymbol, invocationPoint, testCaseFqn, new HashSet<FQN>());
    }

    private static boolean isUserTestCase(@NotNull Symbol classSymbol, @Nullable RClass invocationPoint, @NotNull FQN testCaseFqn, @NotNull Set<FQN> visited) {
        ClassModuleSymbol classModuleSymbol;
        Symbol superClassSymbol;
        if (classSymbol == null) {
            RTestUnitUtil.$$$reportNull$$$0(2);
        }
        if (testCaseFqn == null) {
            RTestUnitUtil.$$$reportNull$$$0(3);
        }
        if (visited == null) {
            RTestUnitUtil.$$$reportNull$$$0(4);
        }
        if (testCaseFqn.equals(classSymbol.getFQNWithNesting())) {
            return true;
        }
        return classSymbol instanceof ClassModuleSymbol && (superClassSymbol = (classModuleSymbol = (ClassModuleSymbol)classSymbol).getSuperClassSymbol((PsiElement)invocationPoint)) != null && !superClassSymbol.equals(classSymbol) && visited.add(superClassSymbol.getFQNWithNesting()) && RTestUnitUtil.isUserTestCase(superClassSymbol, invocationPoint, testCaseFqn, visited);
    }

    public static boolean isUnitTestCaseLikeClass(@NotNull RClass rClass) {
        VirtualFile file;
        if (rClass == null) {
            RTestUnitUtil.$$$reportNull$$$0(5);
        }
        if ((file = RubyPsiUtil.getVirtualFileFromElement((PsiElement)rClass.getContainingFile())) == null || !TestUnitUtil.isFileWithValidTestUnitFileName(file)) {
            return false;
        }
        return RTestUnitUtil.isUnitTestCaseLikeClassWithoutFileNameCheck(rClass);
    }

    public static boolean isUnitTestCaseLikeClassWithoutFileNameCheck(@NotNull RClass rClass) {
        RSuperClass rSuperClass;
        String superClassFullName;
        if (rClass == null) {
            RTestUnitUtil.$$$reportNull$$$0(6);
        }
        String string = superClassFullName = (rSuperClass = rClass.getPsiSuperClass()) == null ? null : rSuperClass.getText();
        if (superClassFullName != null) {
            if (RTestUnitConstants.STD_TESTUNIT_TESTCASES.contains(superClassFullName)) {
                return true;
            }
            if (superClassFullName.endsWith("::TestCase")) {
                return true;
            }
            if (RTestUnitConstants.STD_MINITEST_TESTCASES.contains(superClassFullName) || superClassFullName.startsWith("MiniTest::")) {
                return true;
            }
            if (RTestUnitConstants.STD_MINITEST_5_0_TESTCASES.contains(superClassFullName) || superClassFullName.startsWith("Minitest::")) {
                return true;
            }
        }
        return rClass.getName() != null && rClass.getName().endsWith("Test");
    }

    public static boolean isUnitTestCaseDescendant(@NotNull RClass rClass) {
        if (rClass == null) {
            RTestUnitUtil.$$$reportNull$$$0(7);
        }
        return RTestUnitUtil.isTestCaseDescendant(rClass, TEST_UNIT_TEST_CASE_FQN);
    }

    public static boolean isMinitestCaseDescendant(@NotNull RClass rClass) {
        if (rClass == null) {
            RTestUnitUtil.$$$reportNull$$$0(8);
        }
        return RTestUnitUtil.isTestCaseDescendant(rClass, MINITEST_CASE_FQN_PRE50) || RTestUnitUtil.isTestCaseDescendant(rClass, MINITEST_CASE_FQN);
    }

    private static boolean isTestCaseDescendant(@NotNull RClass rClass, @NotNull FQN testCaseFqn) {
        if (rClass == null) {
            RTestUnitUtil.$$$reportNull$$$0(9);
        }
        if (testCaseFqn == null) {
            RTestUnitUtil.$$$reportNull$$$0(10);
        }
        if (!RTestUnitUtil.isUnitTestCaseLikeClass(rClass)) {
            return false;
        }
        Symbol symbol = RTestUnitUtil.getSymbolByContainerRubyTestMode((RContainer)rClass);
        return symbol != null && RTestUnitUtil.isUserTestCase(symbol, rClass, testCaseFqn);
    }

    public static boolean hasValidTestNameAndNotSingleton(@NotNull RMethod method) {
        String methodName;
        if (method == null) {
            RTestUnitUtil.$$$reportNull$$$0(11);
        }
        return (methodName = method.getName()).startsWith(TEST_METHOD_NAME_PREFIX) && methodName.length() > TEST_METHOD_NAME_PREFIX.length() && !(method instanceof RSingletonMethod);
    }

    public static boolean containsTestCaseLikeClasses(@NotNull RFile file) {
        if (file == null) {
            RTestUnitUtil.$$$reportNull$$$0(12);
        }
        return RTestUnitUtil.checkForAnotherTestCaseLikeClasses(null, file);
    }

    public static boolean containsToplevelMinitestExampleGroups(@NotNull RFile file) {
        if (file == null) {
            RTestUnitUtil.$$$reportNull$$$0(13);
        }
        List statements = file.getStatements();
        for (RPsiElement statement : statements) {
            if (!(statement instanceof RBlockCall) || !TestUnitUtil.isMinitestExampleGroupCall((RPossibleCall)((RBlockCall)statement))) continue;
            return true;
        }
        return false;
    }

    public static boolean checkForAnotherTestCaseLikeClasses(@Nullable RContainer currentContainer, @NotNull RFile rFile) {
        if (rFile == null) {
            RTestUnitUtil.$$$reportNull$$$0(14);
        }
        List<RClass> classes = RContainerUtil.getTopLevelClasses((RContainer)rFile);
        for (RClass vClass : classes) {
            if (currentContainer == vClass || vClass == null || !RTestUnitUtil.isUnitTestCaseLikeClass(vClass)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Symbol getSymbolByContainerRubyTestMode(@NotNull RContainer container) {
        RFile rFile;
        if (container == null) {
            RTestUnitUtil.$$$reportNull$$$0(15);
        }
        if ((rFile = RubyPsiUtil.getRFile((PsiElement)container)) == null) {
            return null;
        }
        return SymbolUtil.getSymbolByContainer((RElementWithFQN)container);
    }

    @NotNull
    public static String getSimpleTestClassQualifiedName(@NotNull RClass rClass) {
        if (rClass == null) {
            RTestUnitUtil.$$$reportNull$$$0(16);
        }
        String string = rClass.getFQNWithNesting().getFullPath();
        if (string == null) {
            RTestUnitUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classSymbol";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCaseFqn";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/testunit/RTestUnitUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/RTestUnitUtil";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleTestClassQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUserTestCase";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUnitTestCaseLikeClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUnitTestCaseLikeClassWithoutFileNameCheck";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUnitTestCaseDescendant";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isMinitestCaseDescendant";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isTestCaseDescendant";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasValidTestNameAndNotSingleton";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "containsTestCaseLikeClasses";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "containsToplevelMinitestExampleGroups";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkForAnotherTestCaseLikeClasses";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolByContainerRubyTestMode";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleTestClassQualifiedName";
                break;
            }
            case 17: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17 -> new IllegalStateException(string);
        };
    }
}

