/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.shoulda.inspections;

import com.intellij.codeInsight.daemon.impl.quickfix.RenameFileModCommand;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.testing.shoulda.ShouldaUtil;
import org.jetbrains.plugins.ruby.testing.testunit.RTestUnitUtil;

public class UnsupportedShouldaTestFileVisitor
extends RubyInspectionVisitor {
    public UnsupportedShouldaTestFileVisitor(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            UnsupportedShouldaTestFileVisitor.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    public void visitRClass(@NotNull RClass rClass) {
        RName className;
        if (rClass == null) {
            UnsupportedShouldaTestFileVisitor.$$$reportNull$$$0(1);
        }
        if ((className = rClass.getClassName()) == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)rClass);
        if (!ShouldaUtil.isShouldaSupportLoaded(module)) {
            return;
        }
        VirtualFile file = rClass.getContainingFile().getVirtualFile();
        if (!ShouldaUtil.isShouldaTestFile(file, module) && RTestUnitUtil.isUnitTestCaseDescendant(rClass)) {
            assert (file != null);
            RenameFileModCommand renameFileFix = new RenameFileModCommand(file.getNameWithoutExtension() + "_test.rb");
            this.registerProblem((PsiElement)className, RBundle.message((String)"inspection.shoulda.reassignment.error.msg"), LocalQuickFix.from((ModCommandAction)renameFileFix));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/testing/shoulda/inspections/UnsupportedShouldaTestFileVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

