/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.shoulda;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.testing.BddTestsUtil;
import org.jetbrains.plugins.ruby.testing.testunit.RTestUnitUtil;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

public final class ShouldaUtil {
    @NonNls
    public static final String SHOULDA_OLD_GEM_NAME = "thoughtbot-shoulda";
    @NonNls
    public static final String SHOULDA_GEM_NAME = "shoulda";
    @NonNls
    public static final String[] SHOULDA_GEM_NAMES = new String[]{"shoulda", "thoughtbot-shoulda"};
    @NonNls
    public static final String[] SHOULDA_PLUGIN_NAMES = new String[]{"shoulda"};
    @NonNls
    private static final String SHOULDA_CONTEXT_CLASS = "Shoulda::Context";
    @NonNls
    private static final String SHOULDA_CONTEXT_CLASS_3_0 = "Shoulda::Context::Context";
    @NonNls
    public static final String TEST_CALLS_DEFINE_SHORT_NAME = "define_method";
    private static final String[] TEST_CALLS_SHORT_NAMES = new String[]{"should", "should_not"};
    private static final String[] TEST_CALLS_NAMES = ArrayUtil.mergeArrays((String[])TEST_CALLS_SHORT_NAMES, (String[])new String[]{"define_method"});
    public static final String[] GROUP_CALLS_SHORT_NAMES = new String[]{"context"};
    @NonNls
    private static final Set<String> TEST_CALL_SHORT_NAMES_SET = Set.of(TEST_CALLS_SHORT_NAMES);
    @NonNls
    private static final Set<String> TEST_CALLS_NAMES_SET = Set.of(TEST_CALLS_NAMES);
    @NonNls
    private static final Set<String> GROUP_CALLS_SHORT_NAMES_SET = Set.of(GROUP_CALLS_SHORT_NAMES);
    @NonNls
    private static final Set<String> SETUP_TEARDOWN_CALLS_SHORT_NAMES_SET = Set.of("setup", "teardown");
    @NonNls
    private static final Set<String> SHOULDA_CONTAINERS_SET = new HashSet<String>();
    public static final Set<String> TEST_SETUP_TEARDOWN_CALLS_SHORT_NAMES = new HashSet<String>();
    public static final String SHOULDA_MACROS_METHOD_PREFIX = "should_";
    public static final String SHOULDA_ASSERTIONS_MODULE = "Assertions";
    public static final String SHOULDA_MATCHERS_MODULE = "Matchers";
    private static final String SHOULDA_TEST_NAME_PREFIX = "test_: ";

    private ShouldaUtil() {
    }

    @Nullable
    public static RBlockCall getSimpleCoveringExampleGroupScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ShouldaUtil.$$$reportNull$$$0(0);
        }
        return RubyPsiInterpreter.getSimpleCoveringCodeBlockScope(psiElement, GROUP_CALLS_SHORT_NAMES_SET, TEST_SETUP_TEARDOWN_CALLS_SHORT_NAMES);
    }

    @Nullable
    public static RPossibleCall getSimpleCoveringExampleOrSetupTeardownScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ShouldaUtil.$$$reportNull$$$0(1);
        }
        return RubyPsiInterpreter.getSimpleCoveringCodeBlockScope(psiElement, TEST_SETUP_TEARDOWN_CALLS_SHORT_NAMES, GROUP_CALLS_SHORT_NAMES_SET);
    }

    public static boolean isProbablyInCoveringTestScopeRegion(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ShouldaUtil.$$$reportNull$$$0(2);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, SHOULDA_CONTAINERS_SET, null);
    }

    public static boolean isShouldaTestFile(@Nullable VirtualFile file, @Nullable Module module) {
        if (!TestUnitUtil.isFileWithValidTestUnitFileName(file)) {
            return false;
        }
        return ShouldaUtil.isShouldaSupportLoaded(module);
    }

    public static boolean isShouldaSupportLoaded(@Nullable Module module) {
        if (module == null || !ShouldaUtil.isShouldaSupportEnabled(module)) {
            return false;
        }
        return SymbolUtil.findConstantByFQN(module.getProject(), Type.MODULE, FQN.of((String)ShouldaUtil.getMarkerClass(module)), null) != null;
    }

    @NotNull
    private static String getMarkerClass(@NotNull Module module) {
        GemInfo gemInfo;
        if (module == null) {
            ShouldaUtil.$$$reportNull$$$0(3);
        }
        if ((gemInfo = RubyProjectGemSearchService.Companion.findGem(module, SHOULDA_GEM_NAME)) != null && VersionComparatorUtil.compare((String)gemInfo.getVersion(), (String)"4.0.0rc1") >= 0) {
            return "Shoulda::Context::DSL::ClassMethods";
        }
        if (gemInfo != null && VersionComparatorUtil.compare((String)gemInfo.getVersion(), (String)"3.0") >= 0) {
            return "Shoulda::Context::ClassMethods";
        }
        return "Shoulda::ClassMethods";
    }

    @NotNull
    public static String getShouldContextClass(@Nullable Module module) {
        GemInfo gemInfo;
        if (module != null && (gemInfo = RubyProjectGemSearchService.Companion.findGem(module, SHOULDA_GEM_NAME)) != null && VersionComparatorUtil.compare((String)gemInfo.getVersion(), (String)"3.0") >= 0) {
            return SHOULDA_CONTEXT_CLASS_3_0;
        }
        return SHOULDA_CONTEXT_CLASS;
    }

    public static boolean isExampleCall(@NotNull RPossibleCall call) {
        String name;
        if (call == null) {
            ShouldaUtil.$$$reportNull$$$0(4);
        }
        return (name = call.getCommand()) != null && TEST_CALLS_NAMES_SET.contains(name);
    }

    public static boolean isExampleGroupCall(@NotNull RPossibleCall call) {
        String name;
        if (call == null) {
            ShouldaUtil.$$$reportNull$$$0(5);
        }
        return (name = call.getCommand()) != null && GROUP_CALLS_SHORT_NAMES_SET.contains(name);
    }

    public static boolean isContextBeforeAfterCall(@NotNull RPossibleCall call) {
        String name;
        if (call == null) {
            ShouldaUtil.$$$reportNull$$$0(6);
        }
        return (name = call.getCommand()) != null && SETUP_TEARDOWN_CALLS_SHORT_NAMES_SET.contains(name);
    }

    public static boolean isShouldaSupportEnabled(@NotNull Module module) {
        if (module == null) {
            ShouldaUtil.$$$reportNull$$$0(7);
        }
        return GemUtil.isGemOrRailsPluginSupportEnabled(module, SHOULDA_GEM_NAMES, SHOULDA_PLUGIN_NAMES);
    }

    @Nullable
    public static String determineCurrentExampleName(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ShouldaUtil.$$$reportNull$$$0(8);
        }
        Pair<String, String> groupAndExample = ShouldaUtil.determineCurrentGroupAndExample(psiElement);
        return (String)ObjectUtils.doIfNotNull(groupAndExample, it -> ShouldaUtil.getShouldaTestNameFromGroupAndExample((String)it.getFirst(), (String)it.getSecond()));
    }

    @Nullable
    public static Pair<String, String> determineCurrentGroupAndExample(@NotNull PsiElement psiElement) {
        RContainer containerForElement;
        RClass upperClass;
        if (psiElement == null) {
            ShouldaUtil.$$$reportNull$$$0(9);
        }
        RClass rClass = upperClass = (containerForElement = RubyPsiUtilCore.getParentContainerOrSelf((PsiElement)psiElement)) != null ? RubyPsiUtil.getContainingUpperRClass(containerForElement) : null;
        if (upperClass == null) {
            return null;
        }
        final String className = RTestUnitUtil.getSimpleTestClassQualifiedName(upperClass);
        BddTestsUtil.GroupNameBuilder groupNameBuilder = new BddTestsUtil.GroupNameBuilder(GROUP_CALLS_SHORT_NAMES){

            @Override
            @NotNull
            public String getFullGroupName() {
                String fullName = "";
                List<? extends RPsiElement> partsInReversedOrder = this.getPartsInReversedOrder();
                int size = partsInReversedOrder.size();
                if (size == 0) {
                    fullName = className.replaceAll("Test", "");
                } else {
                    for (int i = size - 1; i >= 0; --i) {
                        String text = 1.getArgText(partsInReversedOrder.get(i));
                        fullName = (fullName + " " + StringUtil.notNullize((String)text)).trim();
                    }
                }
                String string = fullName;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/testing/shoulda/ShouldaUtil$1", "getFullGroupName"));
            }
        };
        BddTestsUtil.ExampleNameBuilder exampleNameBuilder = new BddTestsUtil.ExampleNameBuilder(TEST_CALLS_NAMES);
        boolean success = BddTestsUtil.gatherGroupsAndExampleNames(psiElement, groupNameBuilder, exampleNameBuilder);
        String exampleShortName = exampleNameBuilder.getExampleShortName();
        String groupFullName = groupNameBuilder.getFullGroupName();
        boolean isGroupCall = GROUP_CALLS_SHORT_NAMES_SET.contains(psiElement.getText());
        if (!success || !isGroupCall && exampleShortName == null) {
            return null;
        }
        RCall call = (RCall)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RCall.class);
        if (call != null && TEST_CALLS_DEFINE_SHORT_NAME.equals(call.getCommand()) && exampleShortName != null) {
            return Pair.create(null, (Object)StringUtil.substringAfter((String)exampleShortName, (String)SHOULDA_TEST_NAME_PREFIX));
        }
        return Pair.create((Object)groupFullName, (Object)exampleShortName);
    }

    @Nullable
    public static String getShouldaTestNameFromGroupAndExample(@Nullable String group, @Nullable String example) {
        if (group == null && example == null) {
            return null;
        }
        Object prefix = group == null ? "" : group + " should ";
        return example == null ? group : (String)prefix + example;
    }

    @Nullable
    public static String getShouldaTestName(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ShouldaUtil.$$$reportNull$$$0(10);
        }
        Pair<String, String> groupAndExample = ShouldaUtil.determineCurrentGroupAndExample(psiElement);
        return ShouldaUtil.getShouldaTestName(psiElement, (String)ObjectUtils.doIfNotNull(groupAndExample, p -> (String)p.getFirst()), (String)ObjectUtils.doIfNotNull(groupAndExample, p -> (String)p.getSecond()));
    }

    @Nullable
    public static String getShouldaTestName(@NotNull PsiElement psiElement, @Nullable String group, @Nullable String example) {
        if (psiElement == null) {
            ShouldaUtil.$$$reportNull$$$0(11);
        }
        if (group == null && example == null) {
            return null;
        }
        if (example == null) {
            return SHOULDA_TEST_NAME_PREFIX + group;
        }
        String testName = ShouldaUtil.getShouldaTestNameFromGroupAndExample(group, example);
        RCall call = (RCall)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RCall.class);
        return SHOULDA_TEST_NAME_PREFIX + testName + (call != null && TEST_CALLS_DEFINE_SHORT_NAME.equals(call.getCommand()) ? "" : ". ");
    }

    @Nullable
    public static String getShouldaTestNameFilter(@NotNull PsiElement psiElement) {
        Pair<String, String> groupAndExample;
        if (psiElement == null) {
            ShouldaUtil.$$$reportNull$$$0(12);
        }
        if ((groupAndExample = ShouldaUtil.determineCurrentGroupAndExample(psiElement)) == null) {
            return null;
        }
        String testName = ShouldaUtil.getShouldaTestName(psiElement, (String)groupAndExample.getFirst(), (String)groupAndExample.getSecond());
        if (testName == null) {
            return null;
        }
        return groupAndExample.getSecond() == null ? TestUnitUtil.wrapWithRegexpStart(RubyTextUtil.escapeRegexSpecialCharacters((String)testName, (Character[])new Character[]{Character.valueOf(' ')})) : TestUnitUtil.wrapWithRegexpStartEnd(RubyTextUtil.escapeRegexSpecialCharacters((String)testName, (Character[])new Character[]{Character.valueOf(' ')}));
    }

    @Nullable
    public static RPsiElement findValidTestClosure(@NotNull String name, @NotNull RClass rClass) {
        if (name == null) {
            ShouldaUtil.$$$reportNull$$$0(13);
        }
        if (rClass == null) {
            ShouldaUtil.$$$reportNull$$$0(14);
        }
        List<RPsiElement> testClosures = ShouldaUtil.collectAllShouldClosuresFrom(rClass);
        for (RPsiElement testClosure : testClosures) {
            String testName = ShouldaUtil.getShouldaTestName((PsiElement)testClosure);
            if (!name.equals(testName)) continue;
            return testClosure;
        }
        return null;
    }

    @NotNull
    private static List<RPsiElement> collectAllShouldClosuresFrom(@NotNull RClass rClass) {
        if (rClass == null) {
            ShouldaUtil.$$$reportNull$$$0(15);
        }
        ArrayList<RPsiElement> testClosureBlocks = new ArrayList<RPsiElement>();
        ShouldaUtil.collectAllTestShouldFrom(rClass.getCompoundStatement(), testClosureBlocks);
        List<Object> list = !testClosureBlocks.isEmpty() ? testClosureBlocks : Collections.emptyList();
        if (list == null) {
            ShouldaUtil.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static void collectAllTestShouldFrom(RCompoundStatement compoundStatement, List<RPsiElement> exampleLikeElements) {
        if (compoundStatement == null) {
            return;
        }
        List statements = compoundStatement.getStatements();
        for (RPsiElement statement : statements) {
            if (!(statement instanceof RPossibleCall)) continue;
            RPossibleCall possibleCall = (RPossibleCall)statement;
            if (ShouldaUtil.isExampleCall(possibleCall)) {
                exampleLikeElements.add(statement);
                continue;
            }
            if (!(possibleCall instanceof RBlockCall) || !ShouldaUtil.isExampleGroupCall(possibleCall)) continue;
            RCompoundStatement contextStatement = ((RBlockCall)possibleCall).getBlock().getCompoundStatement();
            ShouldaUtil.collectAllTestShouldFrom(contextStatement, exampleLikeElements);
        }
    }

    static {
        TEST_SETUP_TEARDOWN_CALLS_SHORT_NAMES.addAll(TEST_CALL_SHORT_NAMES_SET);
        TEST_SETUP_TEARDOWN_CALLS_SHORT_NAMES.add(TEST_CALLS_DEFINE_SHORT_NAME);
        TEST_SETUP_TEARDOWN_CALLS_SHORT_NAMES.addAll(SETUP_TEARDOWN_CALLS_SHORT_NAMES_SET);
        SHOULDA_CONTAINERS_SET.addAll(GROUP_CALLS_SHORT_NAMES_SET);
        SHOULDA_CONTAINERS_SET.addAll(TEST_CALLS_NAMES_SET);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/shoulda/ShouldaUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/shoulda/ShouldaUtil";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllShouldClosuresFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleCoveringExampleGroupScope";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleCoveringExampleOrSetupTeardownScope";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isProbablyInCoveringTestScopeRegion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMarkerClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isExampleCall";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isExampleGroupCall";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isContextBeforeAfterCall";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isShouldaSupportEnabled";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "determineCurrentExampleName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "determineCurrentGroupAndExample";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getShouldaTestName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getShouldaTestNameFilter";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findValidTestClosure";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectAllShouldClosuresFrom";
                break;
            }
            case 16: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16 -> new IllegalStateException(string);
        };
    }
}

