/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.structure;

import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleTextAttributes;
import icons.RubyIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBraceBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;

public final class RSpecStructureViewPresentationUtil {
    private static final TextAttributesKey DISABLED_SPEC_EXAMPLE_ATTRIBUTES = TextAttributesKey.createTextAttributesKey((String)"DISABLED_SPEC_EXAMPLE", (TextAttributes)SimpleTextAttributes.GRAY_ATTRIBUTES.toTextAttributes());

    private RSpecStructureViewPresentationUtil() {
    }

    @Nullable
    private static Icon getIconForExampleLike(RPossibleCall possibleCall) {
        if (RSpecUtil.isDisabledExampleCall(possibleCall)) {
            return AllIcons.Nodes.TestIgnored;
        }
        if (RSpecUtil.isPendingExampleCall(possibleCall)) {
            return PoolOfTestIcons.IGNORED_ICON;
        }
        if (RSpecUtil.isExampleCall(possibleCall)) {
            return AllIcons.Nodes.Test;
        }
        if (RSpecUtil.isSharedGroupRef(possibleCall)) {
            return RubyIcons.Rspec.RspecSharedGroupRef;
        }
        return null;
    }

    @Nullable
    private static TextAttributesKey getTextAttrsKeyForExampleLike(RPossibleCall possibleCall) {
        return RSpecUtil.isDisabledExampleCall(possibleCall) || RSpecUtil.isPendingExampleCall(possibleCall) ? DISABLED_SPEC_EXAMPLE_ATTRIBUTES : null;
    }

    @NotNull
    private static String getFullNameForExampleLike(RPossibleCall possibleCall) {
        Object text = null;
        if (possibleCall instanceof RBlockCall) {
            text = RSpecUtil.getCurrentExampleName((PsiElement)((RBlockCall)possibleCall).getCall());
        } else if (possibleCall instanceof RCall) {
            text = RSpecUtil.getCurrentExampleName((PsiElement)possibleCall);
            if (RSpecUtil.isSharedGroupRef(possibleCall)) {
                text = (String)text + " " + RSpecStructureViewPresentationUtil.getPresentableNameForTreeMode(possibleCall);
            }
        }
        Object object = text != null ? text : RBundle.message((String)"rspec.structure.view.example.undocumented");
        if (object == null) {
            RSpecStructureViewPresentationUtil.$$$reportNull$$$0(0);
        }
        return object;
    }

    @NotNull
    private static String getPresentableNameForTreeMode(@NotNull RPossibleCall possibleCall) {
        RPossibleCall element;
        if (possibleCall == null) {
            RSpecStructureViewPresentationUtil.$$$reportNull$$$0(1);
        }
        RPossibleCall rPossibleCall = element = possibleCall instanceof RBlockCall ? ((RBlockCall)possibleCall).getCall() : possibleCall;
        if (RSpecUtil.isExampleBeforeAfterCall(possibleCall)) {
            String name = element.getText();
            assert (name != null);
            String string = name;
            if (string == null) {
                RSpecStructureViewPresentationUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (element instanceof RCall) {
            @NotNull RCall rspecCall = (RCall)element;
            if (RSpecUtil.isExampleSubjectCall(element)) {
                String name = possibleCall instanceof RBlockCall ? RSpecUtil.determineItsExampleFullName((RBlockCall)possibleCall, false) : null;
                return name != null ? name : "[noname]";
            }
            String firstArgText = RSpecStructureViewPresentationUtil.getFirstArgPresentableText(rspecCall);
            if (RSpecUtil.isSharedGroupRef(element)) {
                String string = "<< [" + firstArgText + "]";
                if (string == null) {
                    RSpecStructureViewPresentationUtil.$$$reportNull$$$0(3);
                }
                return string;
            }
            if (firstArgText != null) {
                String string = firstArgText;
                if (string == null) {
                    RSpecStructureViewPresentationUtil.$$$reportNull$$$0(4);
                }
                return string;
            }
        }
        String string = !(possibleCall instanceof RBraceBlockCall) ? RBundle.message((String)"rspec.structure.view.example.undocumented") : ((RBraceBlockCall)possibleCall).getBlock().getCompoundStatement().getText().replaceAll("\\s", " ");
        if (string == null) {
            RSpecStructureViewPresentationUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static ItemPresentation getNodePresentationInTreeMode(RPossibleCall possibleCall) {
        TextAttributesKey textAttrs;
        Icon icon;
        if (RSpecUtil.isExampleGroupCall(possibleCall)) {
            icon = AllIcons.Nodes.TestGroup;
            textAttrs = null;
        } else if (RSpecUtil.isExampleCall(possibleCall) || RSpecUtil.isSharedGroupRef(possibleCall)) {
            icon = RSpecStructureViewPresentationUtil.getIconForExampleLike(possibleCall);
            textAttrs = RSpecStructureViewPresentationUtil.getTextAttrsKeyForExampleLike(possibleCall);
        } else if (RSpecUtil.isExampleBeforeAfterCall(possibleCall)) {
            icon = AllIcons.Nodes.Method;
            textAttrs = null;
        } else if (RSpecUtil.isSharedExampleGroupCall(possibleCall)) {
            icon = RubyIcons.Rspec.RspecSharedGroup;
            textAttrs = null;
        } else {
            icon = null;
            textAttrs = null;
        }
        return new PresentationData(RSpecStructureViewPresentationUtil.getPresentableNameForTreeMode(possibleCall), null, icon, textAttrs);
    }

    public static ItemPresentation getNodePresentationInListMode(RPossibleCall possibleCall) {
        Icon icon = RSpecStructureViewPresentationUtil.getIconForExampleLike(possibleCall);
        return new PresentationData(RSpecStructureViewPresentationUtil.getFullNameForExampleLike(possibleCall), null, icon, RSpecStructureViewPresentationUtil.getTextAttrsKeyForExampleLike(possibleCall));
    }

    @Nullable
    public static String getFirstArgPresentableText(RCall rspecCall) {
        List list = rspecCall.getArguments();
        if (!list.isEmpty()) {
            RPsiElement firstArg = (RPsiElement)list.get(0);
            String elementText = RubyPsiUtilCore.getElementText((PsiElement)firstArg);
            if (elementText == null || firstArg instanceof RStringLiteral) {
                return elementText;
            }
            return elementText.replaceAll("\\s", " ");
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/structure/RSpecStructureViewPresentationUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullNameForExampleLike";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/structure/RSpecStructureViewPresentationUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableNameForTreeMode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableNameForTreeMode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

