/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.structure;

import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.structureView.newStructureView.TreeActionsOwner;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NlsActions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import icons.RubyIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoBlockCall;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.rspec.structure.RSpecStructureViewElement;

public class RSpecStructureViewModel
extends TextEditorBasedStructureViewModel
implements StructureViewModel.ElementInfoProvider {
    private static final Class[] SUITABLE_CLASSES = new Class[]{RContainer.class, RBlockCall.class};
    private final Filter[] myFilters;
    private final Grouper[] myGroupers;
    private final RPsiElement myRoot;
    @Nullable
    private TreeActionsOwner myActionsOwner;
    static final String LIST_VIEW_GROUPER = "FakeListViewGrouper";

    public RSpecStructureViewModel(RPsiElement root, @Nullable Editor editor) {
        super(editor, root.getContainingFile());
        this.myRoot = root;
        this.myFilters = new Filter[]{new HideBeforeAfterCallsFilter(), new HideActiveExamplesFilter(), new HidePendingExamplesFilter(), new HideDisabledExamplesFilter()};
        this.myGroupers = new Grouper[]{new FakeListViewGrouper()};
    }

    public Filter @NotNull [] getFilters() {
        if (this.myFilters == null) {
            RSpecStructureViewModel.$$$reportNull$$$0(0);
        }
        return this.myFilters;
    }

    public Sorter @NotNull [] getSorters() {
        Sorter[] sorterArray = new Sorter[]{Sorter.ALPHA_SORTER};
        if (sorterArray == null) {
            RSpecStructureViewModel.$$$reportNull$$$0(1);
        }
        return sorterArray;
    }

    public Grouper @NotNull [] getGroupers() {
        if (this.myGroupers == null) {
            RSpecStructureViewModel.$$$reportNull$$$0(2);
        }
        return this.myGroupers;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        return new RSpecStructureViewElement(this.myRoot, true, this);
    }

    public boolean isListViewEnabled() {
        return this.myActionsOwner != null && this.myActionsOwner.isActionActive(LIST_VIEW_GROUPER);
    }

    public void setTreeActionsOwner(TreeActionsOwner actionsOwner) {
        this.myActionsOwner = actionsOwner;
    }

    protected PsiFile getPsiFile() {
        return this.myRoot.getContainingFile();
    }

    protected Class @NotNull [] getSuitableClasses() {
        if (SUITABLE_CLASSES == null) {
            RSpecStructureViewModel.$$$reportNull$$$0(3);
        }
        return SUITABLE_CLASSES;
    }

    protected boolean isSuitable(PsiElement element) {
        return super.isSuitable(element) && RSpecStructureViewModel.checkIsSuitableRBlockCall(element);
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        Object value = element.getValue();
        if (value instanceof RFile) {
            return true;
        }
        if (value instanceof RDoBlockCall) {
            RPossibleCall call = ((RDoBlockCall)value).getCall();
            return RSpecUtil.isExampleGroupCall(call) || RSpecUtil.isSharedExampleGroupCall(call);
        }
        return false;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        Object value = element.getValue();
        if (value instanceof RDoBlockCall) {
            RPossibleCall call = ((RDoBlockCall)value).getCall();
            return RSpecUtil.isExampleBeforeAfterCall(call) || RSpecUtil.isExampleCall(call);
        }
        return false;
    }

    private static boolean checkIsSuitableRBlockCall(PsiElement element) {
        if (element instanceof RBlockCall) {
            RBlockCall blockCall = (RBlockCall)element;
            return RSpecUtil.isExampleGroupCall((RPossibleCall)blockCall) || RSpecUtil.isSharedExampleGroupCall((RPossibleCall)blockCall) || RSpecUtil.isExampleBeforeAfterCall((RPossibleCall)blockCall) || RSpecUtil.isExampleCall((RPossibleCall)blockCall) || RSpecUtil.isSharedGroupRef((RPossibleCall)blockCall);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/testing/rspec/structure/RSpecStructureViewModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSorters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableClasses";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class HideBeforeAfterCallsFilter
    extends BaseFilter {
        private HideBeforeAfterCallsFilter() {
            super(RBundle.message((String)"rspec.structure.view.filters.before.after.calls.title"), RBundle.message((String)"rspec.structure.view.filters.before.after.calls.description"), AllIcons.Nodes.Method, HideBeforeAfterCallsFilter.class.getName());
        }

        @Override
        protected boolean isBlockCallVisible(RBlockCall blockCall) {
            return !RSpecUtil.isExampleBeforeAfterCall((RPossibleCall)blockCall);
        }
    }

    private static final class HideActiveExamplesFilter
    extends BaseFilter {
        private HideActiveExamplesFilter() {
            super(RBundle.message((String)"rspec.structure.view.filters.examples.active.title"), RBundle.message((String)"rspec.structure.view.filters.examples.active.description"), AllIcons.Nodes.Test, HideActiveExamplesFilter.class.getName());
        }

        @Override
        protected boolean isBlockCallVisible(RBlockCall blockCall) {
            return !RSpecUtil.isExampleCall((RPossibleCall)blockCall) || RSpecUtil.isDisabledExampleCall((RPossibleCall)blockCall) || RSpecUtil.isPendingExampleCall((RPossibleCall)blockCall);
        }
    }

    private static final class HidePendingExamplesFilter
    extends BaseFilter {
        private HidePendingExamplesFilter() {
            super(RBundle.message((String)"rspec.structure.view.filters.examples.pending.title"), RBundle.message((String)"rspec.structure.view.filters.examples.pending.description"), PoolOfTestIcons.IGNORED_ICON, HidePendingExamplesFilter.class.getName());
        }

        @Override
        protected boolean isBlockCallVisible(RBlockCall blockCall) {
            return !RSpecUtil.isPendingExampleCall((RPossibleCall)blockCall);
        }
    }

    private static final class HideDisabledExamplesFilter
    extends BaseFilter {
        private HideDisabledExamplesFilter() {
            super(RBundle.message((String)"rspec.structure.view.filters.examples.disabled.title"), RBundle.message((String)"rspec.structure.view.filters.examples.disabled.description"), AllIcons.Nodes.TestIgnored, HideDisabledExamplesFilter.class.getName());
        }

        @Override
        protected boolean isBlockCallVisible(RBlockCall blockCall) {
            return !RSpecUtil.isDisabledExampleCall((RPossibleCall)blockCall);
        }
    }

    private static class FakeListViewGrouper
    implements Grouper {
        FakeListViewGrouper() {
        }

        @NotNull
        public Collection<Group> group(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<TreeElement> children) {
            if (parent == null) {
                FakeListViewGrouper.$$$reportNull$$$0(0);
            }
            if (children == null) {
                FakeListViewGrouper.$$$reportNull$$$0(1);
            }
            List<Group> list = Collections.emptyList();
            if (list == null) {
                FakeListViewGrouper.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            return new ActionPresentationData(RBundle.message((String)"rspec.structure.view.actions.list.view.title"), RBundle.message((String)"rspec.structure.view.actions.list.view.description"), RubyIcons.Rspec.StructureListView);
        }

        @NotNull
        public String getName() {
            return RSpecStructureViewModel.LIST_VIEW_GROUPER;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/structure/RSpecStructureViewModel$FakeListViewGrouper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/structure/RSpecStructureViewModel$FakeListViewGrouper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "group";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class BaseFilter
    implements Filter {
        private final ActionPresentationData myPresentationData;
        private final String myFilterId;

        protected abstract boolean isBlockCallVisible(RBlockCall var1);

        protected BaseFilter(@NlsActions.ActionText String title, @NlsActions.ActionDescription String description, Icon icon, String filterId) {
            this.myPresentationData = new ActionPresentationData(title, description, icon);
            this.myFilterId = filterId;
        }

        public boolean isVisible(TreeElement treeNode) {
            RSpecStructureViewElement element = (RSpecStructureViewElement)treeNode;
            PsiElement value = element.getValue();
            if (value instanceof RBlockCall) {
                RBlockCall blockCall = (RBlockCall)value;
                return this.isBlockCallVisible(blockCall);
            }
            return true;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            ActionPresentationData actionPresentationData = this.myPresentationData;
            if (actionPresentationData == null) {
                BaseFilter.$$$reportNull$$$0(0);
            }
            return actionPresentationData;
        }

        public boolean isReverted() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = this.myFilterId;
            if (string == null) {
                BaseFilter.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/plugins/ruby/testing/rspec/structure/RSpecStructureViewModel$BaseFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

