/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.run;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PopupUtilsKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import icons.RubyIcons;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RSpecSharedGroupRefIndex;
import org.jetbrains.plugins.ruby.testing.rspec.run.RSpecRunConfiguration;

public final class RSpecSharedGroupOnFirstRunCustomizer {
    private static final int MAX_INCLUSION_DEPTH = 12;
    private static final Set<String> STRING_INTERPOLATION_PREFIXES = Set.of("#{", "#@", "#$");

    private RSpecSharedGroupOnFirstRunCustomizer() {
    }

    public static boolean customizeAndRun(@NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext context, @NotNull Runnable startRunnable) {
        if (configuration == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(1);
        }
        if (startRunnable == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(2);
        }
        if (context.containsMultipleSelection()) {
            return false;
        }
        if (context.getDataContext().getData(SMTRunnerTestTreeView.SM_TEST_RUNNER_VIEW) != null) {
            return false;
        }
        PsiElement element = context.getPsiLocation();
        if (element == null) {
            return false;
        }
        if (!RSpecUtil.isProbablyInSharedExampleGroupScope(element)) {
            return false;
        }
        RBlockCall sharedGroup = RSpecUtil.getCoveringSharedExampleGroupScope(element);
        if (sharedGroup == null) {
            return false;
        }
        RSpecRunConfiguration config = (RSpecRunConfiguration)ObjectUtils.tryCast((Object)configuration.getConfiguration(), RSpecRunConfiguration.class);
        if (config == null) {
            return false;
        }
        if (config.getExampleNamesFilter().contains("||")) {
            return false;
        }
        if (ContainerUtil.exists(STRING_INTERPOLATION_PREFIXES, prefix -> config.getExampleNamesFilter().contains((CharSequence)prefix))) {
            return false;
        }
        Project project = context.getProject();
        List<MyRSpecExampleGroup> refGroups = RSpecSharedGroupOnFirstRunCustomizer.collectReferencingGroups(sharedGroup, project, GlobalSearchScope.projectScope((Project)project));
        return RSpecSharedGroupOnFirstRunCustomizer.chooseExamplesGroupAndRun(sharedGroup, refGroups, config, context, startRunnable);
    }

    @NotNull
    private static List<MyRSpecExampleGroup> collectReferencingGroups(@NotNull RBlockCall sharedGroup, @NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (sharedGroup == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(3);
        }
        if (project == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(5);
        }
        List list = ContainerUtil.sorted(RSpecSharedGroupOnFirstRunCustomizer.recursivelyCollectReferencingGroups(sharedGroup, project, searchScope, 12), Comparator.comparing(MyRSpecExampleGroup::getName));
        if (list == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static List<MyRSpecExampleGroup> recursivelyCollectReferencingGroups(@NotNull RBlockCall sharedGroup, @NotNull Project project, @NotNull GlobalSearchScope searchScope, int inclusionDepthLimit) {
        if (sharedGroup == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(7);
        }
        if (project == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(8);
        }
        if (searchScope == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(9);
        }
        ProgressManager.checkCanceled();
        if (inclusionDepthLimit <= 0) {
            List<MyRSpecExampleGroup> list = Collections.emptyList();
            if (list == null) {
                RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(10);
            }
            return list;
        }
        RBlockCall sharedContextGroup = RSpecUtil.getCoveringExampleGroupScope((PsiElement)sharedGroup);
        String sharedGroupName = RSpecUtil.getRspecGroupName(sharedGroup);
        if (StringUtil.isEmpty((String)sharedGroupName)) {
            List<MyRSpecExampleGroup> list = Collections.emptyList();
            if (list == null) {
                RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(11);
            }
            return list;
        }
        HashSet<MyRSpecExampleGroup> refGroups = new HashSet<MyRSpecExampleGroup>();
        for (RCall ref : RSpecSharedGroupRefIndex.getInstance().getElements(project, (SearchScope)searchScope, sharedGroupName)) {
            RBlockCall group = RSpecUtil.getCoveringExampleGroupScope((PsiElement)ref);
            if (group == null || sharedContextGroup != null && !PsiTreeUtil.isAncestor((PsiElement)sharedContextGroup, (PsiElement)group, (boolean)false)) continue;
            String refSnippet = RSpecSharedGroupOnFirstRunCustomizer.getSharedGroupReferenceSnippet(ref);
            String refFilter = RSpecSharedGroupOnFirstRunCustomizer.getSharedGroupReferenceFilter(sharedGroupName, ref);
            if (RSpecUtil.isSharedExampleGroupCall((RPossibleCall)group)) {
                for (MyRSpecExampleGroup refGroup : RSpecSharedGroupOnFirstRunCustomizer.recursivelyCollectReferencingGroups(group, project, searchScope, inclusionDepthLimit - 1)) {
                    String fullFilter = refGroup.getFilter() + refFilter;
                    refGroups.add(new MyRSpecExampleGroup(refGroup.getName(), fullFilter, refSnippet, refGroup.getTestFile()));
                }
                continue;
            }
            String name = RSpecUtil.getCurrentExampleName((PsiElement)group);
            String filter = RSpecUtil.getCurrentExampleFilter((PsiElement)group);
            VirtualFile testFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)group);
            if (name == null || filter == null || testFile == null) continue;
            String fullFilter = filter + refFilter;
            refGroups.add(new MyRSpecExampleGroup(name, fullFilter, refSnippet, testFile));
        }
        List<MyRSpecExampleGroup> list = List.copyOf(refGroups);
        if (list == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static boolean chooseExamplesGroupAndRun(@NotNull RBlockCall sharedGroup, @NotNull List<? extends MyRSpecExampleGroup> refGroups, @NotNull RSpecRunConfiguration config, @NotNull ConfigurationContext context, @NotNull Runnable startRunnable) {
        if (sharedGroup == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(13);
        }
        if (refGroups == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(14);
        }
        if (config == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(15);
        }
        if (context == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(16);
        }
        if (startRunnable == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(17);
        }
        if (refGroups.isEmpty()) {
            return false;
        }
        if (refGroups.size() == 1) {
            RSpecSharedGroupOnFirstRunCustomizer.runChosenExamplesGroup(refGroups, refGroups, config, sharedGroup, startRunnable);
        } else {
            List allGroups = ContainerUtil.prepend(refGroups, (Object[])new MyRSpecExampleGroup[]{null});
            RSpecSharedGroupOnFirstRunCustomizer.showGroupChoosingPopUp(allGroups, context, (Consumer<Collection<? extends MyRSpecExampleGroup>>)((Consumer)chosen -> RSpecSharedGroupOnFirstRunCustomizer.runChosenExamplesGroup(chosen, allGroups, config, sharedGroup, startRunnable)));
        }
        return true;
    }

    private static void runChosenExamplesGroup(@NotNull Collection<? extends MyRSpecExampleGroup> chosenGroups, @NotNull List<? extends MyRSpecExampleGroup> allGroups, @NotNull RSpecRunConfiguration config, @NotNull RBlockCall sharedGroup, @NotNull Runnable startRunnable) {
        if (chosenGroups == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(18);
        }
        if (allGroups == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(19);
        }
        if (config == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(20);
        }
        if (sharedGroup == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(21);
        }
        if (startRunnable == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(22);
        }
        ProgressManager.checkCanceled();
        if (chosenGroups.isEmpty()) {
            return;
        }
        MyRSpecExampleGroup chosenGroup = (MyRSpecExampleGroup)ContainerUtil.getFirstItem(chosenGroups);
        String sharedGroupFilter = RSpecUtil.getCurrentExampleFilter((PsiElement)sharedGroup);
        if (chosenGroup == null) {
            config.setName(RBundle.message((String)"rspec.run.configuration.name.prefix.run.all", (Object[])new Object[]{config.getName()}));
            config.setExampleNamesFilter(allGroups.stream().filter(Objects::nonNull).map(it -> it.getFilter()).map(filter -> StringUtils.replaceOnce((String)config.getExampleNamesFilter(), (String)sharedGroupFilter, (String)filter)).collect(Collectors.joining("||")));
            config.setTestScriptsPaths(allGroups.stream().filter(Objects::nonNull).map(MyRSpecExampleGroup::getTestFile).map(VirtualFile::getPath).toList());
            config.setTestType(AbstractRubyTestsRunConfigurationParams.TestType.CUSTOM_SET_OF_FILES);
            config.setTestScriptPath("");
        } else {
            String filter2 = StringUtils.replaceOnce((String)config.getExampleNamesFilter(), (String)sharedGroupFilter, (String)chosenGroup.getFilter());
            config.setName(filter2);
            config.setExampleNamesFilter(filter2);
            config.setTestScriptPath(chosenGroup.getTestFile().getPath());
        }
        startRunnable.run();
    }

    private static void showGroupChoosingPopUp(final @NotNull List<? extends MyRSpecExampleGroup> refGroups, @NotNull ConfigurationContext context, @NotNull Consumer<Collection<? extends MyRSpecExampleGroup>> itemsChosenCallback) {
        if (refGroups == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(23);
        }
        if (context == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(24);
        }
        if (itemsChosenCallback == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(25);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            itemsChosenCallback.consume(refGroups);
        } else {
            JBPopupFactory.getInstance().createPopupChooserBuilder(refGroups).setRenderer((ListCellRenderer)new ColoredListCellRenderer<MyRSpecExampleGroup>(){

                protected void customizeCellRenderer(@NotNull JList<? extends MyRSpecExampleGroup> list, MyRSpecExampleGroup group, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (group == null) {
                        int n = refGroups.size() - 1;
                        this.append(RBundle.message((String)"rspec.run.configuration.run.all.example.groups", (Object[])new Object[]{n}), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES, true);
                        this.setToolTipText(RBundle.message((String)"rspec.run.configuration.run.all.example.groups.tooltip", (Object[])new Object[]{n}));
                    } else {
                        String name = group.getName();
                        String snippet = group.getReferenceSnippet();
                        this.append(StringUtil.shortenTextWithEllipsis((String)name, (int)50, (int)3, (boolean)true), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
                        this.append(" ");
                        this.append(StringUtil.shortenTextWithEllipsis((String)snippet, (int)50, (int)3, (boolean)true), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.setToolTipText(name + " | " + snippet);
                        this.setIcon(RubyIcons.Rspec.RspecRunConfiguration);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecSharedGroupOnFirstRunCustomizer$1", "customizeCellRenderer"));
                }
            }).setTitle(RBundle.message((String)"rspec.run.configuration.title.run.example.groups")).setSelectionMode(0).setAutoselectOnMouseMove(true).setNamerForFiltering(group -> group == null ? "" : group.getName()).setMovable(true).setResizable(false).setRequestFocus(true).setMinSize((Dimension)JBUI.size((int)270, (int)55)).setItemsChosenCallback(itemsChosenCallback).createPopup().show(PopupUtilsKt.getBestPopupPosition((DataContext)context.getDataContext()));
        }
    }

    @NotNull
    private static String getSharedGroupReferenceSnippet(@NotNull RCall ref) {
        if (ref == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(26);
        }
        String string = StringUtil.collapseWhiteSpace((CharSequence)(ref.getCommand() + (String)(!ref.getArguments().isEmpty() ? " " + ((RPsiElement)ref.getArguments().get(0)).getText() : "")));
        if (string == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Nls
    @NotNull
    private static String getSharedGroupReferenceFilter(@NotNull String groupName, @NotNull RCall reference) {
        if (groupName == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(28);
        }
        if (reference == null) {
            RSpecSharedGroupOnFirstRunCustomizer.$$$reportNull$$$0(29);
        }
        return switch (reference.getCommand()) {
            case "it_should_behave_like" -> RBundle.message((String)"rspec.run.configuration.example.should.behave.like", (Object[])new Object[]{groupName});
            case "it_behaves_like" -> RBundle.message((String)"rspec.run.configuration.example.behaves.like", (Object[])new Object[]{groupName});
            default -> "";
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10, 11, 12, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRunnable";
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedGroup";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecSharedGroupOnFirstRunCustomizer";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refGroups";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenGroups";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allGroups";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemsChosenCallback";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecSharedGroupOnFirstRunCustomizer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectReferencingGroups";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "recursivelyCollectReferencingGroups";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedGroupReferenceSnippet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customizeAndRun";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectReferencingGroups";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 27: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "recursivelyCollectReferencingGroups";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "chooseExamplesGroupAndRun";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "runChosenExamplesGroup";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "showGroupChoosingPopUp";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSharedGroupReferenceSnippet";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getSharedGroupReferenceFilter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 10, 11, 12, 27 -> new IllegalStateException(string);
        };
    }

    private static class MyRSpecExampleGroup {
        private final String myName;
        private final String myFilter;
        private final String myReferenceSnippet;
        private final VirtualFile myTestFile;

        private MyRSpecExampleGroup(@NotNull String name, @NotNull String filter, @NotNull String referenceSnippet, @NotNull VirtualFile testFile) {
            if (name == null) {
                MyRSpecExampleGroup.$$$reportNull$$$0(0);
            }
            if (filter == null) {
                MyRSpecExampleGroup.$$$reportNull$$$0(1);
            }
            if (referenceSnippet == null) {
                MyRSpecExampleGroup.$$$reportNull$$$0(2);
            }
            if (testFile == null) {
                MyRSpecExampleGroup.$$$reportNull$$$0(3);
            }
            this.myName = name;
            this.myFilter = filter;
            this.myReferenceSnippet = referenceSnippet;
            this.myTestFile = testFile;
        }

        @NotNull
        String getName() {
            String string = this.myName;
            if (string == null) {
                MyRSpecExampleGroup.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        String getFilter() {
            String string = this.myFilter;
            if (string == null) {
                MyRSpecExampleGroup.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        String getReferenceSnippet() {
            String string = this.myReferenceSnippet;
            if (string == null) {
                MyRSpecExampleGroup.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        VirtualFile getTestFile() {
            VirtualFile virtualFile = this.myTestFile;
            if (virtualFile == null) {
                MyRSpecExampleGroup.$$$reportNull$$$0(7);
            }
            return virtualFile;
        }

        @NotNull
        public String toString() {
            String string = "MyRSpecExampleGroup{myName='" + this.myName + "', myFilter='" + this.myFilter + "', myReferenceSnippet='" + this.myReferenceSnippet + "', myTestFile='" + this.myTestFile.getPath() + "'}";
            if (string == null) {
                MyRSpecExampleGroup.$$$reportNull$$$0(8);
            }
            return string;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyRSpecExampleGroup that = (MyRSpecExampleGroup)o;
            return Objects.equals(this.myName, that.myName) && Objects.equals(this.myFilter, that.myFilter) && Objects.equals(this.myReferenceSnippet, that.myReferenceSnippet) && Objects.equals(this.myTestFile, that.myTestFile);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + this.myFilter.hashCode();
            result = 31 * result + this.myReferenceSnippet.hashCode();
            result = 31 * result + this.myTestFile.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceSnippet";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testFile";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecSharedGroupOnFirstRunCustomizer$MyRSpecExampleGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecSharedGroupOnFirstRunCustomizer$MyRSpecExampleGroup";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilter";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferenceSnippet";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTestFile";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    }
}

