/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.run;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.statistics.FusCollectSettingChangesRunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractTestRunConfigurationWithTestPath;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.statistic.RubyRunConfigurationSettingChangesCollector;
import org.jetbrains.plugins.ruby.testing.PreloadedTestRunConfiguration;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.rspec.run.RSpecRunCommandLineState;
import org.jetbrains.plugins.ruby.testing.rspec.run.RSpecRunConfigurationEditor;
import org.jetbrains.plugins.ruby.testing.rspec.run.RSpecRunConfigurationExternalizer;
import org.jetbrains.plugins.ruby.testing.rspec.runConfigurations.RSpecRunConfigurationParams;

public class RSpecRunConfiguration
extends AbstractTestRunConfigurationWithTestPath<RSpecRunConfiguration>
implements RSpecRunConfigurationParams,
PreloadedTestRunConfiguration,
FusCollectSettingChangesRunConfiguration {
    @NonNls
    public static final String DEFAULT_TESTS_SEARCH_MASK = "**/*_spec." + RubyFileType.RUBY.getDefaultExtension();
    static final String LINE_NUMBER_REGEX = "(\\d+)$";
    static final String EXAMPLE_IDS_REGEX = "\\[(\\d+(:\\d+)*)(,\\s*(\\d+(:\\d+)*))*]$";
    static final Pattern LINE_NUMBER_PATTERN = Pattern.compile("^(\\d+)$");
    static final Pattern EXAMPLE_IDS_PATTERN = Pattern.compile("^\\[(\\d+(:\\d+)*)(,\\s*(\\d+(:\\d+)*))*]$");
    static final Pattern SCRIPT_PATH_WITH_LINE_NUMBER_OR_EXAMPLE_IDS_PATTERN = Pattern.compile(String.format("(.*)(:%s|%s)", "(\\d+)$", "\\[(\\d+(:\\d+)*)(,\\s*(\\d+(:\\d+)*))*]$"));
    private String mySpecArgs = "";
    @NotNull
    private String myExampleNameFilter = "";
    private boolean myUseExampleMatches = false;
    @NotNull
    private String myLineNumberOrExampleIDs = "";
    private boolean myUseCustomSpecRunner = false;
    private String myCustomSpecsRunnerPath = "";
    private boolean myBacktraceEnabled = false;
    @NotNull
    private PreLoadUtil.PreLoadServer myPreloadServer = PreLoadUtil.PreLoadServer.None;
    @NotNull
    private List<String> myTestScriptsPaths = Collections.emptyList();

    public RSpecRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
        this.registerLog("RUBY_RSPEC");
    }

    @Override
    protected String getSerializationId() {
        return "RSPEC_RUN_CONFIG_SETTINGS_ID";
    }

    @Override
    @NotNull
    protected SettingsEditor<RSpecRunConfiguration> createConfigurationEditor() {
        return new RSpecRunConfigurationEditor(this.getProject(), this);
    }

    @Override
    protected RubyAbstractCommandLineState createCommandLineState(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            RSpecRunConfiguration.$$$reportNull$$$0(0);
        }
        return new RSpecRunCommandLineState(this, env);
    }

    @Override
    protected void validateConfiguration() throws RuntimeConfigurationException {
        RunConfigurationUtil.inspectSDK(this);
        RunConfigurationUtil.inspectWorkingDirectory(false, this);
        switch (this.getTestType()) {
            case ALL_IN_FOLDER: {
                this.inspectSpecsFolder();
                break;
            }
            case TEST_SCRIPT: {
                this.inspectSpecScript();
                break;
            }
        }
        this.inspectConfiguredRSpecSupport();
        this.inspectSpecExecutable();
        PreLoadUtil.checkPreloadServerSupportEnabled(this.myPreloadServer);
    }

    private void inspectSpecExecutable() throws RuntimeConfigurationError {
        if (!this.shouldUseCustomSpecRunner()) {
            String homeDirUrl;
            Module module = this.getModule();
            if (module != null && RailsFacetUtil.hasRailsSupport(module) && (homeDirUrl = RailsFacetUtil.getRailsAppHomeDirUrl(module)) != null && !RSpecUtil.isRSpecRailsSupportInstalledInRailsProject(homeDirUrl)) {
                throw new RuntimeConfigurationError(RBundle.message((String)"rspec.run.configuration.test.no.spec.scrip.error.run.generator", (Object[])new Object[]{"rspec:install", "spec/spec_helper.rb", "spec/rails_helper.rb"}));
            }
            Sdk alternativeSdk = this.getAlternativeSdk();
            String specExecutablePath = RSpecUtil.determinePreferredSpecExecutablePath(module, (Sdk)(this.shouldUseAlternativeSdk() ? alternativeSdk : null), this.getRunnerGemVersion());
            if (specExecutablePath != null) {
                return;
            }
            Sdk sdk = this.getSdk();
            assert (sdk != null);
            throw new RuntimeConfigurationError(RBundle.message((String)"rspec.run.configuration.test.cannot.find.script", (Object[])new Object[]{sdk.getName()}));
        }
        this.inspectCustomRunnerScript();
    }

    private void inspectConfiguredRSpecSupport() throws RuntimeConfigurationError {
        Module module = this.getModule();
        if (module == null) {
            return;
        }
        if (RailsFacetUtil.hasRailsSupport(module)) {
            Sdk sdk = this.getSdk();
            assert (sdk != null);
            if (!RSpecUtil.isRSpecRailsSupportProbablyEnabled(module, sdk)) {
                throw new RuntimeConfigurationError(RBundle.message((String)"rspec.run.configuration.test.no.rspec.rails.support"));
            }
            return;
        }
    }

    private void inspectSpecScript() throws RuntimeConfigurationError {
        String scriptPath = this.getTestScriptPath().trim();
        String lineNumberOrExampleIDs = this.getLineNumberOrExampleIDs();
        Matcher lineNumberMatcher = LINE_NUMBER_PATTERN.matcher(lineNumberOrExampleIDs);
        Matcher exampleIDsMatcher = EXAMPLE_IDS_PATTERN.matcher(lineNumberOrExampleIDs);
        if (StringUtil.isNotEmpty((String)lineNumberOrExampleIDs) && !lineNumberMatcher.find() && !exampleIDsMatcher.find()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"rspec.run.configuration.test.invalid.line.number.example.ids"));
        }
        Matcher scriptPathMatcher = SCRIPT_PATH_WITH_LINE_NUMBER_OR_EXAMPLE_IDS_PATTERN.matcher(scriptPath);
        if (scriptPathMatcher.find()) {
            scriptPath = scriptPathMatcher.group(1);
        }
        VirtualFile script = LocalFileSystem.getInstance().findFileByPath(scriptPath);
        if (StringUtil.isEmpty((String)scriptPath)) {
            throw new RuntimeConfigurationError(RBundle.message((String)"rspec.run.configuration.test.script.not.specified"));
        }
        if (script == null || !script.exists()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"rspec.run.configuration.test.script.not.exists"));
        }
        if (script.isDirectory()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"rspec.run.configuration.test.script.is.dir"));
        }
    }

    private void inspectCustomRunnerScript() throws RuntimeConfigurationError {
        String scriptPath = this.getCustomSpecsRunnerPath().trim();
        if (StringUtil.isEmpty((String)scriptPath)) {
            throw new RuntimeConfigurationError(RBundle.message((String)"rspec.run.configuration.test.custom.runner.not.exists"));
        }
        VirtualFile script = LocalFileSystem.getInstance().findFileByPath(scriptPath);
        if (script == null || !script.exists()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"rspec.run.configuration.test.custom.runner.not.exists"));
        }
        if (script.isDirectory()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"rspec.run.configuration.test.script.is.dir"));
        }
    }

    private void inspectSpecsFolder() throws RuntimeConfigurationError {
        String folderPath = this.getTestsFolderPath().trim();
        File folder = new File(folderPath);
        if (StringUtil.isEmpty((String)folderPath)) {
            throw new RuntimeConfigurationError(RBundle.message((String)"rspec.run.configuration.test.folder.not.specified"));
        }
        if (!folder.exists()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"rspec.run.configuration.test.folder.not.exists"));
        }
        if (!folder.isDirectory()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"rspec.run.configuration.test.folder.not.dir"));
        }
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            RSpecRunConfiguration.$$$reportNull$$$0(1);
        }
        super.readExternal(element);
        RSpecRunConfigurationExternalizer.getInstance().readExternal(this, element);
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            RSpecRunConfiguration.$$$reportNull$$$0(2);
        }
        super.writeExternal(element);
        RSpecRunConfigurationExternalizer.getInstance().writeExternal(this, element);
    }

    @Override
    public String getRunnerOptions() {
        return this.mySpecArgs;
    }

    @Override
    public void setRunnerOptions(String specArgs) {
        this.mySpecArgs = StringUtil.notNullize((String)specArgs);
    }

    @Override
    public String getCustomSpecsRunnerPath() {
        return StringUtil.notNullize((String)this.myCustomSpecsRunnerPath).trim();
    }

    @Override
    public void setCustomSpecsRunnerPath(String specsRunnerPath) {
        this.myCustomSpecsRunnerPath = RSpecRunConfiguration.asSysIndependentPath(specsRunnerPath);
    }

    @Override
    public void setShouldUseCustomSpecRunner(boolean useCustomSpecRunner) {
        this.myUseCustomSpecRunner = useCustomSpecRunner;
    }

    @Override
    public boolean shouldUseCustomSpecRunner() {
        return this.myUseCustomSpecRunner;
    }

    @Override
    @NotNull
    public String getExampleNamesFilter() {
        String string = this.myExampleNameFilter;
        if (string == null) {
            RSpecRunConfiguration.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getLineNumberOrExampleIDs() {
        String string = this.myLineNumberOrExampleIDs;
        if (string == null) {
            RSpecRunConfiguration.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean getUseExampleMatches() {
        return this.myUseExampleMatches;
    }

    @Override
    public void setExampleNamesFilter(@Nullable String name) {
        this.myExampleNameFilter = StringUtil.notNullize((String)name);
    }

    @Override
    public void setLineNumberOrExampleIDs(@Nullable String lineNumberOrExampleIDs) {
        this.myLineNumberOrExampleIDs = StringUtil.notNullize((String)lineNumberOrExampleIDs);
    }

    @Override
    public void setUseExampleMatches(boolean useExampleMatches) {
        this.myUseExampleMatches = useExampleMatches;
    }

    @Override
    public boolean isBacktraceEnabled() {
        return this.myBacktraceEnabled;
    }

    @Override
    public void setBacktraceEnabled(boolean enabled) {
        this.myBacktraceEnabled = enabled;
    }

    @Override
    @NotNull
    public List<String> getTestScriptsPaths() {
        List<String> list = Collections.unmodifiableList(this.myTestScriptsPaths);
        if (list == null) {
            RSpecRunConfiguration.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    public void setTestScriptsPaths(@NotNull List<String> paths) {
        if (paths == null) {
            RSpecRunConfiguration.$$$reportNull$$$0(6);
        }
        this.myTestScriptsPaths = new ArrayList<String>(paths);
    }

    @Override
    protected String getLogTitle() {
        return RBundle.message((String)"rspec.run.configuration.log.tab.name");
    }

    @Override
    @NotNull
    public PreLoadUtil.PreLoadServer getPreloadServer() {
        PreLoadUtil.PreLoadServer preLoadServer = this.myPreloadServer;
        if (preLoadServer == null) {
            RSpecRunConfiguration.$$$reportNull$$$0(7);
        }
        return preLoadServer;
    }

    @Override
    public void setPreloadServer(@NotNull PreLoadUtil.PreLoadServer server) {
        if (server == null) {
            RSpecRunConfiguration.$$$reportNull$$$0(8);
        }
        this.myPreloadServer = server;
    }

    @Override
    public boolean isBundlerContextAllowed() {
        return RSpecRunConfiguration.isBundlerContextAllowed(this.getPreloadServer(), this.getModule());
    }

    public static void copyParams(RSpecRunConfigurationParams fromParams, RSpecRunConfigurationParams toParams) {
        AbstractTestRunConfigurationWithTestPath.copyParams(fromParams, toParams);
        toParams.setExampleNamesFilter(fromParams.getExampleNamesFilter());
        toParams.setLineNumberOrExampleIDs(fromParams.getLineNumberOrExampleIDs());
        toParams.setShouldUseCustomSpecRunner(fromParams.shouldUseCustomSpecRunner());
        toParams.setRunnerOptions(fromParams.getRunnerOptions());
        toParams.setRunnerGemVersion(fromParams.getRunnerGemVersion());
        toParams.setCustomSpecsRunnerPath(fromParams.getCustomSpecsRunnerPath());
        toParams.setPreloadServer(fromParams.getPreloadServer());
        toParams.setBacktraceEnabled(fromParams.isBacktraceEnabled());
        toParams.setTestScriptsPaths(fromParams.getTestScriptsPaths());
    }

    @Override
    @NotNull
    protected String doGetActionName() {
        String string = RBundle.message((String)"rspec.run.configuration.prefix", (Object[])new Object[]{this.getName()});
        if (string == null) {
            RSpecRunConfiguration.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public SupportedTestFramework getTestFramework() {
        SupportedTestFramework supportedTestFramework = SupportedTestFramework.RSPEC;
        if (supportedTestFramework == null) {
            RSpecRunConfiguration.$$$reportNull$$$0(10);
        }
        return supportedTestFramework;
    }

    public boolean isGUIRunnerEnabled() {
        String options = this.getRunnerOptions();
        return !RSpecRunConfiguration.containsOptionKey(options, "--format") && !RSpecRunConfiguration.containsOptionKey(options, "-f");
    }

    @Override
    @Nullable
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        SMTRunnerConsoleProperties result;
        if (executor == null) {
            RSpecRunConfiguration.$$$reportNull$$$0(11);
        }
        if ((result = super.createTestConsoleProperties(executor)) != null) {
            result.setPreservePresentableName(true);
        }
        return result;
    }

    @Override
    public void collectSettingChangesOnApply(@NotNull FusCollectSettingChangesRunConfiguration oldRunConfiguration) {
        if (oldRunConfiguration == null) {
            RSpecRunConfiguration.$$$reportNull$$$0(12);
        }
        super.collectSettingChangesOnApply(oldRunConfiguration);
        if (this.getClass() == oldRunConfiguration.getClass()) {
            RSpecRunConfiguration oldRspecConfiguration = (RSpecRunConfiguration)oldRunConfiguration;
            PreLoadUtil.PreLoadServer newPreloadServerType = this.getPreloadServer();
            PreLoadUtil.PreLoadServer oldPreloadServerType = oldRspecConfiguration.getPreloadServer();
            if (oldPreloadServerType != newPreloadServerType) {
                RubyRunConfigurationSettingChangesCollector.logPreloadServerChange(this.getType(), oldPreloadServerType, newPreloadServerType);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecRunConfiguration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExampleNamesFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineNumberOrExampleIDs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestScriptsPaths";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreloadServer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetActionName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFramework";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLineState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTestScriptsPaths";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setPreloadServer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectSettingChangesOnApply";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 7, 9, 10 -> new IllegalStateException(string);
        };
    }
}

