/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractTestRunConfigurationWithTestPath;
import org.jetbrains.plugins.ruby.testing.RubyRerunFailedTestsAction;
import org.jetbrains.plugins.ruby.testing.rspec.run.RSpecRunConfigurationType;
import org.jetbrains.plugins.ruby.testing.rspec.runConfigurations.RSpecRunConfigurationParams;

public class RSpecRerunFailedTestsAction
extends RubyRerunFailedTestsAction {
    private static final Pattern EXAMPLE_ID_PATTERN = Pattern.compile("\\[(\\d+(?::\\d+)*)]$");

    public RSpecRerunFailedTestsAction(@NotNull ComponentContainer componentContainer) {
        if (componentContainer == null) {
            RSpecRerunFailedTestsAction.$$$reportNull$$$0(0);
        }
        super(componentContainer);
    }

    @Nullable
    public AbstractRerunFailedTestsAction.MyRunProfile getRunProfile(@NotNull ExecutionEnvironment environment) {
        TestFrameworkRunningModel model;
        if (environment == null) {
            RSpecRerunFailedTestsAction.$$$reportNull$$$0(1);
        }
        if ((model = this.getModel()) == null) {
            return null;
        }
        return new RSpecRerunTestProfile((AbstractRubyRunConfiguration)model.getProperties().getConfiguration());
    }

    @Override
    protected Filter<?> getFailuresFilter() {
        return super.getFailuresFilter().and(new Filter(){

            public boolean shouldAccept(AbstractTestProxy test) {
                return test.isLeaf();
            }
        });
    }

    @Override
    @NotNull
    protected ConfigurationType getConfigurationType() {
        RSpecRunConfigurationType rSpecRunConfigurationType = RSpecRunConfigurationType.getInstance();
        if (rSpecRunConfigurationType == null) {
            RSpecRerunFailedTestsAction.$$$reportNull$$$0(2);
        }
        return rSpecRunConfigurationType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentContainer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecRerunFailedTestsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecRerunFailedTestsAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRunProfile";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private class RSpecRerunTestProfile
    extends RubyRerunFailedTestsAction.RubyRunProfile {
        RSpecRerunTestProfile(AbstractRubyRunConfiguration configuration) {
            if (configuration == null) {
                RSpecRerunTestProfile.$$$reportNull$$$0(0);
            }
            super(configuration);
        }

        @Nullable
        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
            AbstractTestRunConfigurationWithTestPath configuration;
            if (executor == null) {
                RSpecRerunTestProfile.$$$reportNull$$$0(1);
            }
            if (env == null) {
                RSpecRerunTestProfile.$$$reportNull$$$0(2);
            }
            if (!((configuration = RSpecRerunFailedTestsAction.this.getNewTestRunConfiguration()) instanceof RSpecRunConfigurationParams)) {
                return configuration.getState(executor, env);
            }
            RSpecRunConfigurationParams rspecConfiguration = (RSpecRunConfigurationParams)((Object)configuration);
            List failedTests = RSpecRerunFailedTestsAction.this.getFailedTests(configuration.getProject());
            Map<String, List<String>> pathToIds = RSpecRerunTestProfile.collectExampleIdsForPaths(failedTests, configuration.getWorkingDirectory());
            List scriptPaths = ContainerUtil.map(pathToIds.entrySet(), entry -> (String)entry.getKey() + "[" + String.join((CharSequence)",", (Iterable)entry.getValue()) + "]");
            if (rspecConfiguration.getTestType() == AbstractRubyTestsRunConfigurationParams.TestType.TEST_SCRIPT) {
                rspecConfiguration.setTestScriptPath((String)ContainerUtil.getFirstItem((List)scriptPaths));
            } else {
                rspecConfiguration.setTestScriptsPaths(scriptPaths);
                if (rspecConfiguration.getTestType() == AbstractRubyTestsRunConfigurationParams.TestType.ALL_IN_FOLDER) {
                    rspecConfiguration.setTestType(AbstractRubyTestsRunConfigurationParams.TestType.CUSTOM_SET_OF_FILES);
                }
            }
            rspecConfiguration.setExampleNamesFilter("");
            return configuration.getState(executor, env);
        }

        @NotNull
        private static Map<String, List<String>> collectExampleIdsForPaths(@NotNull List<AbstractTestProxy> tests, @NotNull String workingDirectory) {
            if (tests == null) {
                RSpecRerunTestProfile.$$$reportNull$$$0(3);
            }
            if (workingDirectory == null) {
                RSpecRerunTestProfile.$$$reportNull$$$0(4);
            }
            HashMap<String, List<String>> pathToIds = new HashMap<String, List<String>>();
            for (AbstractTestProxy proxy : tests) {
                String testId = Objects.requireNonNull((String)proxy.getUserData(SMTestProxy.NODE_ID));
                Matcher exampleIdMatcher = EXAMPLE_ID_PATTERN.matcher(testId);
                if (!exampleIdMatcher.find()) continue;
                String path = Path.of(workingDirectory, testId.substring(0, exampleIdMatcher.start())).normalize().toString();
                pathToIds.computeIfAbsent(path, __ -> new ArrayList()).add(exampleIdMatcher.group(1));
            }
            HashMap<String, List<String>> hashMap = pathToIds;
            if (hashMap == null) {
                RSpecRerunTestProfile.$$$reportNull$$$0(5);
            }
            return hashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tests";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "workingDirectory";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecRerunFailedTestsAction$RSpecRerunTestProfile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/run/RSpecRerunFailedTestsAction$RSpecRerunTestProfile";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectExampleIdsForPaths";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getState";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "collectExampleIdsForPaths";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

