/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.model.psi;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiCompletableReference;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.model.psi.RenamablePsiSymbolReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyParamDefInspectableReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyParamDefPsiSymbolReference;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RubyRSpecSharedContextIndexName;
import org.jetbrains.plugins.ruby.testing.rspec.model.impl.RSpecSharedContextSymbol;

public final class RSpecSharedContextSymbolReference
extends RubyParamDefPsiSymbolReference
implements RubyParamDefInspectableReference,
PsiCompletableReference,
RenamablePsiSymbolReference {
    public RSpecSharedContextSymbolReference(@NotNull Project project, @NotNull RCall call, @NotNull PsiElement element) {
        if (project == null) {
            RSpecSharedContextSymbolReference.$$$reportNull$$$0(0);
        }
        if (call == null) {
            RSpecSharedContextSymbolReference.$$$reportNull$$$0(1);
        }
        if (element == null) {
            RSpecSharedContextSymbolReference.$$$reportNull$$$0(2);
        }
        super(project, call, element);
    }

    @NotNull
    public Collection<LookupElement> getCompletionVariants() {
        ArrayList<LookupElementBuilder> lookupElements = new ArrayList<LookupElementBuilder>();
        for (String name : RubyRSpecSharedContextIndexName.getInstance().getAllKeys(this.myProject)) {
            ProgressManager.checkCanceled();
            TreeSet files = new TreeSet();
            RubyRSpecSharedContextIndexName.getInstance().processElements(this.myProject, this.mySearchScope, name, element -> {
                String filename = (String)ObjectUtils.doIfNotNull((Object)element.getContainingFile(), PsiFileSystemItem::getName);
                if (filename != null) {
                    files.add(filename);
                }
                return files.size() < 2;
            });
            String typeText = files.size() > 1 ? "%s, %s".formatted(ContainerUtil.getFirstItem(files), "\u2026") : (String)ContainerUtil.getOnlyItem(files);
            lookupElements.add(LookupElementBuilder.create((String)name).withIcon(RubyIcons.Rspec.RspecSharedGroup).withTypeText(typeText));
        }
        List<LookupElement> list = Collections.unmodifiableList(lookupElements);
        if (list == null) {
            RSpecSharedContextSymbolReference.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void inspectReference(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RSpecSharedContextSymbolReference.$$$reportNull$$$0(4);
        }
        if (!RubyPsiUtil.isSimpleStringOrSymbol(this.myElement) || !this.resolveReference().isEmpty()) {
            return;
        }
        String message = RBundle.message((String)"rspec.paramDef.sharedContextRef.invalid.reference");
        holder.registerProblem(this.myElement, message, ProblemHighlightType.WARNING, this.getRangeInElement(), new LocalQuickFix[0]);
    }

    public boolean resolvesTo(@NotNull Symbol target) {
        if (target == null) {
            RSpecSharedContextSymbolReference.$$$reportNull$$$0(5);
        }
        if (!(target instanceof RSpecSharedContextSymbol) || !this.getText().equals(((RSpecSharedContextSymbol)target).getName())) {
            return false;
        }
        return super.resolvesTo(target);
    }

    @Override
    @NotNull
    protected Collection<? extends Symbol> resolveReferenceImpl() {
        List<RSpecSharedContextSymbol> list = RSpecSharedContextSymbol.find(this.myProject, this.mySearchScope, this.getText()).stream().toList();
        if (list == null) {
            RSpecSharedContextSymbolReference.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public static RSpecSharedContextSymbolReference create(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RSpecSharedContextSymbolReference.$$$reportNull$$$0(7);
        }
        Project project = context.getProject();
        RCall call = context.getCall();
        RPsiElement element = context.getArgumentElement();
        String text = RubyPsiUtil.isSimpleStringOrSymbol((PsiElement)element) ? RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)element) : null;
        return !StringUtil.isEmpty((String)text) ? new RSpecSharedContextSymbolReference(project, call, (PsiElement)element) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/model/psi/RSpecSharedContextSymbolReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/model/psi/RSpecSharedContextSymbolReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionVariants";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReferenceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inspectReference";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolvesTo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6 -> new IllegalStateException(string);
        };
    }
}

