/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.codeInsight.symbols;

import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.PsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbolImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RTypedSyntheticSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RDynamicType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RSpecTypeProvider;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.symbols.RSpecContextSymbol;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.symbols.RSpecExampleGroupUtil;

public class RSpecExpectationsContextSymbol
extends RSpecContextSymbol {
    public static final Predicate<Symbol> BOOLEAN_SYMBOLS_FILTER = Symbol.Filter.byTypes((TypeSet)Types.METHODS_LIKE).and(symbol -> {
        String name = symbol.getName();
        PsiElement declaration = symbol.getPsiElement();
        return name != null && name.endsWith(SUFFIX_HAS) && !RSpecExampleGroupUtil.STATIC_MATCHERS.contains(name) && declaration != null;
    });
    private static final String PREFIX_HAS = "has_";
    private static final String PREFIX_HAVE = "have_";
    private static final String SUFFIX_HAS = "?";

    public RSpecExpectationsContextSymbol(@NotNull RContainer originalContainer, @Nullable RContainer container, @NotNull List<Symbol> implicitIncludes) {
        if (originalContainer == null) {
            RSpecExpectationsContextSymbol.$$$reportNull$$$0(0);
        }
        if (implicitIncludes == null) {
            RSpecExpectationsContextSymbol.$$$reportNull$$$0(1);
        }
        super(originalContainer, container, implicitIncludes, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public boolean processChildren(@NotNull SymbolPsiProcessor processor, @NotNull PsiElement invocationPoint) {
        if (processor == null) {
            RSpecExpectationsContextSymbol.$$$reportNull$$$0(2);
        }
        if (invocationPoint == null) {
            RSpecExpectationsContextSymbol.$$$reportNull$$$0(3);
        }
        return this.processDynamicMatchers(processor, invocationPoint);
    }

    private boolean processDynamicMatchers(@NotNull SymbolPsiProcessor processor, @NotNull PsiElement point) {
        String name;
        if (processor == null) {
            RSpecExpectationsContextSymbol.$$$reportNull$$$0(4);
        }
        if (point == null) {
            RSpecExpectationsContextSymbol.$$$reportNull$$$0(5);
        }
        if ((name = processor.getName()) != null && (RSpecExampleGroupUtil.STATIC_MATCHERS.contains(name) || !name.startsWith("be_") && !name.startsWith(PREFIX_HAVE))) {
            return true;
        }
        RCall call = RubyPsiUtil.getCoveringRCall(point);
        if (call != null && call.getPsiCommand() == point) {
            call = RubyPsiUtil.getCoveringRCall(call.getParent());
        }
        RubyCallType type = call != null ? call.getCallType() : null;
        RType receiverType = null;
        if (type != null && RSpecUtil.isShouldCall(type)) {
            receiverType = RSpecExpectationsContextSymbol.getShouldReceiverType(call);
        } else if (call != null) {
            receiverType = RSpecExpectationsContextSymbol.getExpectReceiverType(call);
        }
        if (receiverType != null) {
            if (receiverType.isTyped()) {
                for (Symbol symbol : receiverType.getMembers(BOOLEAN_SYMBOLS_FILTER, point)) {
                    String[] matcherNames;
                    String symbolName = symbol.getName();
                    assert (symbolName != null);
                    PsiElement element = symbol.getPsiElement();
                    if (element == null) continue;
                    if (!this.processMatcherHas(processor, symbolName, element)) {
                        return false;
                    }
                    String suffix = symbolName.substring(0, symbolName.length() - 1);
                    for (String matcherName : matcherNames = new String[]{"be_" + suffix, "be_an_" + suffix, PREFIX_HAVE + suffix}) {
                        PsiElementSymbol<PsiElement> matcherSymbol = new PsiElementSymbol<PsiElement>(element, matcherName, Type.INSTANCE_METHOD, (Symbol)this);
                        if (processor.process(matcherSymbol)) continue;
                        return false;
                    }
                }
            } else if (name != null) {
                Optional<RMethodSymbolImpl> missingMethod;
                if (!processor.process((Symbol)new RTypedSyntheticSymbol(this.getProject(), name, Type.INSTANCE_METHOD, (Symbol)this, (RType)REmptyType.INSTANCE, null))) {
                    return false;
                }
                RClass exampleGroupClass = (RClass)this.getPsiElement();
                if (exampleGroupClass != null && (missingMethod = exampleGroupClass.getMethods().stream().filter(m -> m.getName().equals("method_missing")).map(m -> new RMethodSymbolImpl((RMethod)m, (Symbol)this)).filter(m -> ContextImpl.INSTANCE_PRIVATE.accept((Symbol)m)).findFirst()).isPresent()) {
                    RMethodSymbolImpl methodSymbol = missingMethod.get();
                    RDynamicType dynamicType = new RDynamicType((Symbol)methodSymbol);
                    RTypedSyntheticSymbol symbol = new RTypedSyntheticSymbol(this.getProject(), name, Type.INSTANCE_METHOD, (Symbol)this, (RType)dynamicType, null, (PsiElement)methodSymbol.getPsiElement());
                    if (!processor.process((Symbol)symbol)) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean processMatcherHas(@NotNull SymbolPsiProcessor processor, @NotNull String symbolName, @NotNull PsiElement element) {
        String matcherName;
        PsiElementSymbol<PsiElement> matcherSymbol;
        if (processor == null) {
            RSpecExpectationsContextSymbol.$$$reportNull$$$0(6);
        }
        if (symbolName == null) {
            RSpecExpectationsContextSymbol.$$$reportNull$$$0(7);
        }
        if (element == null) {
            RSpecExpectationsContextSymbol.$$$reportNull$$$0(8);
        }
        return !symbolName.startsWith(PREFIX_HAS) || !symbolName.endsWith(SUFFIX_HAS) || processor.process(matcherSymbol = new PsiElementSymbol<PsiElement>(element, matcherName = PREFIX_HAVE + symbolName.substring(PREFIX_HAS.length(), symbolName.length() - 1), Type.INSTANCE_METHOD, (Symbol)this));
    }

    @NotNull
    private static RType getShouldReceiverType(@NotNull RCall call) {
        RPsiElement subjectCall;
        if (call == null) {
            RSpecExpectationsContextSymbol.$$$reportNull$$$0(9);
        }
        PsiElement command = call.getPsiCommand();
        REmptyType result = REmptyType.INSTANCE;
        if (command instanceof RReference) {
            RPsiElement receiver = ((RReference)command).getReceiver();
            result = RTypeUtil.getType((PsiElement)receiver);
        } else if (command instanceof RIdentifier && (subjectCall = RSpecExampleGroupUtil.findSubjectCall(call)) != null) {
            result = RSpecTypeProvider.getLetSubjectType(subjectCall);
        }
        REmptyType rEmptyType = result;
        if (rEmptyType == null) {
            RSpecExpectationsContextSymbol.$$$reportNull$$$0(10);
        }
        return rEmptyType;
    }

    @NotNull
    private static RType getExpectReceiverType(@NotNull RCall call) {
        if (call == null) {
            RSpecExpectationsContextSymbol.$$$reportNull$$$0(11);
        }
        PsiElement receiver = call.getPsiCommand();
        PsiElement subject = null;
        while (receiver instanceof RDotReference || receiver instanceof RCall) {
            if (receiver instanceof RCall) {
                List arguments = ((RCall)receiver).getArguments();
                if (arguments.size() == 1) {
                    subject = (PsiElement)arguments.get(0);
                }
                receiver = ((RCall)receiver).getPsiCommand();
                continue;
            }
            receiver = ((RDotReference)receiver).getReceiver();
        }
        if (receiver != null && receiver.getText().equals("expect") && subject instanceof RExpression) {
            RType rType = RTypeUtil.getType(subject);
            if (rType == null) {
                RSpecExpectationsContextSymbol.$$$reportNull$$$0(12);
            }
            return rType;
        }
        REmptyType rEmptyType = REmptyType.INSTANCE;
        if (rEmptyType == null) {
            RSpecExpectationsContextSymbol.$$$reportNull$$$0(13);
        }
        return rEmptyType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalContainer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitIncludes";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocationPoint";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/codeInsight/symbols/RSpecExpectationsContextSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/codeInsight/symbols/RSpecExpectationsContextSymbol";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getShouldReceiverType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectReceiverType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDynamicMatchers";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processMatcherHas";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getShouldReceiverType";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getExpectReceiverType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 12, 13 -> new IllegalStateException(string);
        };
    }
}

