/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.codeInsight.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsClassModuleSymbol;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RSpecSymbolDefiningCallType;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RubyRSpecSharedContextIndexName;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.symbols.RSpecContextSymbol;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.symbols.RSpecExpectationsContextSymbol;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public class RSpecExampleGroupContextSymbol
extends RSpecContextSymbol {
    @Nullable
    private final String myGroupType;
    @NotNull
    private final RSpecExpectationsContextSymbol myExpectationsContextSymbol;

    public RSpecExampleGroupContextSymbol(@NotNull RContainer originalContainer, @Nullable String groupType, @Nullable RContainer container, @NotNull List<Symbol> implicitIncludes, @NotNull List<Symbol> implicitExctends, @NotNull List<Symbol> implicitSuperclasses) {
        if (originalContainer == null) {
            RSpecExampleGroupContextSymbol.$$$reportNull$$$0(0);
        }
        if (implicitIncludes == null) {
            RSpecExampleGroupContextSymbol.$$$reportNull$$$0(1);
        }
        if (implicitExctends == null) {
            RSpecExampleGroupContextSymbol.$$$reportNull$$$0(2);
        }
        if (implicitSuperclasses == null) {
            RSpecExampleGroupContextSymbol.$$$reportNull$$$0(3);
        }
        super(originalContainer, container, implicitIncludes, implicitExctends, implicitSuperclasses);
        this.myGroupType = groupType;
        this.myExpectationsContextSymbol = new RSpecExpectationsContextSymbol(originalContainer, container, Collections.emptyList());
    }

    public boolean isHelperGroup() {
        return "helper".equals(this.myGroupType);
    }

    @Override
    public boolean processChildren(SymbolPsiProcessor processor, PsiElement invocationPoint) {
        RailsApp app;
        if (invocationPoint != null && !this.processRSpecSymbolDefiningCallType(processor, invocationPoint)) {
            return false;
        }
        if (!super.processChildren(processor, invocationPoint)) {
            return false;
        }
        RailsApp railsApp = app = invocationPoint != null ? RailsApp.fromPsiElement(invocationPoint) : null;
        if (app != null && !RailsClassModuleSymbol.processNamedRoutes((Processor<? super Symbol>)processor, (Symbol)this, app)) {
            return false;
        }
        if (invocationPoint != null && !this.myExpectationsContextSymbol.processChildren(processor, invocationPoint)) {
            return false;
        }
        return invocationPoint == null || this.processIncludedSharedGroupSymbols(processor, invocationPoint);
    }

    private boolean processRSpecSymbolDefiningCallType(SymbolPsiProcessor processor, PsiElement invocationPoint) {
        RBlockCall rBlockCall = (RBlockCall)PsiTreeUtil.getParentOfType((PsiElement)invocationPoint, RBlockCall.class);
        while (rBlockCall != null) {
            if (RSpecUtil.isExampleGroupCall((RPossibleCall)rBlockCall) || RSpecUtil.isSharedExampleGroupCall((RPossibleCall)rBlockCall)) {
                List calls = ((StreamEx)StreamEx.ofReversed((List)rBlockCall.getBlock().getCompoundStatement().getStatements()).select(RPossibleCall.class).filter(it -> it.getCallType() instanceof RSpecSymbolDefiningCallType)).toList();
                for (RPossibleCall call : calls) {
                    RPossibleCall realCall;
                    RPossibleCall rPossibleCall = realCall = call instanceof RBlockCall ? ((RBlockCall)call).getCall() : call;
                    if (realCall instanceof RCall && !call.getCallType().process((Processor)processor, (Symbol)this, (RCall)realCall, invocationPoint)) {
                        return false;
                    }
                    if (!(realCall instanceof RIdentifier) || call.getCallType().processRIdentifier((Processor)processor, (Symbol)this, (RIdentifier)realCall, invocationPoint)) continue;
                    return false;
                }
            }
            rBlockCall = (RBlockCall)PsiTreeUtil.getParentOfType((PsiElement)rBlockCall, RBlockCall.class);
        }
        return true;
    }

    private boolean processIncludedSharedGroupSymbols(@NotNull SymbolPsiProcessor processor, @NotNull PsiElement invocationPoint) {
        if (processor == null) {
            RSpecExampleGroupContextSymbol.$$$reportNull$$$0(4);
        }
        if (invocationPoint == null) {
            RSpecExampleGroupContextSymbol.$$$reportNull$$$0(5);
        }
        List<RCall> sharedGroupDefiningCalls = RSpecExampleGroupContextSymbol.getIncludedSharedGroupDefiningCalls(invocationPoint);
        for (RCall call : sharedGroupDefiningCalls) {
            List<Object> definingCalls;
            RBlockCallBase contextBlock = (RBlockCallBase)ObjectUtils.tryCast((Object)PsiTreeUtil.getStubOrPsiParent((PsiElement)call), RBlockCallBase.class);
            if (contextBlock == null || ContainerUtil.process(definingCalls = contextBlock.getStub() != null ? Stream.ofNullable((RCodeBlock)PsiTreeUtil.getStubChildOfType((PsiElement)contextBlock, RCodeBlock.class)).flatMap(it -> PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)it, RBlockCall.class).stream()).filter(RSpecUtil::isProbablyInDefiningCallScope).flatMap(it -> Stream.ofNullable((RCall)PsiTreeUtil.getStubChildOfType((PsiElement)it, RCall.class))).toList() : contextBlock.getBlock().getCompoundStatement().getStatements().stream().mapMulti(StreamUtil.select(RBlockCall.class, (Class[])new Class[0])).filter(RSpecUtil::isProbablyInDefiningCallScope).map(RPossibleCall::getPsiCommand).filter(Objects::nonNull).map(RCallNavigator::getByCommand).filter(Objects::nonNull).collect(Collectors.toList()), definingCall -> definingCall.getCallType().process((Processor)processor, (Symbol)this, definingCall, invocationPoint))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<RCall> getIncludedSharedGroupDefiningCalls(@NotNull PsiElement invocationPoint) {
        if (invocationPoint == null) {
            RSpecExampleGroupContextSymbol.$$$reportNull$$$0(6);
        }
        ArrayList<RCall> sharedContextCalls = new ArrayList<RCall>();
        Project project = invocationPoint.getProject();
        GlobalSearchScope scope = invocationPoint.getResolveScope();
        RBlockCall exampleGroupCall = (RBlockCall)PsiTreeUtil.getParentOfType((PsiElement)invocationPoint, RBlockCall.class);
        while (exampleGroupCall != null) {
            if (RSpecUtil.isExampleGroupCall((RPossibleCall)exampleGroupCall) || RSpecUtil.isSharedExampleGroupCall((RPossibleCall)exampleGroupCall)) {
                sharedContextCalls.addAll(ContainerUtil.reverse(exampleGroupCall.getBlock().getCompoundStatement().getStatements().stream().mapMulti(StreamUtil.select(RCall.class, (Class[])new Class[0])).filter(RSpecUtil::isIncludedSharedGroupRef).map(call -> ((RPsiElement)call.getArguments().get(0)).getName()).filter(Objects::nonNull).flatMap(sharedGroupName -> RubyRSpecSharedContextIndexName.getInstance().getElements(project, (SearchScope)scope, (String)sharedGroupName).stream()).collect(Collectors.toList())));
            }
            exampleGroupCall = (RBlockCall)PsiTreeUtil.getParentOfType((PsiElement)exampleGroupCall, RBlockCall.class);
        }
        ArrayList<RCall> arrayList = sharedContextCalls;
        if (arrayList == null) {
            RSpecExampleGroupContextSymbol.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalContainer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitIncludes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitExctends";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitSuperclasses";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocationPoint";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/codeInsight/symbols/RSpecExampleGroupContextSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/codeInsight/symbols/RSpecExampleGroupContextSymbol";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedSharedGroupDefiningCalls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processIncludedSharedGroupSymbols";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIncludedSharedGroupDefiningCalls";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

