/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.codeInsight;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.ArgumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbolWithMixins;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RubyTypeProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RModuleType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RSymbolTypeImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RNameUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RSpecSymbolDefiningCallType;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RSpecSymbolProvider;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.symbols.RSpecExampleGroupContextSymbol;

public final class RSpecTypeProvider
implements RubyTypeProvider {
    private static final String RSPEC_1x_HELPER_OBJECT = "Spec::Rails::Example::HelperExampleGroup::HelperObject";
    private static final String RSPEC_2x_HELPER_OBJECT = "ActionView::Base";

    public RType createTypeBySymbol(@NotNull Symbol symbol, @NotNull List<RType> typeArguments) {
        PsiElement subjectLetPsiElement;
        if (symbol == null) {
            RSpecTypeProvider.$$$reportNull$$$0(0);
        }
        if (typeArguments == null) {
            RSpecTypeProvider.$$$reportNull$$$0(1);
        }
        if (symbol instanceof RSpecSymbolDefiningCallType.RSpecLetSubjectSymbol && (subjectLetPsiElement = symbol.getPsiElement()) instanceof ArgumentFakePsiElement) {
            return RSpecTypeProvider.getLetSubjectType((RPsiElement)((ArgumentFakePsiElement)subjectLetPsiElement).getCall());
        }
        return null;
    }

    public RType createTypeByRExpression(@NotNull RExpression expression) {
        if (expression == null) {
            RSpecTypeProvider.$$$reportNull$$$0(2);
        }
        if (!(expression instanceof RIdentifier)) {
            return null;
        }
        Project project = expression.getProject();
        if (((RIdentifier)expression).isLocalVariable()) {
            return null;
        }
        String expressionName = expression.getName();
        if ("helper".equals(expressionName)) {
            return RSpecTypeProvider.processHelperCall(expression, project);
        }
        if (RSpecUtil.SUBJECT_CALL_NAMES.contains(expressionName)) {
            return RSpecTypeProvider.processSubjectCall(expression, project);
        }
        if ("described_class".equals(expressionName)) {
            return RSpecTypeProvider.processDescribedClassCall(expression);
        }
        return null;
    }

    @Nullable
    private static RType processDescribedClassCall(@NotNull RExpression expression) {
        if (expression == null) {
            RSpecTypeProvider.$$$reportNull$$$0(3);
        }
        RBlockCall describeBlock = RSpecUtil.getCoveringExampleGroupScope((PsiElement)expression);
        while (describeBlock != null) {
            RExpression argument;
            List arguments = describeBlock.getArguments();
            RExpression rExpression = argument = !arguments.isEmpty() ? RubyPsiUtil.getCoveringExpression((PsiElement)arguments.get(0)) : null;
            if (argument == null) {
                return null;
            }
            RType argumentType = argument.getType();
            if (argumentType instanceof RModuleType) {
                return argumentType;
            }
            describeBlock = RSpecUtil.getCoveringExampleGroupScope((PsiElement)describeBlock);
        }
        return null;
    }

    @Nullable
    private static RType processHelperCall(@NotNull RExpression expression, @NotNull Project project) {
        boolean rSpec20SupportLoaded;
        if (expression == null) {
            RSpecTypeProvider.$$$reportNull$$$0(4);
        }
        if (project == null) {
            RSpecTypeProvider.$$$reportNull$$$0(5);
        }
        if (!RSpecSymbolProvider.shouldUseRSpecSupportFor((RPsiElement)expression)) {
            return null;
        }
        Symbol scope = SymbolUtil.getScopeContextWithCaching((PsiElement)expression);
        if (scope != null && RSpecTypeProvider.isHelperRSpecGroupScope(scope, rSpec20SupportLoaded = RSpecUtil.isRSpec20SupportLoaded(project))) {
            PsiElement helperObjectClass;
            String helper_object_fqn = rSpec20SupportLoaded ? RSPEC_2x_HELPER_OBJECT : RSPEC_1x_HELPER_OBJECT;
            Symbol helperObject = SymbolUtil.findConstantByFQN(project, Type.CLASS, helper_object_fqn, null);
            PsiElement psiElement = helperObjectClass = helperObject != null ? helperObject.getPsiElement() : null;
            if (helperObjectClass == null) {
                return REmptyType.INSTANCE;
            }
            ArrayList<Symbol> modulesToInclude = new ArrayList<Symbol>();
            RBlockCall exampleBlock = RSpecUtil.getSimpleCoveringExampleOrBeforeAfterScope((PsiElement)expression);
            RBlockCall exampleGroup = exampleBlock != null ? RSpecUtil.getSimpleCoveringExampleGroupScope((PsiElement)exampleBlock) : RSpecUtil.getSimpleCoveringExampleGroupScope((PsiElement)expression);
            if (exampleGroup == null) {
                return REmptyType.INSTANCE;
            }
            String helperModuleFqn = RSpecSymbolProvider.getHelperSpecifiedByHelperNameCall(exampleGroup);
            if (helperModuleFqn != null) {
                FQN moduleFqnPath = FQN.Builder.fromString((String)helperModuleFqn);
                Symbol helperModule = SymbolUtil.findConstantByFQN(project, Type.MODULE, moduleFqnPath, null);
                if (helperModule != null) {
                    modulesToInclude.add(helperModule);
                }
            } else {
                Symbol helperModuleSymbol;
                String moduleName = RSpecSymbolProvider.findGroupWithExplicitlyModuleLikeName(exampleGroup);
                if (moduleName != null && (helperModuleSymbol = SymbolUtil.findConstantByFQN(project, Type.MODULE, moduleName, null)) != null) {
                    modulesToInclude.add(helperModuleSymbol);
                }
            }
            ClassModuleSymbolWithMixins typeSymbol = new ClassModuleSymbolWithMixins((RContainer)((RClass)helperObjectClass), helperObject.getParentSymbol(), modulesToInclude, Collections.emptyList(), Collections.emptyList());
            return new RSymbolTypeImpl((Symbol)typeSymbol);
        }
        return null;
    }

    @Nullable
    private static RType processSubjectCall(@NotNull RExpression expression, @NotNull Project project) {
        RBlockCall exampleBlock;
        if (expression == null) {
            RSpecTypeProvider.$$$reportNull$$$0(6);
        }
        if (project == null) {
            RSpecTypeProvider.$$$reportNull$$$0(7);
        }
        if ((exampleBlock = RSpecUtil.getSimpleCoveringExampleOrBeforeAfterScope((PsiElement)expression)) != null) {
            Symbol subject;
            List arguments;
            RPsiElement first;
            RPossibleCall command;
            RBlockCall exampleGroupParent;
            RBlockCall exampleGroup = RSpecUtil.getSimpleCoveringExampleGroupScope((PsiElement)exampleBlock);
            RBlockCall rBlockCall = exampleGroupParent = exampleGroup != null ? RSpecUtil.getSimpleCoveringExampleGroupScope((PsiElement)exampleGroup) : null;
            while (exampleGroupParent != null) {
                exampleGroup = exampleGroupParent;
                exampleGroupParent = RSpecUtil.getSimpleCoveringExampleGroupScope((PsiElement)exampleGroup);
            }
            if (exampleGroup != null && (command = exampleGroup.getCall()) instanceof RCall && ((first = (RPsiElement)ContainerUtil.getFirstItem((List)(arguments = command.getArguments()))) instanceof RConstant || first instanceof RColonReference || first instanceof RTopConstReference) && (subject = SymbolUtil.findConstantByFQN(project, Type.CLASS, RNameUtilCore.getPath((PsiElement)first), (PsiElement)expression)) != null) {
                return new RSymbolTypeImpl(subject);
            }
        }
        return null;
    }

    private static boolean isHelperRSpecGroupScope(Symbol scope, boolean rSpec20SupportLoaded) {
        String scopeName = scope.getName();
        if (rSpec20SupportLoaded) {
            if ("ExampleGroup".equals(scopeName) && scope instanceof RSpecExampleGroupContextSymbol) {
                return ((RSpecExampleGroupContextSymbol)scope).isHelperGroup();
            }
            return false;
        }
        return "HelperExampleGroup".equals(scopeName);
    }

    public static RType getLetSubjectType(RPsiElement call) {
        RBlockCall blockCall = RBlockCallNavigator.getByCall((RPsiElement)call);
        return blockCall != null ? blockCall.getBlock().getCompoundStatement().getType() : REmptyType.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/codeInsight/RSpecTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeBySymbol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeByRExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processDescribedClassCall";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processHelperCall";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processSubjectCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

