/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.codeInsight;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.RubySymbolProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.PsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbolWithMixins;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyDynamicMethodsDeclarationsIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecCucumberUtil;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecExpectationsUtil;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RSpecContextSymbolProvider;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RSpecImplicitRequiresProvider;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RSpecMockingUtil;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.symbols.RSpecContextSymbol;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.symbols.RSpecExampleGroupContextSymbol;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.symbols.RSpecExampleGroupUtil;
import org.jetbrains.plugins.ruby.testing.testunit.RTestUnitUtil;

public final class RSpecSymbolProvider
implements RubySymbolProvider {
    private static final Logger LOG = Logger.getInstance(RSpecSymbolProvider.class);
    private static final String PREFIX_RR = "rr_";
    public static final FQN RSPEC_1x_EXAMPLE_METHODS_MODULE_FQN = FQN.of((String)"Spec::Example::ExampleMethods");
    public static final FQN RSPEC_1x_EXAMPLE_GROUP_METHODS_MODULE_FQN = FQN.of((String)"Spec::Example::ExampleGroupMethods");
    public static final FQN DEFAULT_RSPEC_EXAMPLE_GROUP_CLASS_FQN = FQN.of((String)"RSpec::Core::ExampleGroup");
    private static final String DEFAULT_TUNIT_RSPEC_EXAMPLE_GROUP_CLASS_FQN = "Test::Unit::TestCase";
    public static final FQN RSPEC_1x_MATCHERS_MODULE_FQN = FQN.of((String)"Spec::Matchers");
    public static final FQN RSPEC_2x_MATCHERS_MODULE_FQN = FQN.of((String)"RSpec::Matchers");
    public static final String DEFAULT_RAILS_RSPEC_1X_EXAMPLE_GROUP_CLASS_FQN = "ActiveSupport::TestCase";
    public static final String RSPEC_2x_EXAMPLE_GROUP = "ExampleGroup";
    private static final String RR_ARGS_MATCHERS_METHODS_FQN = "RR::Adapters::RRMethods";
    public static final String RSPEC_MOCKING_FR_METHODS_FQN = "RSpec::Mocks::ExampleMethods";
    public static final FQN RSPEC_1x_MOCK_FRAMEWORK_ADAPTER_FQN = FQN.of((String)"Spec::Adapters::MockFramework");
    public static final FQN RSPEC_2x_MOCK_FRAMEWORK_ADAPTER_FQN = FQN.of((String)"RSpec::Core::MockFrameworkAdapter");
    public static final FQN RSPEC_MODULE_SINGLETON = RObjectClass.makeSingletonClassFQN((FQN)FQN.of((String)"RSpec"));

    @Override
    public ContextImpl getAccessContext(@NotNull PsiElement element) {
        RPsiElement rPsiElement;
        if (element == null) {
            RSpecSymbolProvider.$$$reportNull$$$0(0);
        }
        if ((rPsiElement = RubyPsiUtilCore.getCoveringRPsiElement((PsiElement)element)) == null) {
            return null;
        }
        if (!RSpecSymbolProvider.shouldUseRSpecSupportFor(rPsiElement)) {
            return null;
        }
        if (RSpecUtil.getSimpleCoveringExampleOrBeforeAfterScope(element) != null) {
            return ContextImpl.INSTANCE_PRIVATE;
        }
        RBlockCall topmostExampleGroupScope = RSpecUtil.getTopmostExampleGroupScope(element);
        if (topmostExampleGroupScope != null) {
            return ContextImpl.CLASS_PRIVATE;
        }
        RBlockCall exampleGroupScope = RSpecUtil.getSimpleCoveringExampleGroupScope(element);
        if (exampleGroupScope == null) {
            return null;
        }
        RMethod method = RubyPsiUtil.getContainingRMethod(element);
        if (method != null && !PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)exampleGroupScope, (boolean)false)) {
            return null;
        }
        RElementWithFQN contextContainer = SymbolUtil.getContextContainer(element);
        return PsiTreeUtil.isAncestor((PsiElement)contextContainer, (PsiElement)exampleGroupScope, (boolean)false) ? ContextImpl.CLASS_PRIVATE : null;
    }

    @Override
    public Symbol createSymbolByContainer(@NotNull RContainer container, @NotNull FQN fqnPath, @Nullable Symbol parent) {
        String mocksFqn;
        Symbol mocks;
        Module module;
        if (container == null) {
            RSpecSymbolProvider.$$$reportNull$$$0(1);
        }
        if (fqnPath == null) {
            RSpecSymbolProvider.$$$reportNull$$$0(2);
        }
        if (!(container instanceof RClass) && !(container instanceof RModule)) {
            return null;
        }
        Project project = container.getProject();
        String fqn = fqnPath.getFullPath();
        if ("ActionController::TestCase".equals(fqn)) {
            Symbol exampleMethodsModule;
            ArrayList<Symbol> implicitIncludes = new ArrayList<Symbol>(3);
            Symbol matchersModule = SymbolUtil.findConstantByFQN(project, Type.MODULE, RSPEC_1x_MATCHERS_MODULE_FQN, null);
            if (matchersModule != null) {
                implicitIncludes.add(matchersModule);
            }
            if ((exampleMethodsModule = SymbolUtil.findConstantByFQN(project, Type.MODULE, RSPEC_1x_EXAMPLE_METHODS_MODULE_FQN, null)) != null) {
                implicitIncludes.add(exampleMethodsModule);
            }
            ArrayList<Symbol> implicitExtends = new ArrayList<Symbol>(2);
            Symbol exampleGroupMethodsModule = SymbolUtil.findConstantByFQN(project, Type.MODULE, RSPEC_1x_EXAMPLE_GROUP_METHODS_MODULE_FQN, null);
            if (exampleGroupMethodsModule != null) {
                implicitExtends.add(exampleGroupMethodsModule);
            }
            return new ClassModuleSymbolWithMixins(container, parent, !implicitIncludes.isEmpty() ? implicitIncludes : null, !implicitExtends.isEmpty() ? implicitExtends : null, null);
        }
        if (RSPEC_1x_EXAMPLE_METHODS_MODULE_FQN.equals(fqnPath)) {
            Symbol mock = SymbolUtil.findConstantByFQN(project, Type.MODULE, RSPEC_1x_MOCK_FRAMEWORK_ADAPTER_FQN, null);
            if (mock != null) {
                return new ClassModuleSymbolWithMixins(container, parent, Collections.singletonList(mock), null, null);
            }
        } else if (("Object".equals(fqn) || "Class".equals(fqn)) && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)container.getContainingFile())) != null && RSpecMockingUtil.isRSpecMockingFrUsed(module) && (mocks = SymbolUtil.findConstantByFQN(project, Type.MODULE, FQN.Builder.fromString((String)(mocksFqn = "Object".equals(fqn) ? "RSpec::Mocks::Methods" : "RSpec::Mocks::AnyInstance")), null)) != null) {
            return new ClassModuleSymbolWithMixins(container, parent, Collections.singletonList(mocks), null, null);
        }
        return null;
    }

    @Override
    public Symbol getSymbolScope(@NotNull PsiElement element) {
        RPsiElement rPsiElement;
        if (element == null) {
            RSpecSymbolProvider.$$$reportNull$$$0(3);
        }
        if ((rPsiElement = RubyPsiUtilCore.getCoveringRPsiElement((PsiElement)element)) == null) {
            return null;
        }
        if (!RSpecSymbolProvider.shouldUseRSpecSupportFor(rPsiElement)) {
            return null;
        }
        RElementWithFQN contextContainer = SymbolUtil.getContextContainer(element);
        RBlockCall exampleBlock = RSpecUtil.getSimpleCoveringExampleOrBeforeAfterScope(element);
        if (exampleBlock != null && PsiTreeUtil.isAncestor((PsiElement)contextContainer, (PsiElement)exampleBlock, (boolean)false)) {
            RBlockCall coveringExampleGroup = RSpecUtil.getSimpleCoveringExampleGroupScope((PsiElement)exampleBlock);
            RSpecExampleGroupContextSymbol exampleGroupContextSymbol = RSpecSymbolProvider.findCorrespondingExampleGroup(coveringExampleGroup, rPsiElement);
            if (exampleGroupContextSymbol != null) {
                for (RSpecContextSymbolProvider provider : (RSpecContextSymbolProvider[])RSpecContextSymbolProvider.EP_NAME.getExtensions()) {
                    RSpecContextSymbol contextSymbol = provider.getRSpecContextSymbol((PsiElement)rPsiElement, exampleGroupContextSymbol);
                    if (contextSymbol == null) continue;
                    return contextSymbol;
                }
            }
            return exampleGroupContextSymbol;
        }
        RBlockCall exampleGroupBlock = RSpecUtil.getSimpleCoveringExampleGroupScope(element);
        if (exampleGroupBlock != null && PsiTreeUtil.isAncestor((PsiElement)contextContainer, (PsiElement)exampleGroupBlock, (boolean)false)) {
            return RSpecSymbolProvider.findCorrespondingExampleGroup(exampleGroupBlock, rPsiElement);
        }
        RBlockCall cucumberCodeBlock = RSpecCucumberUtil.getSimpleCoveringScopeForAssertion(element);
        if (cucumberCodeBlock != null && PsiTreeUtil.isAncestor((PsiElement)contextContainer, (PsiElement)cucumberCodeBlock, (boolean)false)) {
            return RSpecSymbolProvider.getRSpecCucumberContextSymbol(cucumberCodeBlock, rPsiElement);
        }
        return null;
    }

    @Nullable
    private static Pair<RBlockCall, String> findGroupWithExplicitlySpecifiedType(@Nullable RBlockCall exampleBlock) {
        if (exampleBlock == null) {
            return null;
        }
        Ref typeValueRef = new Ref();
        RBlockCall currentGroup = exampleBlock;
        while (currentGroup != null) {
            if (RSpecSymbolProvider.isGroupTypeSpecified(currentGroup, (Ref<String>)typeValueRef)) {
                return Pair.create((Object)currentGroup, (Object)((String)typeValueRef.get()));
            }
            currentGroup = RSpecUtil.getSimpleCoveringExampleGroupScope((PsiElement)currentGroup);
        }
        return null;
    }

    @Nullable
    public static String findGroupWithExplicitlyModuleLikeName(@Nullable RBlockCall exampleBlock) {
        if (exampleBlock == null) {
            return null;
        }
        RBlockCall currentGroup = exampleBlock;
        while (currentGroup != null) {
            RPossibleCall exampleGroupCall = currentGroup.getCall();
            if (exampleGroupCall instanceof RCall) {
                RPsiElement groupName;
                List argsList = exampleGroupCall.getArguments();
                RPsiElement rPsiElement = groupName = !argsList.isEmpty() ? (RPsiElement)argsList.get(0) : null;
                if (groupName instanceof RConstant) {
                    return groupName.getText();
                }
            }
            currentGroup = RSpecUtil.getSimpleCoveringExampleGroupScope((PsiElement)currentGroup);
        }
        return null;
    }

    @Override
    public boolean processDynamicSymbols(final @NotNull Symbol symbol, @Nullable RPsiElement element, @NotNull FQN fqn, final @NotNull SymbolPsiProcessor processor, final @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            RSpecSymbolProvider.$$$reportNull$$$0(4);
        }
        if (fqn == null) {
            RSpecSymbolProvider.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            RSpecSymbolProvider.$$$reportNull$$$0(6);
        }
        Project project = symbol.getProject();
        if (FQN.same((FQN)fqn, (String)RR_ARGS_MATCHERS_METHODS_FQN)) {
            Symbol matchersMethods = SymbolUtil.findConstantByFQN(project, Type.MODULE, FQN.Builder.fromString((String)RR_ARGS_MATCHERS_METHODS_FQN), null);
            if (matchersMethods != null) {
                String name = null;
                if (processor.getName() != null) {
                    if (!processor.getName().startsWith(PREFIX_RR)) {
                        return true;
                    }
                    name = processor.getName().substring(PREFIX_RR.length());
                }
                final String finalName = name;
                SymbolProcessor symbolProcessor = new SymbolProcessor(){

                    @Override
                    public String getName() {
                        return finalName;
                    }

                    @Override
                    @Nullable
                    public PsiElement getInvocationPoint() {
                        return invocationPoint;
                    }

                    @Override
                    public boolean process(@NotNull Symbol method) {
                        if (method == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (!Types.METHODS.contains(method.getType())) {
                            return true;
                        }
                        PsiElement psiElement = method.getPsiElement();
                        assert (psiElement != null);
                        return processor.process(new PsiElementSymbol<PsiElement>(psiElement, RSpecSymbolProvider.PREFIX_RR + method.getName(), Type.INSTANCE_METHOD, symbol));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/ruby/testing/rspec/codeInsight/RSpecSymbolProvider$1", "process"));
                    }
                };
                SymbolHierarchy.processSymbolChildren(symbol, symbolProcessor);
            }
        } else if (symbol instanceof ClassModuleSymbol && "Matchers".equals(symbol.getName())) {
            GlobalSearchScope scope = invocationPoint != null ? invocationPoint.getResolveScope() : GlobalSearchScope.allScope((Project)project);
            Collection dynamicRegistrations = (Collection)ReadAction.compute(() -> RubyDynamicMethodsDeclarationsIndex.getInstance().getElements(project, (SearchScope)scope, "Matchers"));
            for (RPsiElement declaration : dynamicRegistrations) {
                if (declaration instanceof RCall) {
                    RCall declarationCall = (RCall)declaration;
                    RubyCallType callType = declarationCall.getCallType();
                    if (callType.process((Processor)processor, symbol, declarationCall, invocationPoint)) continue;
                    return false;
                }
                LOG.warn("Unexpected dynamic method declaration: " + PsiElement.class.getName() + ". Content:\n" + declaration.getText());
            }
        } else if (fqn.equals(RSPEC_MODULE_SINGLETON) && invocationPoint instanceof RDotReference) {
            Symbol exampleGroup;
            RDotReference rPsiElement = (RDotReference)invocationPoint;
            RBlockCall topmostExampleGroupBlock = RSpecUtil.getTopmostExampleGroupScope(invocationPoint);
            if (topmostExampleGroupBlock != null && (exampleGroup = SymbolUtil.getSymbolRepresentingContext((Symbol)RSpecSymbolProvider.findCorrespondingExampleGroup(topmostExampleGroupBlock, (RPsiElement)rPsiElement), ContextImpl.getContext(invocationPoint))) != null) {
                return exampleGroup.processChildren(processor, invocationPoint);
            }
        }
        return true;
    }

    public static boolean isGroupTypeSpecified(@NotNull RBlockCall coveringExampleGroup, Ref<String> typeValueRef) {
        RPossibleCall possibleCall;
        if (coveringExampleGroup == null) {
            RSpecSymbolProvider.$$$reportNull$$$0(7);
        }
        if ((possibleCall = coveringExampleGroup.getCall()) instanceof RCall) {
            RCall call = (RCall)possibleCall;
            List args = call.getArguments();
            for (RPsiElement arg : args) {
                if (arg instanceof RAssoc) {
                    if (!RSpecSymbolProvider.setIfIsTypeAssocKey((PsiElement)arg, typeValueRef)) continue;
                    return true;
                }
                if (!(arg instanceof RAssocList)) continue;
                RAssocList rAssocList = (RAssocList)arg;
                if (arg != args.get(args.size() - 1)) continue;
                for (RPsiElement assoc : rAssocList.getElements()) {
                    if (!RSpecSymbolProvider.setIfIsTypeAssocKey((PsiElement)assoc, typeValueRef)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private static RSpecExampleGroupContextSymbol findCorrespondingExampleGroup(@Nullable RBlockCall exampleGroup, @NotNull RPsiElement rPsiElement) {
        String type;
        if (rPsiElement == null) {
            RSpecSymbolProvider.$$$reportNull$$$0(8);
        }
        Project project = rPsiElement.getProject();
        RClass containingRClass = RubyPsiUtil.getContainingRClass((PsiElement)rPsiElement);
        if (containingRClass != null && RTestUnitUtil.isUnitTestCaseLikeClassWithoutFileNameCheck(containingRClass) && RSpecUtil.isTestUnitWithRSpecSupportLoaded(project, rPsiElement.getContainingFile())) {
            return RSpecSymbolProvider.getDefaultTUnitExampleGroupContext(project, containingRClass);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)rPsiElement);
        RailsApp app = module != null ? RailsApp.fromModule(module) : null;
        VirtualFile specsRoot = app != null ? app.getSpecTestsRoot() : null;
        RContainer container = RubyPsiUtil.getContainingRClassOrRModuleOrRFile((PsiElement)rPsiElement);
        VirtualFile file = RubyPsiUtil.getVirtualFileFromElement((PsiElement)rPsiElement);
        if (specsRoot == null || file == null || !VfsUtilCore.isAncestor((VirtualFile)specsRoot, (VirtualFile)file, (boolean)false)) {
            return RSpecExampleGroupUtil.createDefaultExampleGroupContext(project, container);
        }
        if (!RSpecUtil.isRSpecRailsTestFile(project, file)) {
            return RSpecExampleGroupUtil.createDefaultExampleGroupContext(project, container);
        }
        Pair<RBlockCall, String> blockAndType = RSpecSymbolProvider.findGroupWithExplicitlySpecifiedType(exampleGroup);
        if (blockAndType != null && (type = (String)blockAndType.getSecond()) != null) {
            return RSpecExampleGroupUtil.getRailsExampleGroupByType(type, app, exampleGroup, container);
        }
        String specFolderCategoryName = RSpecSymbolProvider.findSpecFileCategoryByLocation(file, specsRoot);
        if (!StringUtil.isEmpty((String)specFolderCategoryName)) {
            String type2 = specFolderCategoryName.endsWith("s") ? specFolderCategoryName.substring(0, specFolderCategoryName.length() - 1) : specFolderCategoryName;
            return RSpecExampleGroupUtil.getRailsExampleGroupByType(type2, app, exampleGroup, container);
        }
        return RSpecExampleGroupUtil.createRailsDefaultExampleGroupContext(project, container);
    }

    @Nullable
    private static RSpecContextSymbol getRSpecCucumberContextSymbol(@Nullable RBlockCall exampleGroup, @NotNull RPsiElement rPsiElement) {
        if (rPsiElement == null) {
            RSpecSymbolProvider.$$$reportNull$$$0(9);
        }
        Project project = rPsiElement.getProject();
        RContainer container = RubyPsiUtil.getContainingRClassOrRModuleOrRFile((PsiElement)rPsiElement);
        if (RSpecExpectationsUtil.isRSpecExpectationsSupportLoaded(project) && !RSpecUtil.isRSpecSupportLoaded(project)) {
            return RSpecExpectationsUtil.createExpectationsContext(project, container);
        }
        return RSpecSymbolProvider.findCorrespondingExampleGroup(exampleGroup, rPsiElement);
    }

    @Nullable
    private static String findSpecFileCategoryByLocation(VirtualFile file, VirtualFile specsRoot) {
        String specFolderCategoryName = null;
        VirtualFile current = file;
        while (current != null && !Comparing.equal((Object)current, (Object)specsRoot)) {
            VirtualFile prevFolder = current.getParent();
            if (Comparing.equal((Object)prevFolder, (Object)specsRoot)) {
                specFolderCategoryName = current.getName();
                break;
            }
            current = prevFolder;
        }
        return specFolderCategoryName;
    }

    @Nullable
    public static String getHelperSpecifiedByHelperNameCall(@NotNull RBlockCall exampleGroup) {
        if (exampleGroup == null) {
            RSpecSymbolProvider.$$$reportNull$$$0(10);
        }
        RCodeBlock groupClosure = exampleGroup.getBlock();
        RCompoundStatement groupCmpSt = groupClosure.getCompoundStatement();
        List statements = groupCmpSt.getStatements();
        for (RPsiElement statement : statements) {
            RCall call;
            String helperModuleFqn;
            if (!(statement instanceof RCall) || (helperModuleFqn = RSpecImplicitRequiresProvider.getAttachedHelperModuleFqn(call = (RCall)statement)) == null) continue;
            return helperModuleFqn;
        }
        return null;
    }

    private static boolean setIfIsTypeAssocKey(@NotNull PsiElement element, @NotNull Ref<String> valueRef) {
        String keyText;
        if (element == null) {
            RSpecSymbolProvider.$$$reportNull$$$0(11);
        }
        if (valueRef == null) {
            RSpecSymbolProvider.$$$reportNull$$$0(12);
        }
        if (!(element instanceof RAssoc)) {
            return false;
        }
        RAssoc rAssoc = (RAssoc)element;
        RPsiElement key = rAssoc.getKey();
        if (key instanceof RSymbol && "type".equals(keyText = RubyPsiUtilCore.getElementText((PsiElement)key))) {
            RPsiElement value = rAssoc.getValue();
            valueRef.set((Object)(value != null ? RubyPsiUtilCore.getElementText((PsiElement)value) : null));
            return true;
        }
        return false;
    }

    @Nullable
    private static RSpecExampleGroupContextSymbol getDefaultTUnitExampleGroupContext(Project project, @Nullable RClass containingRClass) {
        RContainer container;
        if (containingRClass == null && (container = RubyFQNUtil.findContainerByFQN(project, Type.CLASS.asSet(), FQN.of((String)DEFAULT_TUNIT_RSPEC_EXAMPLE_GROUP_CLASS_FQN), null)) instanceof RClass) {
            containingRClass = (RClass)container;
        }
        if (containingRClass == null) {
            return null;
        }
        return new RSpecExampleGroupContextSymbol((RContainer)containingRClass, null, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    private static boolean isRSpecSupportEnabled(Module module) {
        return module != null && (RSpecUtil.isRSpecSupportEnabled(module) || RSpecExpectationsUtil.isRSpecExpectationsSupportEnabled(module));
    }

    public static boolean shouldUseRSpecSupportFor(@NotNull RPsiElement rPsiElement) {
        Module module;
        if (rPsiElement == null) {
            RSpecSymbolProvider.$$$reportNull$$$0(13);
        }
        if (!RSpecSymbolProvider.isRSpecSupportEnabled(module = ModuleUtilCore.findModuleForPsiElement((PsiElement)rPsiElement))) {
            return false;
        }
        PsiFile rFile = rPsiElement.getContainingFile();
        VirtualFile file = RubyPsiUtil.getVirtualFileFromElement((PsiElement)rFile);
        Project project = rPsiElement.getProject();
        if (file == null) {
            return false;
        }
        return RSpecUtil.isRSpecTestFile(project, file) || RSpecUtil.underSpecDirectory(file) || RSpecUtil.isTestUnitWithRSpecFile(project, rFile) || RSpecCucumberUtil.isCucumberTestWithRSpec(project, module, file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqnPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coveringExampleGroup";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rPsiElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exampleGroup";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueRef";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/codeInsight/RSpecSymbolProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAccessContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createSymbolByContainer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSymbolScope";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processDynamicSymbols";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isGroupTypeSpecified";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findCorrespondingExampleGroup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getRSpecCucumberContextSymbol";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getHelperSpecifiedByHelperNameCall";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "setIfIsTypeAssocKey";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldUseRSpecSupportFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

