/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec.codeInsight;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.PsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeRegistry;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyEvalCallType;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RSpecSymbolProvider;

public class RSpecDefineMatcherCallType
extends RubyEvalCallType {
    public static final String DEFINE_ID = "define";
    public static final String MATCHER_ID = "matcher";
    public static final String NEGATED_MATCHER_ID = "define_negated_matcher";
    public static final String RSPEC_MATCHERS_MODULE_SHORT_NAME = "Matchers";
    private static final String RSPEC_MATCHERS_FQN = "RSpec::Matchers";
    private static final String PREFIX = "RSpec::Matchers";
    private static final List<String> PRESENTATIONS = List.of("RSpec::Matchers.define", "RSpec::Matchers.matcher", "RSpec::Matchers.define_negated_matcher", "RSpec::Matchers::DSL.define", "RSpec::Matchers::DSL.matcher", "RSpec::Matchers::DSL.define_negated_matcher");
    private static final String RSPEC_SRC_FILE_MARKER = "/lib/rspec/";

    public RSpecDefineMatcherCallType(@NonNls String id) {
        super(id);
    }

    public boolean isCompatible(@NotNull RPossibleCall call) {
        if (call == null) {
            RSpecDefineMatcherCallType.$$$reportNull$$$0(0);
        }
        return super.isCompatible(call) && !RubyCallTypeRegistry.hasReceiverWithName((RPossibleCall)call, (String)"Data");
    }

    @Override
    public boolean process(@NotNull Processor<? super Symbol> processor, @NotNull Symbol symbol, @NotNull RCall call, PsiElement invocationPoint) {
        if (processor == null) {
            RSpecDefineMatcherCallType.$$$reportNull$$$0(1);
        }
        if (symbol == null) {
            RSpecDefineMatcherCallType.$$$reportNull$$$0(2);
        }
        if (call == null) {
            RSpecDefineMatcherCallType.$$$reportNull$$$0(3);
        }
        String command = call.getCommand();
        boolean isRspecDefineCall = RSpecDefineMatcherCallType.isRSpecDefineCall(command, PsiUtilCore.getVirtualFile((PsiElement)call));
        VirtualFile virtualFile = RubyPsiUtil.getVirtualFileFromElement(invocationPoint);
        return !isRspecDefineCall || virtualFile == null || !TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)call.getProject()) || RSpecDefineMatcherCallType.processDynamicMatcherMethod(processor, call);
    }

    private static boolean isRSpecDefineCall(@NotNull String command, @Nullable VirtualFile file) {
        if (command == null) {
            RSpecDefineMatcherCallType.$$$reportNull$$$0(4);
        }
        if (command.startsWith("RSpec::Matchers")) {
            for (String presentation : PRESENTATIONS) {
                if (!presentation.equals(command)) continue;
                return true;
            }
        } else {
            if (command.equals("Factory.define")) {
                return false;
            }
            if (file != null && file.getUrl().contains(RSPEC_SRC_FILE_MARKER)) {
                return true;
            }
        }
        return false;
    }

    private static boolean processDynamicMatcherMethod(Processor<? super Symbol> processor, RCall call) {
        List callArguments = (List)call.getData(new RubyCallType[0]);
        String matcher_name = RSpecDefineMatcherCallType.getMatcherName(callArguments);
        if (matcher_name == null) {
            return true;
        }
        Project project = call.getProject();
        Symbol matchersModule = SymbolUtil.findConstantByFQN(project, Type.MODULE, RSpecSymbolProvider.RSPEC_2x_MATCHERS_MODULE_FQN, null);
        if (matchersModule != null) {
            return processor.process(new PsiElementSymbol<RCall>(call, matcher_name, Type.INSTANCE_METHOD, matchersModule));
        }
        return true;
    }

    @Nullable
    static String getMatcherName(@NotNull List<String> callArguments) {
        if (callArguments == null) {
            RSpecDefineMatcherCallType.$$$reportNull$$$0(5);
        }
        if (callArguments.isEmpty()) {
            return null;
        }
        String matcher_name = callArguments.get(0);
        if (TextUtil.isMethodName((String)matcher_name)) {
            return matcher_name;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callArguments";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/codeInsight/RSpecDefineMatcherCallType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompatible";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isRSpecDefineCall";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getMatcherName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

