/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.ArgumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.UnknownRubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationExtensionsManager;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.testing.BddTestsUtil;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecContextNameProvider;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecFilter;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RSpecCallTypeProvider;
import org.jetbrains.plugins.ruby.testing.rspec.run.RSpecRunConfiguration;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public final class RSpecUtil {
    private static final Function<String, String> APPEND_RSPEC = name -> "RSpec." + name;
    @NonNls
    public static final String RSPEC_GEM_NAME = "rspec";
    @NonNls
    public static final String RSPEC2_CORE_GEM_NAME = "rspec-core";
    private static final String[] RSPEC2_CORE_GEM_NAMES = new String[]{"rspec-core"};
    private static final String[] RSPEC_GEM_NAMES = new String[]{"rspec"};
    @NonNls
    public static final String RSPEC_RAILS_GEM_NAME = "rspec-rails";
    private static final String[] RSPEC_RAILS_GEM_NAMES = new String[]{"rspec-rails"};
    @NonNls
    private static final String RSPEC_RAILS_PLUGIN_NAME = "rspec-rails";
    @NonNls
    private static final String RSPEC_RAILS_PLUGIN_OLD_NAME = "rspec_on_rails";
    @NonNls
    public static final String SPECS_FOLDER = "spec";
    @NonNls
    private static final String RSPEC_GEM_EXECUTABLE = "rspec";
    @NonNls
    public static final String RSPEC_GEM_EXECUTABLE_API_1x = "spec";
    @NonNls
    private static final String CALL_EXAMPLE_FQN = "RSpec::Core::ExampleGroup.example";
    @NonNls
    private static final String CALL_SPECIFY_FQN = "RSpec::Core::ExampleGroup.specify";
    @NonNls
    private static final String CALL_IT_FQN = "RSpec::Core::ExampleGroup.it";
    @NonNls
    private static final String CALL_ITS_FQN = "RSpec::Core::Subject::ExampleGroupMethods.its";
    @NonNls
    private static final String CALL_PENDING_FQN = "RSpec::Core::ExampleGroup.pending";
    @NonNls
    private static final String CALL_FOCUSED_FQN = "RSpec::Core::ExampleGroup.focused";
    @NonNls
    private static final String CALL_EXAMPLE_FQN_API_1x = "Spec::Example::ExampleGroupMethods.example";
    @NonNls
    private static final String CALL_XEXAMPLE_FQN_API_1x = "Spec::Example::ExampleGroupMethods.xexample";
    @NonNls
    private static final String CALL_SPECIFY_FQN_API_1x = "Spec::Example::ExampleGroupMethods.specify";
    @NonNls
    private static final String CALL_XSPECIFY_FQN_API_1x = "Spec::Example::ExampleGroupMethods.xspecify";
    @NonNls
    private static final String CALL_IT_FQN_API_1X = "Spec::Example::ExampleGroupMethods.it";
    @NonNls
    private static final String CALL_XIT_FQN_API_1X = "Spec::Example::ExampleGroupMethods.xit";
    @NonNls
    private static final String CALL_DESCRIBE_FQN = "RSpec::Core::ObjectExtensions.describe";
    @NonNls
    private static final String CALL_DESCRIBE_FQN_API_1x = "Spec::DSL::Main.describe";
    @NonNls
    private static final String CALL_DESCRIBE_FQN_OLD_API = "Spec::Extensions::Main.describe";
    @NonNls
    private static final String CALL_DESCRIBE_FQN_INTERNAL_API = "RSpec::Core::ExampleGroup.describe";
    @NonNls
    private static final String CALL_XDESCRIBE_FQN_INTERNAL_API = "RSpec::Core::ExampleGroup.xdescribe";
    @NonNls
    private static final String CALL_FDESCRIBE_FQN_INTERNAL_API = "RSpec::Core::ExampleGroup.fdescribe";
    @NonNls
    private static final String CALL_DESCRIBE_FQN_INTERNAL_API_1x = "Spec::Example::ExampleGroupMethods.describe";
    public static final Set<String> CALL_SHARED_EXAMPLE_GROUP_NAMES = Set.of("share_as", "share_examples_for", "shared_context", "shared_examples", "shared_examples_for");
    private static final Set<String> CALL_DESCRIBE_SHORT_NAMES = Set.of("context", "describe", "fcontext", "fdescribe", "feature");
    private static final Set<String> CALL_DESCRIBE_DISABLED_SHORT_NAMES = Set.of("xcontext", "xdescribe");
    private static final Set<String> CALL_IT_SHORT_NAMES = Set.of("example", "fit", "focused", "it", "pending", "scenario", "specify");
    private static final Set<String> CALL_ITS_SHORT_NAMES = Set.of("its");
    private static final Set<String> CALL_IT_DISABLED_SHORT_NAMES = Set.of("xexample", "xit", "xspecify");
    private static final Set<String> CALL_PENDING_EXAMPLE_GROUP_SHORT_NAMES = Set.of("pending");
    private static final Set<String> CALL_EXAMPLE_BEFORE_AFTER_SHORT_NAMES = Set.of("after", "append_before", "before", "prepend_after", "setup", "teardown");
    private static final Set<String> RSPEC3_CALL_DESCRIBE_SHORT_NAMES = RSpecUtil.newSet(Collections2.transform(CALL_DESCRIBE_SHORT_NAMES, APPEND_RSPEC));
    private static final Set<String> RSPEC3_CALL_DESCRIBE_DISABLED_SHORT_NAMES = RSpecUtil.newSet(Collections2.transform(CALL_DESCRIBE_DISABLED_SHORT_NAMES, APPEND_RSPEC));
    private static final Set<String> RSPEC3_CALL_SHARED_EXAMPLE_GROUP_NAMES = RSpecUtil.newSet(Collections2.transform(CALL_SHARED_EXAMPLE_GROUP_NAMES, APPEND_RSPEC));
    private static final Set<String> CALL_INCLUDED_EXAMPLE_GROUP_REF_NAMES = Set.of("include_examples", "include_context");
    public static final String IT_SHOULD_BEHAVE_LIKE = "it_should_behave_like";
    public static final String IT_BEHAVES_LIKE = "it_behaves_like";
    private static final Set<String> CALL_BEHAVES_LIKE_SHARED_GROUP_REF_NAMES = Set.of("it_should_behave_like", "it_behaves_like");
    public static final Set<String> CALL_SHARED_EXAMPLE_GROUP_REF_NAMES = RSpecUtil.newSet(CALL_BEHAVES_LIKE_SHARED_GROUP_REF_NAMES, CALL_INCLUDED_EXAMPLE_GROUP_REF_NAMES);
    public static final String LET_CALL_NAME = "let";
    public static final String LET_BEFORE_CALL_NAME = "let!";
    public static final String SUBJECT_CALL_NAME = "subject";
    public static final String SUBJECT_BANG_CALL_NAME = "subject!";
    public static final List<String> SUBJECT_CALL_NAMES = List.of("subject", "subject!");
    private static final Set<String> CALL_DEFINING_NAMES = Set.of("let", "let!", "subject", "subject!");
    public static final Set<String> INSTANCE_CONTEXT_CALLS = RSpecUtil.newSet(CALL_IT_SHORT_NAMES, CALL_IT_DISABLED_SHORT_NAMES, CALL_EXAMPLE_BEFORE_AFTER_SHORT_NAMES, CALL_ITS_SHORT_NAMES, CALL_SHARED_EXAMPLE_GROUP_REF_NAMES, CALL_DEFINING_NAMES);
    private static final FQN RSPEC_SUPPORT_MARKER = FQN.Builder.fromString((String)"RSpec::Core::ExampleGroup");
    private static final FQN RSPEC_SUPPORT_MARKER_API_1x = FQN.Builder.fromString((String)"Spec::Example::ExampleGroup");
    private static final FQN TUNIT_RSPEC_SUPPORT_MARKER = FQN.Builder.fromString((String)"Spec::Test::Unit");
    private static final FQN RSPEC_RAILS_SUPPORT_MARKER = FQN.Builder.fromString((String)"RSpec::Rails");
    private static final FQN RSPEC_RAILS_SUPPORT_MARKER_1x = FQN.Builder.fromString((String)"Spec::Rails::Example");
    private static final Pattern GROUP_JOIN_RULE_PATTERN = Pattern.compile("^(\\.|#|::)");
    private static final String PENDING_CALL = "pending";
    private static final String[] RSPEC_PLUGIN_NAMES = new String[]{"rspec "};
    private static final String[] RSPEC_RAILS_PLUGIN_NAMES = new String[]{"rspec-rails", "rspec_on_rails"};
    public static final Set<String> RSPEC_SUPPORT_MARKERS = Set.of(RSPEC_SUPPORT_MARKER.getFullPath(), RSPEC_SUPPORT_MARKER_API_1x.getFullPath());
    private static final Set<String> EXAMPLE_CALLS_SHORT_NAMES = RSpecUtil.newSet(CALL_IT_SHORT_NAMES, CALL_IT_DISABLED_SHORT_NAMES, CALL_ITS_SHORT_NAMES, CALL_PENDING_EXAMPLE_GROUP_SHORT_NAMES);
    private static final Set<String> SHARED_EXAMPLE_GROUPS_CALLS_SHORT_NAMES = RSpecUtil.newSet(CALL_SHARED_EXAMPLE_GROUP_NAMES, RSPEC3_CALL_SHARED_EXAMPLE_GROUP_NAMES);
    private static final Set<String> EXAMPLE_GROUPS_CALLS_SHORT_NAMES = RSpecUtil.newSet(CALL_DESCRIBE_SHORT_NAMES, RSPEC3_CALL_DESCRIBE_SHORT_NAMES, CALL_DESCRIBE_DISABLED_SHORT_NAMES, RSPEC3_CALL_DESCRIBE_DISABLED_SHORT_NAMES);
    public static final Set<String> CLASS_CONTEXT_CALLS_WITHOUT_SHARED = EXAMPLE_GROUPS_CALLS_SHORT_NAMES;
    public static final Set<String> CLASS_CONTEXT_CALLS = RSpecUtil.newSet(CLASS_CONTEXT_CALLS_WITHOUT_SHARED, SHARED_EXAMPLE_GROUPS_CALLS_SHORT_NAMES);
    private static final Set<String> EXAMPLES_CALLS_FQNS = Set.of("RSpec::Its.its", "RSpec::Core::MemoizedHelpers::ClassMethods.its", "RSpec::Core::Subject::ExampleGroupMethods.its", "RSpec::Core::ExampleGroup.example", "RSpec::Core::ExampleGroup.specify", "RSpec::Core::ExampleGroup.it", "RSpec::Core::ExampleGroup.pending", "RSpec::Core::ExampleGroup.focused", "Spec::Example::ExampleGroupMethods.example", "Spec::Example::ExampleGroupMethods.xexample", "Spec::Example::ExampleGroupMethods.specify", "Spec::Example::ExampleGroupMethods.xspecify", "Spec::Example::ExampleGroupMethods.it", "Spec::Example::ExampleGroupMethods.xit");
    private static final Set<String> EXAMPLE_GROUPS_CALLS_FQNS = Set.of("RSpec::Core::ObjectExtensions.describe", "Spec::DSL::Main.describe", "Spec::Extensions::Main.describe", "RSpec::Core::ExampleGroup.describe", "RSpec::Core::ExampleGroup.xdescribe", "RSpec::Core::ExampleGroup.fdescribe", "Spec::Example::ExampleGroupMethods.describe");
    public static final String GENERATORS_R30_PREFIX = "rspec:";
    public static final String RSPEC2_GEM_FIRST_BETA_VERSION = "2.0.0.beta.1";
    public static final String RSPEC_RAILS_36_GEM_FIRST_BETA_VERSION = "3.6.0.beta.1";
    public static final String RSPEC_RAILS_MARKER_SCRIPT = "spec/spec_helper.rb";
    public static final String RSPEC3_RAILS_MARKER_SCRIPT = "spec/rails_helper.rb";
    private static final Set<String> RSPEC_SHARED_EXAMPLES_PATH_PARTS = Stream.of("shared_context", "shared_examples").flatMap(it -> Stream.of("_" + it, "/" + it)).collect(Collectors.toSet());
    public static final Set<String> TOP_LEVEL_CALL_DESCRIBE_SHORT_NAMES = RSpecUtil.newSet(Collections2.transform(CALL_DESCRIBE_SHORT_NAMES, APPEND_RSPEC));

    private RSpecUtil() {
    }

    @NotNull
    public static String getRailsSpecFolderPathOrUrl(@NotNull String railsAppRootPathOrUlr) {
        if (railsAppRootPathOrUlr == null) {
            RSpecUtil.$$$reportNull$$$0(0);
        }
        String string = railsAppRootPathOrUlr + "/spec";
        if (string == null) {
            RSpecUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static boolean isRSpecRailsSupportInstalledInRailsProject(@NotNull String rorAppHomeDirUrl) {
        if (rorAppHomeDirUrl == null) {
            RSpecUtil.$$$reportNull$$$0(2);
        }
        return RailsUtil.getPathIfFileExists(rorAppHomeDirUrl, RSPEC_RAILS_MARKER_SCRIPT) != null || RailsUtil.getPathIfFileExists(rorAppHomeDirUrl, RSPEC3_RAILS_MARKER_SCRIPT) != null;
    }

    public static boolean isRSpecSupportEnabled(@NotNull Module module) {
        if (module == null) {
            RSpecUtil.$$$reportNull$$$0(3);
        }
        return GemUtil.isGemOrRailsPluginSupportEnabled(module, RSPEC_GEM_NAMES, RSPEC_PLUGIN_NAMES) || GemUtil.isGemOrRailsPluginSupportEnabled(module, RSPEC_RAILS_GEM_NAMES, RSPEC_RAILS_PLUGIN_NAMES) || GemUtil.isGemOrRailsPluginSupportEnabled(module, RSPEC2_CORE_GEM_NAMES, RSPEC2_CORE_GEM_NAMES) || RSpecUtil.isRSpecRailsSupportEnabled(module);
    }

    public static boolean isRSpecRailsSupportEnabled(@NotNull Module module) {
        if (module == null) {
            RSpecUtil.$$$reportNull$$$0(4);
        }
        if (!RailsFacetUtil.hasRailsSupport(module)) {
            return false;
        }
        return GemUtil.isGemOrRailsPluginSupportEnabled(module, RSPEC_RAILS_GEM_NAMES, RSPEC_RAILS_PLUGIN_NAMES);
    }

    public static boolean isRSpecRailsSupportProbablyEnabled(@NotNull Module module, @NotNull Sdk sdk) {
        if (module == null) {
            RSpecUtil.$$$reportNull$$$0(5);
        }
        if (sdk == null) {
            RSpecUtil.$$$reportNull$$$0(6);
        }
        if (!RailsFacetUtil.hasRailsSupport(module)) {
            return false;
        }
        return GemUtil.isGemOrRailsPluginSupportProbablyEnabled(module, sdk, RSPEC_RAILS_GEM_NAMES, RSPEC_RAILS_PLUGIN_NAMES);
    }

    public static boolean isRSpecTestFile(Project project, @Nullable VirtualFile file) {
        if (!RSpecUtil.isFileWithRSpecTestFileName(file)) {
            return false;
        }
        return RSpecUtil.isRSpecSupportLoaded(project);
    }

    public static boolean isTestUnitWithRSpecFile(Project project, @NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            RSpecUtil.$$$reportNull$$$0(7);
        }
        if ((virtualFile = file.getVirtualFile()) == null || !TestUnitUtil.isFileWithValidTestUnitFileName(virtualFile)) {
            return false;
        }
        return RSpecUtil.isTestUnitWithRSpecSupportLoaded(project, file);
    }

    public static boolean isTestUnitWithRSpecSupportLoaded(Project project, @Nullable PsiFile invocationPoint) {
        return RSpecUtil.isRSpecSupportLoaded(project) && RubyFQNUtil.findContainerByFQN(project, Type.MODULE.asSet(), TUNIT_RSPEC_SUPPORT_MARKER, (PsiElement)invocationPoint) instanceof RModule;
    }

    public static boolean isRSpecRailsTestFile(Project project, @Nullable VirtualFile file) {
        if (!RSpecUtil.isFileWithRSpecTestFileName(file)) {
            return false;
        }
        return RSpecUtil.isRSpecRailsSupportLoaded(project);
    }

    public static boolean isFileWithRSpecTestFileName(@Nullable VirtualFile file) {
        return BddTestsUtil.isFileWithSpecTestFileName(file);
    }

    public static boolean underSpecDirectory(@Nullable VirtualFile file) {
        return file != null && file.getPath().contains("/spec/");
    }

    public static boolean underSpecSharedExamplesDirectory(@Nullable VirtualFile file) {
        return RSpecUtil.underSpecDirectory(file) && ContainerUtil.exists(RSPEC_SHARED_EXAMPLES_PATH_PARTS, path -> file.getPath().indexOf((String)path) > file.getPath().indexOf("/spec/"));
    }

    @Nullable
    public static String determinePreferredSpecExecutablePath(@Nullable Module module, @Nullable Sdk alternativeSdk, @Nullable String forceRSpeGemVersion) {
        Sdk sdk;
        String specCreatedByGenerator;
        if (module != null && RailsFacetUtil.hasRailsSupport(module) && (specCreatedByGenerator = RailsUtil.getRailsScriptExecutablePath(module, "spec")) != null) {
            return specCreatedByGenerator;
        }
        Object object = alternativeSdk == null ? (module != null ? RModuleUtil.getInstance().findRubySdkForModule(module) : null) : (sdk = alternativeSdk);
        if (sdk != null) {
            return RSpecUtil.getRSpecGemExecutablePath(module, sdk, forceRSpeGemVersion);
        }
        return null;
    }

    @Nullable
    public static String getCurrentExampleFilter(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.$$$reportNull$$$0(8);
        }
        return (String)ObjectUtils.doIfNotNull((Object)RSpecUtil.determineCurrentExampleFilter(psiElement), RSpecFilter::getFilter);
    }

    @Nullable
    public static RSpecFilter determineCurrentExampleFilter(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.$$$reportNull$$$0(9);
        }
        ArrayList<String> fullGroupNames = new ArrayList<String>();
        ArrayList<String> exampleShortNames = new ArrayList<String>();
        RSpecUtil.collectGroupAndExampleNames(psiElement, fullGroupNames, exampleShortNames, true);
        if (fullGroupNames.isEmpty() && exampleShortNames.isEmpty()) {
            return null;
        }
        boolean containsRegex = false;
        String additionalContextName = null;
        for (RSpecContextNameProvider provider : (RSpecContextNameProvider[])RSpecContextNameProvider.EP_NAME.getExtensions()) {
            String contextName = provider.getContextName(psiElement);
            if (contextName == null) continue;
            additionalContextName = contextName;
            containsRegex = provider.contextNameContainsRegex();
            break;
        }
        String context = additionalContextName;
        boolean shouldEscapeNames = containsRegex;
        String filter = fullGroupNames.stream().flatMap(group -> exampleShortNames.stream().map(example -> {
            String groupName = shouldEscapeNames ? StringUtil.escapeToRegexp((String)group) : group;
            String exampleName = shouldEscapeNames && example != null ? StringUtil.escapeToRegexp((String)example) : example;
            return RSpecUtil.getExampleName(groupName, context, exampleName, true);
        })).collect(Collectors.joining("||"));
        return new RSpecFilter(filter, containsRegex);
    }

    @Nullable
    public static String getCurrentExampleName(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.$$$reportNull$$$0(10);
        }
        ArrayList<String> fullGroupNames = new ArrayList<String>();
        ArrayList<String> exampleShortNames = new ArrayList<String>();
        RSpecUtil.collectGroupAndExampleNames(psiElement, fullGroupNames, exampleShortNames, false);
        return fullGroupNames.stream().flatMap(group -> exampleShortNames.stream().map(example -> RSpecUtil.getExampleName(group, null, example, false))).collect(Collectors.joining("||"));
    }

    private static void collectGroupAndExampleNames(@NotNull PsiElement psiElement, @NotNull List<String> groups, @NotNull List<String> exampleNames, boolean forExamplesFilter) {
        List<String> exampleNamesWithSubstitutions;
        RSpecExampleNameBuilder exampleNameBuilder;
        RSpecGroupNameBuilder groupNameBuilder;
        boolean success;
        if (psiElement == null) {
            RSpecUtil.$$$reportNull$$$0(11);
        }
        if (groups == null) {
            RSpecUtil.$$$reportNull$$$0(12);
        }
        if (exampleNames == null) {
            RSpecUtil.$$$reportNull$$$0(13);
        }
        if (!(success = BddTestsUtil.gatherGroupsAndExampleNames(psiElement, groupNameBuilder = new RSpecGroupNameBuilder(), exampleNameBuilder = new RSpecExampleNameBuilder(forExamplesFilter)))) {
            return;
        }
        List<String> fullGroupNames = ((BddTestsUtil.GroupNameBuilder)groupNameBuilder).getFullGroupNamesWithSubstitutions();
        if (fullGroupNames.isEmpty() || !forExamplesFilter) {
            fullGroupNames = List.of(((BddTestsUtil.GroupNameBuilder)groupNameBuilder).getFullGroupName());
        }
        List<String> exampleShortNames = (exampleNamesWithSubstitutions = exampleNameBuilder.getExampleShortNamesWithSubstitutions()).isEmpty() || !forExamplesFilter ? Collections.singletonList(exampleNameBuilder.getExampleShortName()) : exampleNamesWithSubstitutions;
        groups.addAll(fullGroupNames);
        exampleNames.addAll(exampleShortNames);
    }

    @NotNull
    private static String getExampleName(@NotNull String group, @Nullable String context, @Nullable String example, boolean isFilter) {
        if (group == null) {
            RSpecUtil.$$$reportNull$$$0(14);
        }
        if (context == null || !isFilter) {
            Object object = example == null ? group : group + " " + example;
            if (object == null) {
                RSpecUtil.$$$reportNull$$$0(15);
            }
            return object;
        }
        String string = group + " " + context + (String)(example == null ? "" : " " + example);
        if (string == null) {
            RSpecUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    public static boolean isMethodDescriptionAfterModule(@NotNull String part, @NotNull RPsiElement parent) {
        if (part == null) {
            RSpecUtil.$$$reportNull$$$0(17);
        }
        if (parent == null) {
            RSpecUtil.$$$reportNull$$$0(18);
        }
        if (!(parent instanceof RConstant || parent instanceof RColonReference || parent instanceof RTopConstReference)) {
            return false;
        }
        return GROUP_JOIN_RULE_PATTERN.matcher(part).find();
    }

    @Nullable
    public static String determineItsExampleFullName(@NotNull RBlockCall blockCall, boolean forExamplesFilter) {
        RPossibleCall rCall;
        if (blockCall == null) {
            RSpecUtil.$$$reportNull$$$0(19);
        }
        if (!((rCall = blockCall.getCall()) instanceof RCall)) {
            return null;
        }
        List argsList = rCall.getArguments();
        Object fakeExGroupName = null;
        if (argsList.size() == 1) {
            List arrayArgs;
            RPsiElement arg = (RPsiElement)argsList.get(0);
            if (arg instanceof RArray && (arrayArgs = ((RArray)arg).getElements()).size() == 1) {
                arg = (RPsiElement)arrayArgs.get(0);
            }
            fakeExGroupName = RubyPsiUtilCore.getElementText((PsiElement)arg);
        }
        String matcherName = RSpecUtil.determineItsExampleMatcherName(blockCall);
        return forExamplesFilter ? fakeExGroupName : fakeExGroupName + (String)(matcherName != null ? " " + matcherName : "");
    }

    public static boolean isProbablyInSharedExampleGroupScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.$$$reportNull$$$0(20);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, SHARED_EXAMPLE_GROUPS_CALLS_SHORT_NAMES, Collections.emptySet());
    }

    public static boolean isInExampleScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.$$$reportNull$$$0(21);
        }
        return RubyPsiInterpreter.isInResolvableCallScope(psiElement, EXAMPLES_CALLS_FQNS, EXAMPLE_GROUPS_CALLS_FQNS);
    }

    public static boolean isProbablyInExampleScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.$$$reportNull$$$0(22);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, EXAMPLE_CALLS_SHORT_NAMES, EXAMPLE_GROUPS_CALLS_SHORT_NAMES);
    }

    public static boolean isProbablyInInstanceContextScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.$$$reportNull$$$0(23);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, INSTANCE_CONTEXT_CALLS, EXAMPLE_GROUPS_CALLS_SHORT_NAMES);
    }

    public static boolean isProbablyInExampleGroupScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.$$$reportNull$$$0(24);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, EXAMPLE_GROUPS_CALLS_SHORT_NAMES, EXAMPLE_CALLS_SHORT_NAMES);
    }

    public static boolean isProbablyInDefiningCallScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.$$$reportNull$$$0(25);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, CALL_DEFINING_NAMES, EXAMPLE_CALLS_SHORT_NAMES);
    }

    public static boolean isProbablyInDisabledCallScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.$$$reportNull$$$0(26);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, RSpecUtil.newSet(CALL_DESCRIBE_DISABLED_SHORT_NAMES, RSPEC3_CALL_DESCRIBE_DISABLED_SHORT_NAMES), EXAMPLE_CALLS_SHORT_NAMES) || RubyPsiInterpreter.isInCallScope(psiElement, CALL_IT_DISABLED_SHORT_NAMES, EXAMPLE_GROUPS_CALLS_SHORT_NAMES) || RubyPsiUtil.isInBlockCall(psiElement, blockCall -> CALL_DESCRIBE_DISABLED_SHORT_NAMES.contains(blockCall.getCommand()) || RSPEC3_CALL_DESCRIBE_DISABLED_SHORT_NAMES.contains(blockCall.getCommand()));
    }

    public static boolean isExampleGroupCall(@NotNull RPossibleCall call) {
        if (call == null) {
            RSpecUtil.$$$reportNull$$$0(27);
        }
        if (!(call instanceof RBlockCall)) {
            return false;
        }
        String name = call.getCommand();
        return name != null && EXAMPLE_GROUPS_CALLS_SHORT_NAMES.contains(name);
    }

    public static boolean isExampleCall(@NotNull RPossibleCall call) {
        String name;
        if (call == null) {
            RSpecUtil.$$$reportNull$$$0(28);
        }
        return (name = call.getCommand()) != null && (CALL_IT_SHORT_NAMES.contains(name) || CALL_IT_DISABLED_SHORT_NAMES.contains(name) || CALL_ITS_SHORT_NAMES.contains(name));
    }

    public static boolean isDisabledExampleCall(@NotNull RPossibleCall call) {
        String name;
        if (call == null) {
            RSpecUtil.$$$reportNull$$$0(29);
        }
        return (name = call.getCommand()) != null && CALL_IT_DISABLED_SHORT_NAMES.contains(name);
    }

    public static boolean isExampleBeforeAfterCall(@NotNull RPossibleCall call) {
        if (call == null) {
            RSpecUtil.$$$reportNull$$$0(30);
        }
        if (!(call instanceof RBlockCall)) {
            return false;
        }
        String name = call.getCommand();
        return name != null && CALL_EXAMPLE_BEFORE_AFTER_SHORT_NAMES.contains(name);
    }

    public static boolean isSharedExampleGroupCall(@NotNull RPossibleCall call) {
        if (call == null) {
            RSpecUtil.$$$reportNull$$$0(31);
        }
        if (!(call instanceof RBlockCall)) {
            return false;
        }
        String name = call.getCommand();
        return name != null && SHARED_EXAMPLE_GROUPS_CALLS_SHORT_NAMES.contains(name);
    }

    public static boolean isIncludedSharedGroupRef(@NotNull RPossibleCall call) {
        String name;
        if (call == null) {
            RSpecUtil.$$$reportNull$$$0(32);
        }
        return (name = call.getCommand()) != null && CALL_INCLUDED_EXAMPLE_GROUP_REF_NAMES.contains(name);
    }

    public static boolean isSharedGroupRef(@NotNull RPossibleCall call) {
        String name;
        if (call == null) {
            RSpecUtil.$$$reportNull$$$0(33);
        }
        return (name = call.getCommand()) != null && CALL_SHARED_EXAMPLE_GROUP_REF_NAMES.contains(name);
    }

    public static boolean isExampleSubjectCall(@NotNull RPossibleCall call) {
        String name;
        if (call == null) {
            RSpecUtil.$$$reportNull$$$0(34);
        }
        return (name = call.getCommand()) != null && CALL_ITS_SHORT_NAMES.contains(name);
    }

    public static boolean isPendingExampleCall(@NotNull RPossibleCall call) {
        PsiElement[] children;
        if (call == null) {
            RSpecUtil.$$$reportNull$$$0(35);
        }
        if (!RSpecUtil.isExampleCall(call) || RSpecUtil.isDisabledExampleCall(call)) {
            return false;
        }
        String name = call.getCommand();
        if (name != null && CALL_PENDING_EXAMPLE_GROUP_SHORT_NAMES.contains(name)) {
            return true;
        }
        RBlockCall blockCall = call instanceof RBlockCall ? (RBlockCall)call : RBlockCallNavigator.getByCall((RPsiElement)call);
        if (blockCall == null) {
            return true;
        }
        RCodeBlock codeBlock = blockCall.getBlock();
        RCompoundStatement statement = codeBlock.getCompoundStatement();
        for (PsiElement child : children = statement.getChildren()) {
            if (!(child instanceof RBlockCall ? PENDING_CALL.equals(((RBlockCall)child).getCommand()) : (child instanceof RCall ? PENDING_CALL.equals(((RCall)child).getCommand()) : child instanceof RIdentifier && PENDING_CALL.equals(child.getText())))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<RPsiElement> collectAllExamplesFrom(@NotNull RPsiElement root) {
        if (root == null) {
            RSpecUtil.$$$reportNull$$$0(36);
        }
        ArrayList specExampleBlocks = new ArrayList();
        RSpecUtil.collectAllExamplesFrom(root, specExampleBlocks);
        List<Object> list = !specExampleBlocks.isEmpty() ? specExampleBlocks : Collections.emptyList();
        if (list == null) {
            RSpecUtil.$$$reportNull$$$0(37);
        }
        return list;
    }

    @Nullable
    private static String getRSpecGemExecutablePath(@Nullable Module module, @NotNull Sdk sdk, @Nullable String forceRSpeGemVersion) {
        GemInfo gemInfo;
        if (sdk == null) {
            RSpecUtil.$$$reportNull$$$0(38);
        }
        GemInfo gemInfo2 = gemInfo = (gemInfo = RSpecUtil.getAttachedRSpecGem(module)) == null ? RubyGemSearchUtil.findGem(module, sdk, "rspec") : gemInfo;
        if (gemInfo == null) {
            return null;
        }
        boolean isRSpec20 = StringUtil.isEmpty((String)forceRSpeGemVersion) ? !RSpecUtil.isRSpec1x(gemInfo.getVersion()) : !RSpecUtil.isRSpec1x(forceRSpeGemVersion);
        String rspecExecutableName = isRSpec20 ? "rspec" : "spec";
        String gemWithRSpecExecutable = isRSpec20 ? RSPEC2_CORE_GEM_NAME : "rspec";
        return RubyGemExecutionContext.getScriptPath(sdk, module, gemWithRSpecExecutable, rspecExecutableName);
    }

    @Nullable
    public static GemInfo getAttachedRSpecGem(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        GemInfo rspecGem = RubyProjectGemSearchService.Companion.findGem(module, "rspec");
        if (rspecGem != null) {
            return rspecGem;
        }
        return RubyProjectGemSearchService.Companion.findGem(module, RSPEC2_CORE_GEM_NAME);
    }

    @Nullable
    public static GemInfo getAttachedRSpecRailsGem(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        return RubyProjectGemSearchService.Companion.findGem(module, "rspec-rails");
    }

    private static boolean isRSpec1x(String version) {
        return VersionComparatorUtil.compare((String)version, (String)RSPEC2_GEM_FIRST_BETA_VERSION) < 0;
    }

    public static boolean isRSpec2xGemAttached(@NotNull Module module) {
        GemInfo rSpecGem;
        if (module == null) {
            RSpecUtil.$$$reportNull$$$0(39);
        }
        return (rSpecGem = RSpecUtil.getAttachedRSpecGem(module)) != null && !RSpecUtil.isRSpec1x(rSpecGem.getVersion());
    }

    public static boolean isRSpec20SupportLoaded(Project project) {
        return RubyFQNUtil.findContainerByFQN(project, Type.CLASS.asSet(), RSPEC_SUPPORT_MARKER, null) instanceof RClass;
    }

    public static boolean isRSpecSupportLoaded(Project project) {
        return RSpecUtil.isRSpec20SupportLoaded(project);
    }

    private static boolean isRSpecRailsSupportLoaded(Project project) {
        return RubyFQNUtil.findContainerByFQN(project, Type.MODULE.asSet(), RSPEC_RAILS_SUPPORT_MARKER, null) instanceof RModule || RubyFQNUtil.findContainerByFQN(project, Type.MODULE.asSet(), RSPEC_RAILS_SUPPORT_MARKER_1x, null) instanceof RModule;
    }

    public static boolean isRailsRSpec36plusGemAttached(@NotNull Module module) {
        GemInfo gemInfo;
        if (module == null) {
            RSpecUtil.$$$reportNull$$$0(40);
        }
        return (gemInfo = RSpecUtil.getAttachedRSpecRailsGem(module)) != null && VersionComparatorUtil.compare((String)gemInfo.getVersion(), (String)RSPEC_RAILS_36_GEM_FIRST_BETA_VERSION) >= 0;
    }

    public static void collectChildren(RPsiElement root, List<? super RPsiElement> nodeElements, List<? super RPsiElement> exampleLikeElements, boolean allowOnlyExampleLeafs) {
        block7: {
            block6: {
                PsiElement[] children;
                if (!(root instanceof RBlockCall)) break block6;
                RBlockCall blockCall = (RBlockCall)root;
                if (!RSpecUtil.isExampleGroupCall((RPossibleCall)blockCall) && !RSpecUtil.isSharedExampleGroupCall((RPossibleCall)blockCall)) break block7;
                RCompoundStatement statement = blockCall.getBlock().getCompoundStatement();
                for (PsiElement child : children = statement.getChildren()) {
                    if (child instanceof RPossibleCall) {
                        RPossibleCall call = (RPossibleCall)child;
                        if (RSpecUtil.isExampleGroupCall(call) || RSpecUtil.isSharedExampleGroupCall(call)) {
                            nodeElements.add((RPsiElement)call);
                            continue;
                        }
                        if ((allowOnlyExampleLeafs || !RSpecUtil.isExampleBeforeAfterCall(call)) && !RSpecUtil.isExampleCall(call) && !RSpecUtil.isSharedGroupRef(call)) continue;
                        exampleLikeElements.add((RPsiElement)call);
                        continue;
                    }
                    if (!(child instanceof RContainer) || child instanceof RObjectClass) continue;
                    nodeElements.add((RPsiElement)((RContainer)child));
                }
                break block7;
            }
            if (root instanceof RContainer) {
                List statements = ((RContainer)root).getStatements();
                for (RPsiElement statement : statements) {
                    if (statement instanceof RBlockCall) {
                        RBlockCall childBlock = (RBlockCall)statement;
                        if (!RSpecUtil.isExampleGroupCall((RPossibleCall)childBlock) && !RSpecUtil.isSharedExampleGroupCall((RPossibleCall)childBlock)) continue;
                        nodeElements.add((RPsiElement)statement);
                        continue;
                    }
                    if (!(statement instanceof RContainer)) continue;
                    nodeElements.add((RPsiElement)statement);
                }
            }
        }
    }

    private static void collectAllExamplesFrom(@NotNull RPsiElement root, List<? super RPsiElement> specExampleBlocks) {
        if (root == null) {
            RSpecUtil.$$$reportNull$$$0(41);
        }
        ArrayList nodes = new ArrayList();
        RSpecUtil.collectChildren(root, nodes, specExampleBlocks, true);
        for (RPsiElement node : nodes) {
            RSpecUtil.collectAllExamplesFrom(node, specExampleBlocks);
        }
    }

    @Nullable
    public static RBlockCall getSimpleCoveringExampleOrBeforeAfterScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.$$$reportNull$$$0(42);
        }
        return RubyPsiInterpreter.getSimpleCoveringCodeBlockScope(psiElement, INSTANCE_CONTEXT_CALLS, CLASS_CONTEXT_CALLS);
    }

    @Nullable
    public static RBlockCall getSimpleCoveringExampleGroupScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.$$$reportNull$$$0(43);
        }
        return RubyPsiInterpreter.getSimpleCoveringCodeBlockScope(psiElement, CLASS_CONTEXT_CALLS, INSTANCE_CONTEXT_CALLS);
    }

    @Nullable
    public static RBlockCall getCoveringExampleGroupScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.$$$reportNull$$$0(44);
        }
        return RubyPsiInterpreter.getSimpleCoveringCodeBlockScope(psiElement, CLASS_CONTEXT_CALLS, Collections.emptySet());
    }

    @Nullable
    public static RBlockCall getCoveringSharedExampleGroupScope(@NotNull PsiElement psiElement) {
        RBlockCall blockCall;
        if (psiElement == null) {
            RSpecUtil.$$$reportNull$$$0(45);
        }
        if ((blockCall = RubyPsiInterpreter.getSimpleCoveringCodeBlockScope(psiElement, SHARED_EXAMPLE_GROUPS_CALLS_SHORT_NAMES, Collections.emptySet())) == null) {
            RPossibleCall call = RubyPsiInterpreter.getCallScope(psiElement, SHARED_EXAMPLE_GROUPS_CALLS_SHORT_NAMES, Collections.emptySet());
            blockCall = (RBlockCall)PsiTreeUtil.getNonStrictParentOfType((PsiElement)call, (Class[])new Class[]{RBlockCall.class});
        }
        return blockCall;
    }

    @Nullable
    public static RBlockCall getTopmostExampleGroupScope(@NotNull PsiElement psiElement) {
        RBlockCall blockCall;
        if (psiElement == null) {
            RSpecUtil.$$$reportNull$$$0(46);
        }
        if ((blockCall = (RBlockCall)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RBlockCall.class)) == null) {
            return null;
        }
        RPsiElement receiver = blockCall.getReceiver();
        if (receiver == null || !"RSpec".equals(receiver.getName())) {
            return null;
        }
        if (!EXAMPLE_GROUPS_CALLS_SHORT_NAMES.contains(blockCall.getCommand())) {
            return null;
        }
        return blockCall;
    }

    @Nullable
    public static VirtualFile getRSpecLibFolder(Module module) {
        return GemUtil.getGemOrRailsPluginLibDir(module, "rspec", RSPEC_PLUGIN_NAMES);
    }

    @Nullable
    public static String determineItsExampleMatcherName(@Nullable RBlockCall itsBlockCall) {
        if (itsBlockCall == null) {
            return null;
        }
        RCompoundStatement cmpst = itsBlockCall.getBlock().getCompoundStatement();
        List statements = cmpst.getStatements();
        if (!statements.isEmpty()) {
            RPsiElement lastStatement = (RPsiElement)statements.get(statements.size() - 1);
            String text = lastStatement.getText();
            return text.replace("\n", " ").replace("_", " ");
        }
        return null;
    }

    private static Set<String> newSet(Collection<String> ... collections) {
        if (collections == null) {
            RSpecUtil.$$$reportNull$$$0(47);
        }
        HashSet<String> res = new HashSet<String>();
        for (Collection<String> collection : collections) {
            res.addAll(collection);
        }
        return Collections.unmodifiableSet(res);
    }

    public static boolean isShouldCall(RubyCallType<?> type) {
        return type != UnknownRubyCallType.INSTANCE && ("should".equals(type.getCommandName()) || "should_not".equals(type.getCommandName()));
    }

    public static boolean underShouldCall(RCall call) {
        RCall parent = (RCall)PsiTreeUtil.getParentOfType((PsiElement)call, RCall.class, (boolean)true, (Class[])new Class[]{RCompoundStatement.class});
        return parent != null && RSpecUtil.isShouldCall(parent.getCallType());
    }

    @Nullable
    public static RCall findLetCall(@NotNull PsiElement element) {
        RCall call;
        if (element == null) {
            RSpecUtil.$$$reportNull$$$0(48);
        }
        if (element instanceof RCall) {
            call = (RCall)element;
        } else if (element instanceof ArgumentFakePsiElement) {
            RCall parentCall = (RCall)ObjectUtils.tryCast((Object)element.getParent(), RCall.class);
            if (parentCall == null) {
                return null;
            }
            call = parentCall;
        } else if (element instanceof RSymbol) {
            if (!(element.getParent().getParent() instanceof RCall)) {
                return null;
            }
            call = (RCall)element.getParent().getParent();
        } else {
            return null;
        }
        return RSpecCallTypeProvider.LET_CALL == call.getCallType() ? call : null;
    }

    public static void setCommonRunConfParams(@NotNull RSpecRunConfiguration conf, @Nullable String exampleOrGroupNameFilter, @Nullable Module module, @NotNull Location<?> location, boolean useExampleMatches) {
        if (conf == null) {
            RSpecUtil.$$$reportNull$$$0(49);
        }
        if (location == null) {
            RSpecUtil.$$$reportNull$$$0(50);
        }
        conf.setExampleNamesFilter(exampleOrGroupNameFilter);
        conf.setUseExampleMatches(useExampleMatches);
        RunConfigurationUtil.setRailsDefaultTestEnvironment(conf, module);
        JRubySdkUtil.enableObjectSpaceIfNotOverriddenByUser(conf);
        RubyRunConfigurationExtensionsManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)conf, location);
    }

    @Contract(value="null -> null")
    @Nullable
    public static String getRspecGroupName(@Nullable RBlockCall group) {
        if (group == null) {
            return null;
        }
        RPsiElement nameArg = (RPsiElement)ContainerUtil.getFirstItem((List)group.getArguments());
        return RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)nameArg);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 15, 16, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsAppRootPathOrUlr";
                break;
            }
            case 1: 
            case 15: 
            case 16: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/RSpecUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rorAppHomeDirUrl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exampleNames";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockCall";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collections";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/RSpecUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRailsSpecFolderPathOrUrl";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExampleName";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllExamplesFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRailsSpecFolderPathOrUrl";
                break;
            }
            case 1: 
            case 15: 
            case 16: 
            case 37: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRSpecRailsSupportInstalledInRailsProject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRSpecSupportEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isRSpecRailsSupportEnabled";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isRSpecRailsSupportProbablyEnabled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isTestUnitWithRSpecFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentExampleFilter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "determineCurrentExampleFilter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentExampleName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectGroupAndExampleNames";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExampleName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isMethodDescriptionAfterModule";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "determineItsExampleFullName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isProbablyInSharedExampleGroupScope";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInExampleScope";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isProbablyInExampleScope";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isProbablyInInstanceContextScope";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isProbablyInExampleGroupScope";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isProbablyInDefiningCallScope";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isProbablyInDisabledCallScope";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isExampleGroupCall";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isExampleCall";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isDisabledExampleCall";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isExampleBeforeAfterCall";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isSharedExampleGroupCall";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isIncludedSharedGroupRef";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isSharedGroupRef";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isExampleSubjectCall";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isPendingExampleCall";
                break;
            }
            case 36: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "collectAllExamplesFrom";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getRSpecGemExecutablePath";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isRSpec2xGemAttached";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isRailsRSpec36plusGemAttached";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleCoveringExampleOrBeforeAfterScope";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleCoveringExampleGroupScope";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getCoveringExampleGroupScope";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getCoveringSharedExampleGroupScope";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostExampleGroupScope";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "newSet";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findLetCall";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "setCommonRunConfParams";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 15, 16, 37 -> new IllegalStateException(string);
        };
    }

    private static final class RSpecGroupNameBuilder
    extends BddTestsUtil.GroupNameBuilder {
        private static final String[] EXAMPLE_GROUPS = ArrayUtilRt.toStringArray(RSpecUtil.newSet(EXAMPLE_GROUPS_CALLS_SHORT_NAMES, SHARED_EXAMPLE_GROUPS_CALLS_SHORT_NAMES));

        private RSpecGroupNameBuilder() {
            super(EXAMPLE_GROUPS);
        }

        @Override
        @NotNull
        public String getFullGroupName() {
            RPsiElement firstPart;
            String text;
            StringBuilder buff = new StringBuilder();
            List<? extends RPsiElement> partsInReversedOrder = this.getPartsInReversedOrder();
            int size = partsInReversedOrder.size();
            if (size > 0 && (text = RSpecGroupNameBuilder.getArgText(firstPart = partsInReversedOrder.get(size - 1))) != null) {
                if (text.startsWith("::") && RSpecGroupNameBuilder.elementContainsTopConstReference((PsiElement)firstPart)) {
                    buff.append(text.substring(2));
                } else {
                    buff.append(text);
                }
            }
            for (int i = size - 2; i >= 0; --i) {
                String part = RSpecGroupNameBuilder.getArgText(partsInReversedOrder.get(i));
                if (part == null) continue;
                if (!RSpecUtil.isMethodDescriptionAfterModule(part, partsInReversedOrder.get(i + 1))) {
                    buff.append(' ');
                }
                buff.append(part);
            }
            String string = buff.toString();
            if (string == null) {
                RSpecGroupNameBuilder.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public List<String> getFullGroupNamesWithSubstitutions() {
            List<? extends RPsiElement> partsInReversedOrder = this.getPartsInReversedOrder();
            if (partsInReversedOrder.stream().mapMulti(StreamUtil.select(RStringLiteral.class, (Class[])new Class[0])).noneMatch(it -> it.hasExpressionSubstitutions())) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    RSpecGroupNameBuilder.$$$reportNull$$$0(1);
                }
                return list;
            }
            List<String> groupNames = Collections.emptyList();
            for (int i = partsInReversedOrder.size() - 1; i >= 0; --i) {
                RPsiElement part = partsInReversedOrder.get(i);
                String argText = RSpecGroupNameBuilder.getArgText(part);
                if (i == partsInReversedOrder.size() - 1 && argText != null && argText.startsWith("::") && part instanceof RTopConstReference) {
                    groupNames = List.of(argText.substring(2));
                    continue;
                }
                String partsSeparator = i != partsInReversedOrder.size() - 1 && argText != null && !RSpecUtil.isMethodDescriptionAfterModule(argText, partsInReversedOrder.get(i + 1)) ? " " : "";
                groupNames = RSpecGroupNameBuilder.getGroupNamesWithSubstitutionsForPart(part, groupNames, partsSeparator);
            }
            List<String> list = groupNames;
            if (list == null) {
                RSpecGroupNameBuilder.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        private static List<String> getGroupNamesWithSubstitutionsForPart(@NotNull RPsiElement part, @NotNull List<String> groupNames, @NotNull String partsSeparator) {
            ArrayList<String> names;
            if (part == null) {
                RSpecGroupNameBuilder.$$$reportNull$$$0(3);
            }
            if (groupNames == null) {
                RSpecGroupNameBuilder.$$$reportNull$$$0(4);
            }
            if (partsSeparator == null) {
                RSpecGroupNameBuilder.$$$reportNull$$$0(5);
            }
            if ((names = new ArrayList<String>(part instanceof RStringLiteral ? BddTestsUtil.collectExampleNamesWithSubstitutions((RStringLiteral)part) : Collections.emptyList())).isEmpty()) {
                ContainerUtil.addIfNotNull(names, (Object)RSpecGroupNameBuilder.getArgText(part));
            }
            if (names.isEmpty()) {
                List<String> list = groupNames;
                if (list == null) {
                    RSpecGroupNameBuilder.$$$reportNull$$$0(6);
                }
                return list;
            }
            List<String> list = groupNames.isEmpty() ? names : groupNames.stream().flatMap(group -> names.stream().map(sub -> group + partsSeparator + sub)).collect(Collectors.toList());
            if (list == null) {
                RSpecGroupNameBuilder.$$$reportNull$$$0(7);
            }
            return list;
        }

        private static boolean elementContainsTopConstReference(@NotNull PsiElement psiElement) {
            if (psiElement == null) {
                RSpecGroupNameBuilder.$$$reportNull$$$0(8);
            }
            PsiElement currentReference = psiElement;
            while (currentReference instanceof RColonReference) {
                currentReference = currentReference.getFirstChild();
            }
            return currentReference instanceof RTopConstReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4, 5, 8 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/RSpecUtil$RSpecGroupNameBuilder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "part";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupNames";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "partsSeparator";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullGroupName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullGroupNamesWithSubstitutions";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/RSpecUtil$RSpecGroupNameBuilder";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupNamesWithSubstitutionsForPart";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getGroupNamesWithSubstitutionsForPart";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "elementContainsTopConstReference";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4, 5, 8 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class RSpecExampleNameBuilder
    extends BddTestsUtil.ExampleNameBuilder {
        private static final String[] EXAMPLES = ArrayUtilRt.toStringArray(EXAMPLE_CALLS_SHORT_NAMES);
        private final boolean forExamplesFilter;

        private RSpecExampleNameBuilder(boolean forExamplesFilter) {
            super(EXAMPLES);
            this.forExamplesFilter = forExamplesFilter;
        }

        @Override
        public void register(@NotNull RubyPsiInterpreter interpreter) {
            if (interpreter == null) {
                RSpecExampleNameBuilder.$$$reportNull$$$0(0);
            }
            super.register(interpreter);
            interpreter.registerCallable(new PsiCallable(){

                @Override
                public void processCall(RCallArguments arguments) {
                    PsiElement callElement = arguments.getRCallElement();
                    RBlockCall blockCall = callElement instanceof RPsiElement ? RBlockCallNavigator.getByCall((RPsiElement)((RPsiElement)callElement)) : null;
                    myExampleShortName = StringUtil.notNullize(blockCall != null ? RSpecUtil.determineItsExampleFullName(blockCall, forExamplesFilter) : null);
                }
            }, ArrayUtilRt.toStringArray(CALL_ITS_SHORT_NAMES));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "org/jetbrains/plugins/ruby/testing/rspec/RSpecUtil$RSpecExampleNameBuilder", "register"));
        }
    }
}

