/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RSpecSymbolProvider;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.symbols.RSpecExpectationsContextSymbol;

public final class RSpecExpectationsUtil {
    @NonNls
    public static final String RSPEC_EXPECTATIONS_GEM_NAME = "rspec-expectations";
    @NonNls
    public static final FQN RSPEC_EXPECTATIONS_MODULE_FQN = FQN.of((String)"RSpec::Expectations");
    @NonNls
    public static final FQN RSPEC_MATCHERS_MODULE_FQN = FQN.of((String)"RSpec::Matchers");
    @NonNls
    private static final String[] RSPEC_EXPECTATIONS_GEM_NAMES = new String[]{"rspec-expectations"};

    private RSpecExpectationsUtil() {
    }

    @Nullable
    public static RSpecExpectationsContextSymbol createExpectationsContext(@NotNull Project project, @Nullable RContainer container) {
        if (project == null) {
            RSpecExpectationsUtil.$$$reportNull$$$0(0);
        }
        return RSpecExpectationsUtil.createExpectationsContextSymbol(project, container, RSpecExpectationsUtil.getExpectationsBaseClass(project), List.of(RSpecSymbolProvider.RSPEC_2x_MATCHERS_MODULE_FQN));
    }

    public static boolean isRSpecExpectationsSupportEnabled(@NotNull Module module) {
        if (module == null) {
            RSpecExpectationsUtil.$$$reportNull$$$0(1);
        }
        return GemUtil.isGemOrRailsPluginSupportEnabled(module, RSPEC_EXPECTATIONS_GEM_NAMES, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public static boolean isRSpecExpectationsSupportLoaded(@NotNull Project project) {
        if (project == null) {
            RSpecExpectationsUtil.$$$reportNull$$$0(2);
        }
        return RubyFQNUtil.findContainerByFQN(project, Type.MODULE.asSet(), RSPEC_MATCHERS_MODULE_FQN, null) instanceof RModule && RubyFQNUtil.findContainerByFQN(project, Type.MODULE.asSet(), RSPEC_EXPECTATIONS_MODULE_FQN, null) instanceof RModule;
    }

    @Nullable
    private static RSpecExpectationsContextSymbol createExpectationsContextSymbol(@NotNull Project project, @Nullable RContainer container, @Nullable Symbol expectationsBaseClass, @NotNull List<FQN> moduleFQNs) {
        if (project == null) {
            RSpecExpectationsUtil.$$$reportNull$$$0(3);
        }
        if (moduleFQNs == null) {
            RSpecExpectationsUtil.$$$reportNull$$$0(4);
        }
        if (expectationsBaseClass == null || !(expectationsBaseClass.getPsiElement() instanceof RContainer)) {
            return null;
        }
        ArrayList<Symbol> implicitIncludes = new ArrayList<Symbol>();
        for (FQN fqn : moduleFQNs) {
            ContainerUtil.addIfNotNull(implicitIncludes, (Object)SymbolUtil.findConstantByFQN(project, Type.MODULE, fqn, null));
        }
        return new RSpecExpectationsContextSymbol((RContainer)expectationsBaseClass.getPsiElement(), container, implicitIncludes);
    }

    @Nullable
    private static Symbol getExpectationsBaseClass(@NotNull Project project) {
        if (project == null) {
            RSpecExpectationsUtil.$$$reportNull$$$0(5);
        }
        return SymbolUtil.findConstantByFQN(project, Type.MODULE, RSPEC_EXPECTATIONS_MODULE_FQN, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFQNs";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/RSpecExpectationsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createExpectationsContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isRSpecExpectationsSupportEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isRSpecExpectationsSupportLoaded";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createExpectationsContextSymbol";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpectationsBaseClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

