/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.actions;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.CommonBundle;
import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testIntegration.TestCreator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.templates.RubyCreateFileFromTemplateAction;
import org.jetbrains.plugins.ruby.ruby.templates.RubyCreateFileFromTemplateDialog;
import org.jetbrains.plugins.ruby.ruby.templates.RubyTemplateNames;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class RubyTestCreator
implements TestCreator {
    @VisibleForTesting
    public static final RubyCreateFileFromTemplateDialog.InputValidator INPUT_VALIDATOR = new RubyCreateFileFromTemplateDialog.InputValidator(){

        @Override
        @Nullable
        public String getErrorText(@NotNull String input, @Nullable String templateName) {
            if (input == null) {
                1.$$$reportNull$$$0(0);
            }
            if (RubyTemplateNames.RUBY_CLASS_OR_MODULE.contains(templateName) || RubyTemplateNames.ALL_TEST_TEMPLATES.contains(templateName)) {
                if (!TextUtil.isCIDOrColonQualifiedReference((String)input)) {
                    return RBundle.message((String)"ruby.action.create.new.class.file.dialog.invalid.name");
                }
            } else if ("Ruby File".equals(templateName) && !PathUtil.isValidFileName((String)input)) {
                return RBundle.message((String)"ruby.action.create.new.class.file.dialog.invalid.filename");
            }
            return null;
        }

        @Override
        public boolean isInputValid(@NotNull String input, @NotNull String templateName) {
            if (input == null) {
                1.$$$reportNull$$$0(1);
            }
            if (templateName == null) {
                1.$$$reportNull$$$0(2);
            }
            return StringUtil.isNotEmpty((String)input) && StringUtil.isEmpty((String)this.getErrorText(input, templateName));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateName";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/testing/actions/RubyTestCreator$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getErrorText";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInputValid";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        RElementWithFQN element;
        if (project == null) {
            RubyTestCreator.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            RubyTestCreator.$$$reportNull$$$0(1);
        }
        if (file == null) {
            RubyTestCreator.$$$reportNull$$$0(2);
        }
        if ((element = RubyTestCreator.findContextContainerAtCaret(editor, file)) == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)project)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        return module != null && !RubyTestCreator.getTestSourceRoots(module).isEmpty();
    }

    public void createTest(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        String suggestedRelativePath;
        RElementWithFQN element;
        if (project == null) {
            RubyTestCreator.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            RubyTestCreator.$$$reportNull$$$0(4);
        }
        if (file == null) {
            RubyTestCreator.$$$reportNull$$$0(5);
        }
        if ((element = RubyTestCreator.findContextContainerAtCaret(editor, file)) == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        PsiManager manager = PsiManager.getInstance((Project)project);
        List testSourceDirectories = ContainerUtil.mapNotNull(RubyTestCreator.getTestSourceRoots(module), arg_0 -> ((PsiManager)manager).findDirectory(arg_0));
        Pair<PsiDirectory, String> targetDirectoryAndPath = RubyTestCreator.getOrChooseDirectory(project, testSourceDirectories, suggestedRelativePath = RubyTestCreator.getSuggestedRelativePath(module, file.getVirtualFile().getParent()));
        if (targetDirectoryAndPath == null) {
            return;
        }
        PsiDirectory targetDirectory = (PsiDirectory)targetDirectoryAndPath.first;
        String targetPath = (String)targetDirectoryAndPath.second;
        if (!manager.isInProject((PsiElement)targetDirectory)) {
            String message = RBundle.message((String)"ruby.test.creator.dialog.directory.not.in.project", (Object[])new Object[]{targetDirectory.getVirtualFile().getPath()});
            Messages.showErrorDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle());
            return;
        }
        String destination = StringUtil.notNullize((String)RubyTestCreator.getRelativePath(module, targetDirectory.getVirtualFile())) + targetPath;
        RubyCreateFileFromTemplateDialog.Builder builder2 = RubyCreateFileFromTemplateDialog.builder(project).setTitle(RBundle.message((String)"ruby.test.creator.dialog.title", (Object[])new Object[]{destination})).setInputSuggester(templateName -> RubyTestCreator.getSuggestedTemplateName(element, templateName)).setInputValidator(INPUT_VALIDATOR);
        builder2.addKind(RBundle.message((String)"ruby.test.creator.dialog.kind.noTemplate"), RubyIcons.Ruby.RubyFile, "Ruby File");
        builder2.addKind(RBundle.message((String)"ruby.action.create.new.test.dialog.kind.minitest"), RubyIcons.TestUnit.TestUnitFile, "Minitest").addKind(RBundle.message((String)"ruby.action.create.new.test.dialog.kind.minitestSpec"), RubyIcons.Rspec.RspecTest, "Minitest Spec");
        if (RSpecUtil.isRSpecSupportEnabled(module)) {
            builder2.addKind(RBundle.message((String)"ruby.action.create.new.test.dialog.kind.rspec"), RubyIcons.Rspec.RspecTest, "RSpec");
        }
        if (TestUnitUtil.isTestUnitSupportEnabled(module)) {
            builder2.addKind(RBundle.message((String)"ruby.action.create.new.test.dialog.kind.testUnit"), RubyIcons.TestUnit.TestUnitFile, "TestUnit");
        }
        builder2.show(RubyTestCreator.getDefaultTemplateName(project), new MyFileCreator(project, targetDirectory, targetPath), newFile -> {
            FileEditorManager.getInstance((Project)project).openFile(newFile.getVirtualFile(), true);
            RubyCreateFileFromTemplateAction.moveCaretAfterNameIdentifier(newFile);
        });
    }

    @Nullable
    private static RElementWithFQN findContextContainerAtCaret(@NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement element;
        if (editor == null) {
            RubyTestCreator.$$$reportNull$$$0(6);
        }
        if (file == null) {
            RubyTestCreator.$$$reportNull$$$0(7);
        }
        if ((element = RubyTestCreator.findElementAtCaret(editor, file)) == null) {
            return (RElementWithFQN)ObjectUtils.tryCast((Object)file, RFile.class);
        }
        return SymbolUtil.getContextContainer(element);
    }

    @Nullable
    private static PsiElement findElementAtCaret(@NotNull Editor editor, @NotNull PsiFile file) {
        int offset;
        PsiElement element;
        if (editor == null) {
            RubyTestCreator.$$$reportNull$$$0(8);
        }
        if (file == null) {
            RubyTestCreator.$$$reportNull$$$0(9);
        }
        if ((element = file.findElementAt(offset = editor.getCaretModel().getOffset())) != null) {
            return element;
        }
        return offset > 0 && offset == file.getTextLength() ? file.findElementAt(offset - 1) : null;
    }

    @Nullable
    private static String getDefaultTemplateName(@NotNull Project project) {
        if (project == null) {
            RubyTestCreator.$$$reportNull$$$0(10);
        }
        return PropertiesComponent.getInstance((Project)project).getValue("DefaultRubyCreateTestTemplate");
    }

    @Nullable
    private static Pair<PsiDirectory, String> getOrChooseDirectory(@NotNull Project project, @NotNull List<PsiDirectory> directories, @NotNull String relativePath) {
        if (project == null) {
            RubyTestCreator.$$$reportNull$$$0(11);
        }
        if (directories == null) {
            RubyTestCreator.$$$reportNull$$$0(12);
        }
        if (relativePath == null) {
            RubyTestCreator.$$$reportNull$$$0(13);
        }
        if (directories.size() <= 1) {
            return !directories.isEmpty() ? new Pair((Object)((PsiDirectory)ContainerUtil.getOnlyItem(directories)), (Object)relativePath) : null;
        }
        Map postfixes = ContainerUtil.map2Map(directories, directory -> new Pair(directory, (Object)relativePath));
        PsiDirectory directory2 = DirectoryChooserUtil.chooseDirectory((PsiDirectory[])directories.toArray(PsiDirectory.EMPTY_ARRAY), null, (Project)project, (Map)postfixes);
        if (directory2 == null) {
            return null;
        }
        return new Pair((Object)directory2, (Object)(directories.contains(directory2) ? relativePath : ""));
    }

    @Nullable
    private static String getRelativePath(@NotNull Module module, @NotNull VirtualFile file) {
        if (module == null) {
            RubyTestCreator.$$$reportNull$$$0(14);
        }
        if (file == null) {
            RubyTestCreator.$$$reportNull$$$0(15);
        }
        return Arrays.stream(ProjectUtil.getRootManager((Module)module).getContentRoots()).filter(contentRoot -> VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)file, (boolean)false)).findFirst().map(contentRoot -> VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)contentRoot)).orElse(null);
    }

    @NotNull
    private static String getSuggestedRelativePath(@NotNull Module module, @NotNull VirtualFile file) {
        String relativePath;
        if (module == null) {
            RubyTestCreator.$$$reportNull$$$0(16);
        }
        if (file == null) {
            RubyTestCreator.$$$reportNull$$$0(17);
        }
        if (StringUtil.isEmpty((String)(relativePath = RubyTestCreator.getRelativePath(module, file))) || !relativePath.contains("/")) {
            return "/";
        }
        String string = relativePath.substring(relativePath.indexOf("/")) + "/";
        if (string == null) {
            RubyTestCreator.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static String getSuggestedTemplateName(@NotNull RElementWithFQN element, @Nullable String templateName) {
        if (element == null) {
            RubyTestCreator.$$$reportNull$$$0(19);
        }
        FQN fqn = RObjectClass.makeNonSingletonClassFqn((FQN)element.getFQNWithNesting());
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if ("Ruby File".equals(templateName)) {
            String string = NamingConventions.toUnderscoreCase((String)StringUtil.trimExtensions((String)fqn.getShortName()), (Module)module) + "_test";
            if (string == null) {
                RubyTestCreator.$$$reportNull$$$0(20);
            }
            return string;
        }
        String suffix = RubyTemplateNames.SPEC_TEMPLATES.contains(templateName) ? "" : "Test";
        String string = NamingConventions.toCamelCase((String)StringUtil.trimExtensions((String)fqn.getFullPath()), (Module)module) + suffix;
        if (string == null) {
            RubyTestCreator.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static List<VirtualFile> getTestSourceRoots(@NotNull Module module) {
        if (module == null) {
            RubyTestCreator.$$$reportNull$$$0(22);
        }
        List list = ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE);
        if (list == null) {
            RubyTestCreator.$$$reportNull$$$0(23);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 20, 21, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 14: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 18: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/actions/RubyTestCreator";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/actions/RubyTestCreator";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedRelativePath";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedTemplateName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestSourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTest";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findContextContainerAtCaret";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findElementAtCaret";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTemplateName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOrChooseDirectory";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedRelativePath";
                break;
            }
            case 18: 
            case 20: 
            case 21: 
            case 23: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedTemplateName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTestSourceRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 20, 21, 23 -> new IllegalStateException(string);
        };
    }

    @VisibleForTesting
    public static class MyFileCreator
    implements CreateFileFromTemplateDialog.FileCreator<PsiFile> {
        private final Project myProject;
        private final PsiDirectory myTargetDirectory;
        private final String myTargetPath;

        @VisibleForTesting
        public MyFileCreator(@NotNull Project project, @NotNull PsiDirectory targetDirectory, @NotNull String targetPath) {
            if (project == null) {
                MyFileCreator.$$$reportNull$$$0(0);
            }
            if (targetDirectory == null) {
                MyFileCreator.$$$reportNull$$$0(1);
            }
            if (targetPath == null) {
                MyFileCreator.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myTargetDirectory = targetDirectory;
            this.myTargetPath = targetPath;
        }

        @Nullable
        public PsiFile createFile(@NotNull String name, @NotNull String templateName) {
            if (name == null) {
                MyFileCreator.$$$reportNull$$$0(3);
            }
            if (templateName == null) {
                MyFileCreator.$$$reportNull$$$0(4);
            }
            CreateFileAction.MkDirs mkdirs = new CreateFileAction.MkDirs(this.myTargetPath + name, this.myTargetDirectory);
            PsiDirectory targetDirectory = mkdirs.directory;
            FileTemplate template = FileTemplateManager.getInstance((Project)this.myProject).getInternalTemplate(templateName);
            return RubyCreateFileFromTemplateAction.createFileFromTemplate(template, name, targetDirectory, "DefaultRubyCreateTestTemplate");
        }

        public boolean startInWriteAction() {
            return true;
        }

        @NotNull
        public String getActionName(@NotNull String name, @NotNull String templateName) {
            if (name == null) {
                MyFileCreator.$$$reportNull$$$0(5);
            }
            if (templateName == null) {
                MyFileCreator.$$$reportNull$$$0(6);
            }
            String string = RBundle.message((String)"ruby.action.create.new.test.name", (Object[])new Object[]{name});
            if (string == null) {
                MyFileCreator.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetDirectory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetPath";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateName";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/testing/actions/RubyTestCreator$MyFileCreator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/testing/actions/RubyTestCreator$MyFileCreator";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createFile";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionName";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7 -> new IllegalStateException(string);
            };
        }
    }
}

