/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.actions;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.templates.RubyCreateFileFromTemplateAction;
import org.jetbrains.plugins.ruby.statistic.RubyCreateFileFromTemplateCollector;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

public final class RubyCreateTestAction
extends RubyCreateFileFromTemplateAction {
    public static final String DEFAULT_RUBY_CREATE_TEST_TEMPLATE_KEY = "DefaultRubyCreateTestTemplate";
    private static final InputValidatorEx VALIDATOR = new InputValidatorEx(){

        @Nullable
        public String getErrorText(String input) {
            return !TextUtil.isCIDOrColonQualifiedReference((String)input) ? RBundle.message((String)"ruby.action.create.new.class.file.dialog.invalid.name") : null;
        }

        public boolean checkInput(String input) {
            return true;
        }

        public boolean canClose(String input) {
            return StringUtil.isNotEmpty((String)input) && this.getErrorText(input) == null;
        }
    };

    @VisibleForTesting
    public PsiFile createFile(String name, String templateName, PsiDirectory dir) {
        return super.createFile(name, templateName, dir);
    }

    protected void buildDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull CreateFileFromTemplateDialog.Builder builder2) {
        if (project == null) {
            RubyCreateTestAction.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            RubyCreateTestAction.$$$reportNull$$$0(1);
        }
        if (builder2 == null) {
            RubyCreateTestAction.$$$reportNull$$$0(2);
        }
        builder2.setTitle(RBundle.message((String)"ruby.action.create.new.test.dialog.title")).setValidator((InputValidator)VALIDATOR);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)directory);
        builder2.addKind(RBundle.message((String)"ruby.action.create.new.test.dialog.kind.minitest"), RubyIcons.TestUnit.TestUnitFile, "Minitest").addKind(RBundle.message((String)"ruby.action.create.new.test.dialog.kind.minitestSpec"), RubyIcons.Rspec.RspecTest, "Minitest Spec");
        if (module == null || RSpecUtil.isRSpecSupportEnabled(module)) {
            builder2.addKind(RBundle.message((String)"ruby.action.create.new.test.dialog.kind.rspec"), RubyIcons.Rspec.RspecTest, "RSpec");
        }
        if (module == null || TestUnitUtil.isTestUnitSupportEnabled(module)) {
            builder2.addKind(RBundle.message((String)"ruby.action.create.new.test.dialog.kind.testUnit"), RubyIcons.TestUnit.TestUnitFile, "TestUnit");
        }
    }

    @Nullable
    protected PsiFile createFileFromTemplate(String name, FileTemplate template, PsiDirectory dir) {
        RubyCreateFileFromTemplateCollector.logCreatedEvent(template);
        return RubyCreateTestAction.createFileFromTemplate(template, name, dir, this.getDefaultTemplateProperty());
    }

    protected String getActionName(PsiDirectory directory, @NotNull String newName, String templateName) {
        if (newName == null) {
            RubyCreateTestAction.$$$reportNull$$$0(3);
        }
        return RBundle.message((String)"ruby.action.create.new.test.name", (Object[])new Object[]{newName});
    }

    @NotNull
    protected String getDefaultTemplateProperty() {
        return DEFAULT_RUBY_CREATE_TEST_TEMPLATE_KEY;
    }

    @Override
    protected boolean isAvailable(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RubyCreateTestAction.$$$reportNull$$$0(4);
        }
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        IdeView view = (IdeView)dataContext.getData(LangDataKeys.IDE_VIEW);
        assert (project != null && view != null);
        return ContainerUtil.exists((Object[])view.getDirectories(), directory -> TestSourcesFilter.isTestSources((VirtualFile)directory.getVirtualFile(), (Project)project));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/testing/actions/RubyCreateTestAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

