/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing;

import com.google.common.collect.ImmutableSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.EmptyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeRegistry;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.shoulda.ShouldaUtil;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

final class TestsDSLCallTypeProvider
implements RubyCallTypeProvider {
    private static final Set<String> GROUP_CALL_NAMES = ImmutableSet.builder().add((Object[])ShouldaUtil.GROUP_CALLS_SHORT_NAMES).addAll(TestUnitUtil.MINITEST_SPEC_GROUP_CALL_SHORT_NAMES).addAll(RSpecUtil.CLASS_CONTEXT_CALLS_WITHOUT_SHARED).build();
    private static final Set<String> LEAF_CALL_NAMES = ImmutableSet.builder().addAll(ShouldaUtil.TEST_SETUP_TEARDOWN_CALLS_SHORT_NAMES).addAll(TestUnitUtil.TEST_SETUP_TEARDOWN_CALLS_SHORT_NAMES).addAll(TestUnitUtil.MINITEST_INSTANCE_CONTEXT_CALLS_SHORT_NAMES).addAll(RSpecUtil.INSTANCE_CONTEXT_CALLS).build();
    private static final Set<String> IGNORED_CALL_NAMES = ImmutableSet.builder().add((Object[])new String[]{"let", "let!", "subject", "subject!", "test", "setup", "teardown", "define_method"}).addAll(RSpecUtil.CALL_SHARED_EXAMPLE_GROUP_NAMES).addAll(RSpecUtil.CALL_SHARED_EXAMPLE_GROUP_REF_NAMES).build();

    TestsDSLCallTypeProvider() {
    }

    public void registerCallTypes(@NotNull RubyCallTypeRegistry registry) {
        if (registry == null) {
            TestsDSLCallTypeProvider.$$$reportNull$$$0(0);
        }
        for (String shortName : GROUP_CALL_NAMES) {
            registry.registerCallType((RubyCallType)new EmptyCallType(shortName){

                public boolean isClosureStatementsInsideCodeBlock() {
                    return false;
                }
            });
        }
        for (String shortName : ContainerUtil.filter(LEAF_CALL_NAMES, name -> !IGNORED_CALL_NAMES.contains(name))) {
            registry.registerCallType((RubyCallType)new EmptyCallType(shortName));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registry", "org/jetbrains/plugins/ruby/testing/TestsDSLCallTypeProvider", "registerCallTypes"));
    }
}

