/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;

public final class RubyTestFrameworksUtil {
    public static final Predicate<? super VirtualFile> TRUE = file -> true;

    public static boolean containsSpecFiles(@NotNull PsiDirectory directory) {
        if (directory == null) {
            RubyTestFrameworksUtil.$$$reportNull$$$0(0);
        }
        return RubyTestFrameworksUtil.containsFiles(directory, file -> file.getName().endsWith("_spec.rb"));
    }

    public static boolean containsMinitestFiles(@NotNull PsiDirectory directory) {
        if (directory == null) {
            RubyTestFrameworksUtil.$$$reportNull$$$0(1);
        }
        return RubyTestFrameworksUtil.containsFiles(directory, file -> file.getName().startsWith("test_") || file.getName().endsWith("_test.rb") || file.getName().endsWith("_spec.rb"));
    }

    private static boolean containsFiles(@NotNull PsiDirectory directory, VirtualFileFilter filter) {
        if (directory == null) {
            RubyTestFrameworksUtil.$$$reportNull$$$0(2);
        }
        return !FileTypeIndex.processFiles((FileType)RubyFileType.RUBY, file -> !filter.accept(file), (GlobalSearchScope)GlobalSearchScopesCore.directoryScope((Project)directory.getProject(), (VirtualFile)directory.getVirtualFile(), (boolean)true));
    }

    @NotNull
    public static @NotNull PsiElement @NotNull [] getPsiElementArray(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RubyTestFrameworksUtil.$$$reportNull$$$0(3);
        }
        PsiElement[] psiElementArray = (PsiElement[])ObjectUtils.chooseNotNull((Object)((PsiElement[])PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext)), (Object)PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            RubyTestFrameworksUtil.$$$reportNull$$$0(4);
        }
        return psiElementArray;
    }

    @NotNull
    public static List<VirtualFile> getAndFlattenAllSelectedFiles(@NotNull DataContext dataContext, @NotNull Condition<? super VirtualFile> filter) {
        if (dataContext == null) {
            RubyTestFrameworksUtil.$$$reportNull$$$0(5);
        }
        if (filter == null) {
            RubyTestFrameworksUtil.$$$reportNull$$$0(6);
        }
        PsiElement[] elements = RubyTestFrameworksUtil.getPsiElementArray(dataContext);
        return RubyTestFrameworksUtil.flattenAllSelectedFiles(elements, filter);
    }

    @NotNull
    public static List<VirtualFile> flattenAllSelectedFiles(@NotNull @NotNull PsiElement @NotNull [] elements) {
        if (elements == null) {
            RubyTestFrameworksUtil.$$$reportNull$$$0(7);
        }
        return RubyTestFrameworksUtil.flattenAllSelectedFiles(elements, (Condition<? super VirtualFile>)Conditions.alwaysTrue());
    }

    @NotNull
    public static List<VirtualFile> flattenAllSelectedFiles(@NotNull @NotNull PsiElement @NotNull [] elements, @NotNull Condition<? super VirtualFile> filter) {
        if (filter == null) {
            RubyTestFrameworksUtil.$$$reportNull$$$0(8);
        }
        if (elements == null) {
            RubyTestFrameworksUtil.$$$reportNull$$$0(9);
        }
        List list = ContainerUtil.flatMap(List.of(elements), psi -> {
            if (psi instanceof PsiDirectory) {
                Object[] children = ((PsiDirectory)psi).getVirtualFile().getChildren();
                return ContainerUtil.filter((Object[])children, (Condition)filter);
            }
            VirtualFile file = RubyTestFrameworksUtil.getVirtualFile(psi);
            return file != null && filter.value((Object)file) ? List.of(file) : List.of();
        });
        if (list == null) {
            RubyTestFrameworksUtil.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull PsiElement psi) {
        if (psi == null) {
            RubyTestFrameworksUtil.$$$reportNull$$$0(11);
        }
        if (psi instanceof PsiFile) {
            return ((PsiFile)psi).getVirtualFile();
        }
        PsiFile file = psi.getContainingFile();
        return file != null ? file.getVirtualFile() : null;
    }

    @NotNull
    public static String createConfName(@NotNull List<VirtualFile> files) {
        if (files == null) {
            RubyTestFrameworksUtil.$$$reportNull$$$0(12);
        }
        if (files.size() == 1) {
            String string = files.get(0).getName();
            if (string == null) {
                RubyTestFrameworksUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = RBundle.message((String)"run.configuration.tests.producer.more.files", (Object[])new Object[]{files.get(0).getNameWithoutExtension(), files.size() - 1});
        if (string == null) {
            RubyTestFrameworksUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 10, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/RubyTestFrameworksUtil";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/RubyTestFrameworksUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElementArray";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenAllSelectedFiles";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "containsSpecFiles";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "containsMinitestFiles";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementArray";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAndFlattenAllSelectedFiles";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "flattenAllSelectedFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createConfName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 10, 13, 14 -> new IllegalStateException(string);
        };
    }
}

