/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.cucumberApi.RubyCucumberUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.LoadPathUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RequireInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFileUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.testing.RubyTestFramework;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.shoulda.ShouldaUtil;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

public final class RubyTestFrameworkDetector {
    private static final String RSPEC_OBJECT_RECEIVER = "RSpec";
    private static final String MINITEST = "minitest";
    private static final String RSPEC = "rspec";
    private static final Set<String> RSPEC_INDICATOR_CALLS = Set.of("to", "not_to", "to_not");
    private static final Set<String> MINITEST_INDICATOR_CALLS = Set.of("must", "wont");
    private static final String SPEC_HELPER_SUFFIX = "spec_helper";
    private static final String RAILS_HELPER_SUFFIX = "rails_helper";
    private static final String TEST_HELPER_SUFFIX = "test_helper";
    private static final String SPEC_DIRECTORY = "/spec/";
    private static final String TEST_DIRECTORY = "/test/";
    private static final String[] HELPER_FILE_NAMES = new String[]{"spec_helper.rb", "rails_helper.rb", "test_helper.rb"};

    private RubyTestFrameworkDetector() {
    }

    @NotNull
    public static Result detectFrameworkForFile(@NotNull RFile file) {
        if (file == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(0);
        }
        Result result = (Result)((Object)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            Result candidate = RubyTestFrameworkDetector.getResultByFile(file);
            if (candidate != Result.UNSURE) {
                return CachedValueProvider.Result.create((Object)((Object)candidate), (Object[])new Object[]{file});
            }
            candidate = RubyTestFrameworkDetector.getResultByTopLevelRSpecCall(file);
            if (candidate != Result.UNSURE) {
                return CachedValueProvider.Result.create((Object)((Object)candidate), (Object[])new Object[]{file});
            }
            return CachedValueProvider.Result.create((Object)((Object)RubyTestFrameworkDetector.getResultByDSLCalls(file)), (Object[])new Object[]{file});
        }));
        if (result == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(1);
        }
        return result;
    }

    public static Result detectFrameworkForFolder(@NotNull PsiDirectory folder) {
        Project project;
        VirtualFile sourceRoot;
        RFile specHelper;
        if (folder == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(2);
        }
        if ((specHelper = RubyTestFrameworkDetector.getSpecHelper(folder, sourceRoot = ProjectRootManager.getInstance((Project)(project = folder.getProject())).getFileIndex().getContentRootForFile(folder.getVirtualFile()))) != null) {
            return RubyTestFrameworkDetector.getResultByRequire(specHelper);
        }
        return Result.UNSURE;
    }

    @Nullable
    public static RubyTestFramework determineMostSuitableFrameworkForTests(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(3);
        }
        if ((module = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)element))) == null) {
            return null;
        }
        Collection relatedTests = (Collection)ReadAction.compute(() -> TestFinderHelper.findTestsForClass((PsiElement)element));
        RubyTestFramework candidate = RubyTestFrameworkDetector.getPossibleTestFrameworks(relatedTests, module).stream().min(RubyTestFramework.PRIORITY_COMPARATOR).orElse(null);
        if (candidate != null) {
            return candidate;
        }
        return RubyTestFrameworkDetector.getTestFrameworkWithMostPriority(module);
    }

    @Nullable
    private static RubyTestFramework getTestFrameworkWithMostPriority(@NotNull Module module) {
        if (module == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(4);
        }
        EnumSet<RubyTestFramework> candidates = EnumSet.noneOf(RubyTestFramework.class);
        for (RubyTestFramework framework : RubyTestFramework.values()) {
            if (RubyProjectGemSearchService.Companion.findGem(module, framework.getGemName()) == null) continue;
            candidates.add(framework);
        }
        if (!candidates.isEmpty()) {
            return candidates.stream().min(RubyTestFramework.PRIORITY_COMPARATOR).get();
        }
        return null;
    }

    @NotNull
    private static Set<RubyTestFramework> getPossibleTestFrameworks(@NotNull Collection<PsiElement> relatedTests, @NotNull Module module) {
        if (relatedTests == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(5);
        }
        if (module == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(6);
        }
        EnumSet<RubyTestFramework> possibleTestFrameworks = EnumSet.noneOf(RubyTestFramework.class);
        block0: for (RubyTestFramework testFramework : RubyTestFramework.values()) {
            for (PsiElement test : relatedTests) {
                VirtualFile testFile = test.getContainingFile().getVirtualFile();
                if (!((Boolean)ReadAction.compute(() -> RubyTestFrameworkDetector.isFileUseSupportedTestFramework(testFile, module, testFramework))).booleanValue()) continue;
                possibleTestFrameworks.add(testFramework);
                continue block0;
            }
        }
        EnumSet<RubyTestFramework> enumSet = possibleTestFrameworks;
        if (enumSet == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(7);
        }
        return enumSet;
    }

    private static boolean isFileUseSupportedTestFramework(@NotNull VirtualFile testFile, @NotNull Module module, @NotNull RubyTestFramework testFramework) {
        if (testFile == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(8);
        }
        if (module == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(9);
        }
        if (testFramework == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(10);
        }
        Project project = module.getProject();
        return switch (testFramework) {
            default -> throw new IncompatibleClassChangeError();
            case RubyTestFramework.RSPEC -> RSpecUtil.isRSpecTestFile(project, testFile);
            case RubyTestFramework.MINITEST -> {
                if (TestUnitUtil.isFileWithValidMinitestFileName(testFile) && RubyProjectGemSearchService.Companion.findGem(module, MINITEST) != null) {
                    yield true;
                }
                yield false;
            }
            case RubyTestFramework.TEST_UNIT -> TestUnitUtil.isTestUnitFile(project, testFile);
            case RubyTestFramework.CUCUMBER -> {
                if (RubyCucumberUtil.isStepDefinitionLikeFile(testFile) && RubyCucumberUtil.isCucumberSupportEnabled(module)) {
                    yield true;
                }
                yield false;
            }
            case RubyTestFramework.SHOULDA -> ShouldaUtil.isShouldaTestFile(testFile, module);
        };
    }

    private static RFile getSpecHelper(@Nullable PsiDirectory folder, @Nullable VirtualFile sourceRoot) {
        if (folder == null) {
            return null;
        }
        for (PsiFile file : folder.getFiles()) {
            if (!(file instanceof RFile) || !ArrayUtil.contains((String)file.getName(), (String[])HELPER_FILE_NAMES)) continue;
            return (RFile)file;
        }
        if (sourceRoot != null && VfsUtilCore.isAncestor((VirtualFile)sourceRoot, (VirtualFile)folder.getVirtualFile(), (boolean)true)) {
            return RubyTestFrameworkDetector.getSpecHelper(folder.getParent(), sourceRoot);
        }
        return null;
    }

    @NotNull
    private static Result getResultByDSLCalls(@NotNull RFile file) {
        if (file == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(11);
        }
        final int[] rspecVsMinitest = new int[2];
        file.acceptChildren((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (rspecVsMinitest[0] + rspecVsMinitest[1] >= 20) {
                    return;
                }
                super.visitElement(element);
            }

            public void visitRDotReference(@NotNull RDotReference rDotReference) {
                String name;
                if (rDotReference == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((name = rDotReference.getCommand()) != null) {
                    if (name.length() >= 4 && MINITEST_INDICATOR_CALLS.contains(name.substring(0, 4))) {
                        rspecVsMinitest[1] = rspecVsMinitest[1] + 1;
                    } else if (RSPEC_INDICATOR_CALLS.contains(name)) {
                        rspecVsMinitest[0] = rspecVsMinitest[0] + 1;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rDotReference";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/RubyTestFrameworkDetector$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRDotReference";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (Math.min(rspecVsMinitest[0], rspecVsMinitest[1]) * 3 >= Math.max(rspecVsMinitest[0], rspecVsMinitest[1])) {
            Result result = Result.UNSURE;
            if (result == null) {
                RubyTestFrameworkDetector.$$$reportNull$$$0(12);
            }
            return result;
        }
        Result result = rspecVsMinitest[0] > rspecVsMinitest[1] ? Result.RSPEC : Result.MINITEST;
        if (result == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(13);
        }
        return result;
    }

    @NotNull
    private static Result getResultByFile(@NotNull RFile file) {
        if (file == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(14);
        }
        List<RequireInfo> requires = RFileUtil.computeRequires(file);
        VirtualFile parentDirectory = (VirtualFile)ObjectUtils.doIfNotNull((Object)RubyPsiUtil.getVirtualFileFromElement((PsiElement)file), VirtualFile::getParent);
        Object2IntMap<VirtualFile> loadPath = RFileUtil.createMapByLoadpath(LoadPathUtil.getLoadPath((RTopLevelContainer)file));
        for (RequireInfo ri : requires) {
            Collection<? extends VirtualFile> testHelperFiles;
            if (ri.getPath().endsWith(TEST_HELPER_SUFFIX) && ContainerUtil.all(testHelperFiles = RFileUtil.findFilesForName(file.getProject(), ri.getPath(), loadPath, parentDirectory, ri.isRelative(), null), it -> RubyTestFrameworkDetector.isFileUnderRailsTestDirectory(it, file.getProject()))) {
                Result result = Result.MINITEST;
                if (result == null) {
                    RubyTestFrameworkDetector.$$$reportNull$$$0(15);
                }
                return result;
            }
            if (!ri.getPath().endsWith(SPEC_HELPER_SUFFIX) && !ri.getPath().endsWith(RAILS_HELPER_SUFFIX)) continue;
            Collection<? extends VirtualFile> specHelperFiles = RFileUtil.findFilesForName(file.getProject(), ri.getPath(), loadPath, parentDirectory, ri.isRelative(), null);
            for (VirtualFile virtualFile : specHelperFiles) {
                Result result;
                PsiFile rspecHelperPsiFile = file.getManager().findFile(virtualFile);
                if (!(rspecHelperPsiFile instanceof RFile) || (result = RubyTestFrameworkDetector.getResultByRequire((RFile)rspecHelperPsiFile)) == Result.UNSURE) continue;
                Result result2 = result;
                if (result2 == null) {
                    RubyTestFrameworkDetector.$$$reportNull$$$0(16);
                }
                return result2;
            }
        }
        Result result = RubyTestFrameworkDetector.getResultByRequire(file);
        if (result == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(17);
        }
        return result;
    }

    private static Result getResultByRequire(@NotNull RFile file) {
        if (file == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(18);
        }
        List<RequireInfo> requires = RFileUtil.computeRequires(file);
        boolean minitestFound = ContainerUtil.exists(requires, info -> info.getPath().contains(MINITEST));
        boolean rspecFound = ContainerUtil.exists(requires, info -> info.getPath().contains(RSPEC));
        if (minitestFound && rspecFound || !minitestFound && !rspecFound) {
            return RubyTestFrameworkDetector.getResultByTopLevelRSpecCall(file);
        }
        if (minitestFound) {
            return Result.MINITEST;
        }
        return Result.RSPEC;
    }

    @NotNull
    private static Result getResultByTopLevelRSpecCall(@NotNull RFile file) {
        if (file == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(19);
        }
        if (ContainerUtil.exists((Iterable)file.getStatements(), element -> {
            if (!(element instanceof RBlockCall)) {
                return false;
            }
            RPsiElement receiver = ((RBlockCall)element).getCall().getReceiver();
            return receiver != null && receiver.getText().equals(RSPEC_OBJECT_RECEIVER);
        })) {
            Result result = Result.RSPEC;
            if (result == null) {
                RubyTestFrameworkDetector.$$$reportNull$$$0(20);
            }
            return result;
        }
        Result result = Result.UNSURE;
        if (result == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(21);
        }
        return result;
    }

    private static boolean isFileUnderRailsTestDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(22);
        }
        if (project == null) {
            RubyTestFrameworkDetector.$$$reportNull$$$0(23);
        }
        if (!file.getPath().contains(TEST_DIRECTORY) || file.getPath().contains(SPEC_DIRECTORY)) {
            return false;
        }
        StandardRailsPaths paths = (StandardRailsPaths)ObjectUtils.doIfNotNull((Object)ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project), RailsFacetUtil::getRailsAppStaticPaths);
        String specFolderUrl = (String)ObjectUtils.doIfNotNull((Object)paths, path -> RSpecUtil.getRailsSpecFolderPathOrUrl(path.getRailsApplicationHomeURL()));
        VirtualFile specFolder = (VirtualFile)ObjectUtils.doIfNotNull((Object)specFolderUrl, arg_0 -> ((VirtualFileManager)VirtualFileManager.getInstance()).findFileByUrl(arg_0));
        String testFolderUrl = (String)ObjectUtils.doIfNotNull((Object)paths, path -> TestUnitUtil.getRailsTestFolderPathOrUrl(path.getRailsApplicationHomeURL()));
        VirtualFile testFolder = (VirtualFile)ObjectUtils.doIfNotNull((Object)testFolderUrl, arg_0 -> ((VirtualFileManager)VirtualFileManager.getInstance()).findFileByUrl(arg_0));
        return testFolder != null && VfsUtilCore.isAncestor((VirtualFile)testFolder, (VirtualFile)file, (boolean)true) && (specFolder == null || !VfsUtilCore.isAncestor((VirtualFile)specFolder, (VirtualFile)file, (boolean)true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 12, 13, 15, 16, 17, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 7: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/RubyTestFrameworkDetector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relatedTests";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFramework";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/RubyTestFrameworkDetector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFrameworkForFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleTestFrameworks";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultByDSLCalls";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultByFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultByTopLevelRSpecCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectFrameworkForFile";
                break;
            }
            case 1: 
            case 7: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "detectFrameworkForFolder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "determineMostSuitableFrameworkForTests";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTestFrameworkWithMostPriority";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleTestFrameworks";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isFileUseSupportedTestFramework";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getResultByDSLCalls";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getResultByFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getResultByRequire";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getResultByTopLevelRSpecCall";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isFileUnderRailsTestDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 12, 13, 15, 16, 17, 20, 21 -> new IllegalStateException(string);
        };
    }

    public static enum Result {
        RSPEC,
        MINITEST,
        UNSURE;

    }
}

