/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RPsiPolyVariantReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.SymbolResolveResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.ConstantStringInferenceResultImpl;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;

public final class BddTestsUtil {
    @NonNls
    public static final String SPEC_TEST_FILE_SUFFIX = "_spec.rb";

    private BddTestsUtil() {
    }

    public static boolean isFileWithSpecTestFileName(@Nullable VirtualFile file) {
        return file != null && !file.isDirectory() && file.getName().endsWith(SPEC_TEST_FILE_SUFFIX);
    }

    public static boolean gatherGroupsAndExampleNames(@NotNull PsiElement psiElement, @NotNull GroupNameBuilder groupNameBuilder, @NotNull ExampleNameBuilder exampleNameBuilder) {
        if (psiElement == null) {
            BddTestsUtil.$$$reportNull$$$0(0);
        }
        if (groupNameBuilder == null) {
            BddTestsUtil.$$$reportNull$$$0(1);
        }
        if (exampleNameBuilder == null) {
            BddTestsUtil.$$$reportNull$$$0(2);
        }
        return RubyPsiUtil.interpretCallsOnPathFromElement(psiElement, groupNameBuilder, exampleNameBuilder);
    }

    @NotNull
    public static List<String> collectExampleNamesWithSubstitutions(@Nullable RStringLiteral stringArgument) {
        List list = ConstantStringInferenceResultImpl.getStringRepresentation((PsiElement)stringArgument).getAllStrings();
        if (list == null) {
            BddTestsUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupNameBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exampleNameBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/BddTestsUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/BddTestsUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExampleNamesWithSubstitutions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "gatherGroupsAndExampleNames";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static interface ActivePsiCallable {
        public void register(@NotNull RubyPsiInterpreter var1);
    }

    public static class ExampleNameBuilder
    implements ActivePsiCallable,
    PsiCallable {
        private final String @NotNull [] myExampleCallsFqns;
        @Nullable
        protected String myExampleShortName;
        @NotNull
        protected List<String> myExampleShortNamesWithSubstitutions;

        public ExampleNameBuilder(String @NotNull [] exampleCallsFqns) {
            if (exampleCallsFqns == null) {
                ExampleNameBuilder.$$$reportNull$$$0(0);
            }
            this.myExampleShortNamesWithSubstitutions = new ArrayList<String>();
            this.myExampleCallsFqns = exampleCallsFqns;
        }

        @Override
        public void register(@NotNull RubyPsiInterpreter interpreter) {
            if (interpreter == null) {
                ExampleNameBuilder.$$$reportNull$$$0(1);
            }
            interpreter.registerCallable(this, this.myExampleCallsFqns);
        }

        @Override
        public void processCall(@NotNull RCallArguments arguments) {
            if (arguments == null) {
                ExampleNameBuilder.$$$reportNull$$$0(2);
            }
            RStringLiteral stringArgument = (RStringLiteral)ObjectUtils.tryCast((Object)ContainerUtil.getFirstItem(arguments.getArguments()), RStringLiteral.class);
            this.myExampleShortNamesWithSubstitutions.addAll(BddTestsUtil.collectExampleNamesWithSubstitutions(stringArgument));
            String firstArg = arguments.evaluateArgument(0);
            if (firstArg != null) {
                this.myExampleShortName = firstArg;
            }
        }

        @Nullable
        public String getExampleShortName() {
            return this.myExampleShortName;
        }

        @NotNull
        public List<String> getExampleShortNamesWithSubstitutions() {
            List<String> list = this.myExampleShortNamesWithSubstitutions;
            if (list == null) {
                ExampleNameBuilder.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exampleCallsFqns";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/testing/BddTestsUtil$ExampleNameBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/testing/BddTestsUtil$ExampleNameBuilder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExampleShortNamesWithSubstitutions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "register";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "processCall";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class GroupNameBuilder
    implements ActivePsiCallable,
    PsiCallable {
        @NotNull
        private final List<RPsiElement> myPartsInReversedOrder;
        final String @NotNull [] myExampleCallsFqns;

        public GroupNameBuilder(String @NotNull [] exampleCallsFqns) {
            if (exampleCallsFqns == null) {
                GroupNameBuilder.$$$reportNull$$$0(0);
            }
            this.myPartsInReversedOrder = new ArrayList<RPsiElement>();
            this.myExampleCallsFqns = exampleCallsFqns;
        }

        @Override
        public final void processCall(@NotNull RCallArguments arguments) {
            if (arguments == null) {
                GroupNameBuilder.$$$reportNull$$$0(1);
            }
            List<RPsiElement> argsList = arguments.getArguments();
            ArrayList<RPsiElement> filteredArgs = new ArrayList<RPsiElement>();
            for (RPsiElement argument : argsList) {
                if (argument instanceof RAssocList || argument instanceof RAssoc || !filteredArgs.isEmpty() && argument instanceof RSymbol) continue;
                filteredArgs.add(argument);
            }
            this.myPartsInReversedOrder.addAll(ContainerUtil.reverse(filteredArgs));
        }

        @NotNull
        protected final List<? extends RPsiElement> getPartsInReversedOrder() {
            List<RPsiElement> list = this.myPartsInReversedOrder;
            if (list == null) {
                GroupNameBuilder.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        public final void register(@NotNull RubyPsiInterpreter interpreter) {
            if (interpreter == null) {
                GroupNameBuilder.$$$reportNull$$$0(3);
            }
            interpreter.registerCallable(this, this.myExampleCallsFqns);
        }

        @Nullable
        protected static String getArgText(@NotNull RPsiElement argument) {
            if (argument == null) {
                GroupNameBuilder.$$$reportNull$$$0(4);
            }
            if (argument instanceof RReference || argument instanceof RTopConstReference || argument instanceof RConstant) {
                RPsiPolyVariantReference rubyReference;
                SymbolResolveResult resolveResult;
                PsiReference psiReference = argument.getReference();
                if (psiReference instanceof RPsiPolyVariantReference && (resolveResult = (rubyReference = (RPsiPolyVariantReference)psiReference).resolveToSymbol()).isValidResult()) {
                    return resolveResult.getSymbol().getFQNWithNesting().getFullPath();
                }
                return argument.getText().replaceAll("\\s+", "");
            }
            return RubyPsiUtilCore.getElementText((PsiElement)argument);
        }

        @NotNull
        public abstract String getFullGroupName();

        @NotNull
        public List<String> getFullGroupNamesWithSubstitutions() {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GroupNameBuilder.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exampleCallsFqns";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/testing/BddTestsUtil$GroupNameBuilder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreter";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/testing/BddTestsUtil$GroupNameBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPartsInReversedOrder";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullGroupNamesWithSubstitutions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "processCall";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "register";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getArgText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5 -> new IllegalStateException(string);
            };
        }
    }
}

