/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake.task.special;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.database.MigrationParser;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.tasks.OptionTraceConfigurationParams;
import org.jetbrains.plugins.ruby.tasks.capistrano.CapistranoUtil;
import org.jetbrains.plugins.ruby.tasks.capistrano.actions.CapistranoStagedActionPanel;
import org.jetbrains.plugins.ruby.tasks.capistrano.run.configuration.CapistranoRunConfigurationParams;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfiguration;
import org.jetbrains.plugins.ruby.tasks.rake.task.special.TaskWithVersionPanel;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public final class TaskUIUtil {
    static final Logger LOG = Logger.getInstance(TaskWithVersionPanel.class);

    private TaskUIUtil() {
    }

    public static void setStageFromRunConfiguration(AbstractRubyRunConfiguration configuration, JComboBox combobox) {
        if (configuration instanceof CapistranoRunConfigurationParams) {
            String stage = ((CapistranoRunConfigurationParams)((Object)configuration)).getStage();
            if (stage != null) {
                combobox.setSelectedItem(stage);
            } else {
                combobox.setSelectedItem(CapistranoStagedActionPanel.getDefaultStage());
            }
        }
    }

    @NlsContexts.ListItem
    public static String getLatestMigrationItem() {
        return RBundle.message((String)"rails.db.version.latest.migration");
    }

    public static void applyMigrationVersionInfo(@NotNull Map<String, String> envs, @Nullable JComboBox railsDBVersionCB) {
        String itemText;
        if (envs == null) {
            TaskUIUtil.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)(itemText = (String)ObjectUtils.doIfNotNull((Object)ObjectUtils.doIfNotNull((Object)railsDBVersionCB, JComboBox::getSelectedItem), Object::toString))) || itemText.equals(TaskUIUtil.getLatestMigrationItem())) {
            envs.remove("VERSION");
            return;
        }
        int migrationSeparator = itemText.indexOf(95);
        LOG.assertTrue(migrationSeparator > 0, (Object)itemText);
        envs.put("VERSION", itemText.substring(0, migrationSeparator));
    }

    public static void applyMigrationStepInfo(@NotNull Map<String, String> envs, @Nullable JTextField railsDBStepTF) {
        String itemText;
        if (envs == null) {
            TaskUIUtil.$$$reportNull$$$0(1);
        }
        String string = itemText = railsDBStepTF == null ? null : railsDBStepTF.getText();
        if (StringUtil.isEmpty((String)itemText)) {
            envs.remove("STEP");
            return;
        }
        envs.put("STEP", itemText);
    }

    public static void applyTaskEnvironmentInfo(Map<String, String> envs, JComboBox railsEnvironmentCB) {
        Object item = railsEnvironmentCB.getSelectedItem();
        if (!"Default".equals(item)) {
            envs.put("RAILS_ENV", (String)item);
        } else {
            envs.remove("RAILS_ENV");
        }
    }

    public static void applyTaskStageInfo(CapistranoRunConfigurationParams config, JComboBox stagesCB) {
        Object item = stagesCB.getSelectedItem();
        config.setStage(CapistranoStagedActionPanel.getDefaultStage().equals(item) ? null : (String)item);
    }

    public static void applyTraceOptionInfo(@NotNull OptionTraceConfigurationParams conf, @NotNull JCheckBox enableTraceCB) {
        if (conf == null) {
            TaskUIUtil.$$$reportNull$$$0(2);
        }
        if (enableTraceCB == null) {
            TaskUIUtil.$$$reportNull$$$0(3);
        }
        conf.setOptionTrace(enableTraceCB.isSelected());
    }

    public static void initTaskDescLabel_Component(@Nullable @NlsSafe String taskDescription, @NotNull JLabel taskDescLabel) {
        if (taskDescLabel == null) {
            TaskUIUtil.$$$reportNull$$$0(4);
        }
        if (!StringUtil.isEmpty((String)taskDescription)) {
            taskDescLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)StringUtil.escapeXmlEntities((String)taskDescription)));
        } else {
            taskDescLabel.setVisible(false);
        }
    }

    public static void initRailsEnvsCB_Component(@Nullable String taskFullCmd, @NotNull JComboBox railsEnvironmentCB, @Nullable Module module) {
        if (railsEnvironmentCB == null) {
            TaskUIUtil.$$$reportNull$$$0(5);
        }
        String[] envTypes = RailsUtil.getAllEnvironments(module);
        Object[] envs = new Object[envTypes.length + 1];
        envs[0] = "Default";
        System.arraycopy(envTypes, 0, envs, 1, envTypes.length);
        railsEnvironmentCB.setModel(new DefaultComboBoxModel<Object>(envs));
        String customizedRailsEnv = RailsUtil.getCustomizedRailsEnvironmentFor(taskFullCmd);
        railsEnvironmentCB.setSelectedItem(customizedRailsEnv == null ? "Default" : customizedRailsEnv);
    }

    @NotNull
    public static List<String> getStagesWithDefault(@NotNull Module module) {
        if (module == null) {
            TaskUIUtil.$$$reportNull$$$0(6);
        }
        List<String> stages = CapistranoUtil.getStages(module);
        stages.add(0, CapistranoStagedActionPanel.getDefaultStage());
        List<String> list = stages;
        if (list == null) {
            TaskUIUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static void initCapistranoStages_Component(@Nullable String taskName, @NotNull JComboBox capistranoStagesCB, @NotNull Module module) {
        List<String> stages;
        if (capistranoStagesCB == null) {
            TaskUIUtil.$$$reportNull$$$0(8);
        }
        if (module == null) {
            TaskUIUtil.$$$reportNull$$$0(9);
        }
        if (!(stages = TaskUIUtil.getStagesWithDefault(module)).isEmpty()) {
            capistranoStagesCB.setModel(new DefaultComboBoxModel<Object>(stages.toArray()));
        }
    }

    public static void initRailsDBVersionCB_Component(@NotNull Module module, @Nullable String fullCommand, @Nullable VirtualFile context, @NotNull JComboBox railsDBVersionCB) {
        if (module == null) {
            TaskUIUtil.$$$reportNull$$$0(10);
        }
        if (railsDBVersionCB == null) {
            TaskUIUtil.$$$reportNull$$$0(11);
        }
        ArrayList<String> items = new ArrayList<String>();
        items.add(TaskUIUtil.getLatestMigrationItem());
        for (VirtualFile migrationsRoot : RailsPaths.getInstance(module).findFiles("db/migrate")) {
            for (VirtualFile file : migrationsRoot.getChildren()) {
                if (!RubyVirtualFileScanner.isRubyFile(file) || !MigrationParser.matchesToMigrationFileNameTemplate(file)) continue;
                items.add(file.getName());
            }
        }
        Collections.sort(items);
        railsDBVersionCB.setModel(new DefaultComboBoxModel<String>(ArrayUtilRt.toStringArray(items)));
        railsDBVersionCB.setSelectedItem(TaskUIUtil.getLatestMigrationItem());
        if (!"db:migrate".equals(fullCommand) && context != null && MigrationParser.matchesToMigrationFileNameTemplate(context)) {
            VirtualFile parentFolder = context.getParent();
            assert (parentFolder != null);
            if (RailsPaths.getInstance(module).findFiles("db/migrate").contains(parentFolder)) {
                railsDBVersionCB.setSelectedItem(context.getName());
            }
        }
    }

    public static void initRailsDBStepTF_Component(@NotNull JTextField railsDBStepRF) {
        if (railsDBStepRF == null) {
            TaskUIUtil.$$$reportNull$$$0(12);
        }
        railsDBStepRF.setText("1");
    }

    public static void preselectVersionFromConfiguration(@NotNull RakeRunConfiguration configuration, @NotNull JComboBox railsDBVersionCB) {
        String version_number;
        if (configuration == null) {
            TaskUIUtil.$$$reportNull$$$0(13);
        }
        if (railsDBVersionCB == null) {
            TaskUIUtil.$$$reportNull$$$0(14);
        }
        if ((version_number = (String)configuration.getEnvs().get("VERSION")) != null) {
            int count = railsDBVersionCB.getItemCount();
            for (int i = 0; i < count; ++i) {
                Object item = railsDBVersionCB.getItemAt(i);
                String itemStr = item.toString();
                if (!itemStr.startsWith(version_number)) continue;
                railsDBVersionCB.setSelectedItem(item);
            }
        }
    }

    public static void preselectStepFromConfiguration(@NotNull RakeRunConfiguration configuration, @NotNull JTextField railsDBStepTF) {
        String version_number;
        if (configuration == null) {
            TaskUIUtil.$$$reportNull$$$0(15);
        }
        if (railsDBStepTF == null) {
            TaskUIUtil.$$$reportNull$$$0(16);
        }
        if ((version_number = (String)configuration.getEnvs().get("STEP")) != null) {
            railsDBStepTF.setText(version_number);
        }
    }

    public static void preselectVersionAndSetEnvironmentFrom(@NotNull RakeRunConfiguration configuration, @NotNull JComboBox railsDBVersionCB, @NotNull JComboBox railsEnvironmentCB) {
        if (configuration == null) {
            TaskUIUtil.$$$reportNull$$$0(17);
        }
        if (railsDBVersionCB == null) {
            TaskUIUtil.$$$reportNull$$$0(18);
        }
        if (railsEnvironmentCB == null) {
            TaskUIUtil.$$$reportNull$$$0(19);
        }
        TaskUIUtil.preselectVersionFromConfiguration(configuration, railsDBVersionCB);
        TaskUIUtil.setEnvFromRunConfiguration(configuration, railsEnvironmentCB);
    }

    public static void setEnvFromRunConfiguration(@NotNull RakeRunConfiguration configuration, @NotNull JComboBox railsEnvironmentCB) {
        String rails_env;
        if (configuration == null) {
            TaskUIUtil.$$$reportNull$$$0(20);
        }
        if (railsEnvironmentCB == null) {
            TaskUIUtil.$$$reportNull$$$0(21);
        }
        if ((rails_env = (String)configuration.getEnvs().get("RAILS_ENV")) != null) {
            try {
                railsEnvironmentCB.setSelectedItem(StringUtil.toLowerCase((String)rails_env));
            }
            catch (IllegalArgumentException e) {
                railsEnvironmentCB.setSelectedItem("Default");
            }
        } else {
            railsEnvironmentCB.setSelectedItem("Default");
        }
    }

    public static void setTraceOptionFromRunConfiguration(@NotNull OptionTraceConfigurationParams configuration, @NotNull JCheckBox enableTraceCB) {
        if (configuration == null) {
            TaskUIUtil.$$$reportNull$$$0(22);
        }
        if (enableTraceCB == null) {
            TaskUIUtil.$$$reportNull$$$0(23);
        }
        enableTraceCB.setSelected(configuration.isOptionTraceEnabled());
    }

    public static void setPanelSizeRestrictions(String taskDescription, JLabel taskDescPane, JPanel contentPane) {
        int length;
        int n = length = taskDescription == null ? 0 : taskDescription.length();
        if (length > 50) {
            int averageCharWidth = taskDescPane.getFontMetrics(taskDescPane.getFont()).charWidth('n');
            contentPane.setPreferredSize(new Dimension(50 * averageCharWidth + 20, -1));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 3: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enableTraceCB";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskDescLabel";
                break;
            }
            case 5: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsEnvironmentCB";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/rake/task/special/TaskUIUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capistranoStagesCB";
                break;
            }
            case 11: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsDBVersionCB";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsDBStepRF";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsDBStepTF";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/task/special/TaskUIUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStagesWithDefault";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyMigrationVersionInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyMigrationStepInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyTraceOptionInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initTaskDescLabel_Component";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initRailsEnvsCB_Component";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStagesWithDefault";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initCapistranoStages_Component";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "initRailsDBVersionCB_Component";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "initRailsDBStepTF_Component";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "preselectVersionFromConfiguration";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "preselectStepFromConfiguration";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "preselectVersionAndSetEnvironmentFrom";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setEnvFromRunConfiguration";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setTraceOptionFromRunConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

