/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.structure.RubyStructureViewModel;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtil;
import org.jetbrains.plugins.ruby.tasks.rake.structure.RakeStructureViewElement;

public class RakeStructureViewModel
extends RubyStructureViewModel {
    private static final Class<?>[] RAKE_SUITABLE_CLASSES = (Class[])Arrays.copyOf(SUITABLE_CLASSES, SUITABLE_CLASSES.length + 2, Class[].class);

    public RakeStructureViewModel(RFile psiFile, @Nullable Editor editor) {
        super(psiFile, editor);
    }

    @Override
    @NotNull
    public Collection<NodeProvider<?>> getNodeProviders() {
        List<NodeProvider<?>> list = Collections.emptyList();
        if (list == null) {
            RakeStructureViewModel.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    public StructureViewTreeElement getRoot() {
        return new RakeStructureViewElement((RPsiElement)this.getPsiFile());
    }

    @Override
    protected boolean isSuitable(@Nullable PsiElement element) {
        RPossibleCall call;
        if (element == null || super.isSuitable(element)) {
            return element != null;
        }
        if ((element instanceof RCall || element instanceof RBlockCall) && (RakeUtil.isRakeTaskCall(call = (RPossibleCall)element) || RakeUtil.isRakeNamespaceCall(call))) {
            return true;
        }
        if (!(element instanceof RDotReference)) {
            return RakeStructureViewElement.canBeTaskDefinedUsingTaskClassInstantiation(element);
        }
        return false;
    }

    @Override
    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        if (super.isAlwaysLeaf(element)) {
            return true;
        }
        Object value = element.getValue();
        return value instanceof RPossibleCall && RakeUtil.isRakeTaskCall((RPossibleCall)value);
    }

    @Override
    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        return RakeStructureViewModel.isNamespaceBlockCall(element.getValue());
    }

    private static boolean isNamespaceBlockCall(Object value) {
        return value instanceof RBlockCall && RakeUtil.isRakeNamespaceCall((RPossibleCall)((RBlockCall)value));
    }

    @Override
    public boolean isAutoExpand(@NotNull StructureViewTreeElement element) {
        if (element == null) {
            RakeStructureViewModel.$$$reportNull$$$0(1);
        }
        return super.isAutoExpand(element) || element.getValue() instanceof RContainer || RakeStructureViewModel.isNamespaceBlockCall(element.getValue());
    }

    protected Class<?> @NotNull [] getSuitableClasses() {
        if (RAKE_SUITABLE_CLASSES == null) {
            RakeStructureViewModel.$$$reportNull$$$0(2);
        }
        return RAKE_SUITABLE_CLASSES;
    }

    static {
        RakeStructureViewModel.RAKE_SUITABLE_CLASSES[RakeStructureViewModel.SUITABLE_CLASSES.length] = RCall.class;
        RakeStructureViewModel.RAKE_SUITABLE_CLASSES[RakeStructureViewModel.SUITABLE_CLASSES.length + 1] = RBlockCall.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/rake/structure/RakeStructureViewModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/structure/RakeStructureViewModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableClasses";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAutoExpand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

