/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake.runConfigurations;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TC_RubySdkUtil;
import org.jetbrains.plugins.ruby.utils.OSUtil;

public final class RakeRunConfigurationUtil {
    private static final Logger LOG = Logger.getInstance(RakeRunConfigurationUtil.class);
    @NonNls
    private static final String TESTS_RUNNER_SRC_PATH = "/rb/testing";
    @NonNls
    private static final String PATCH_FOLDER = File.separatorChar + "patch" + File.separatorChar;
    @NonNls
    private static final String PATCH_FOLDER_BDD = PATCH_FOLDER + "bdd";
    @NonNls
    private static final String PATCH_FOLDER_COMMON = PATCH_FOLDER + "common";
    @NonNls
    private static final String PATCH_FOLDER_TESTUNIT = PATCH_FOLDER + "testunit";
    @NonNls
    private static final String RAKE_FOR_RAILS = PATCH_FOLDER + "rake";

    @NotNull
    private static String getRootPath() throws ExecutionException {
        String basePath = RubyUtil.getScriptFullPath(TESTS_RUNNER_SRC_PATH);
        if (basePath == null) {
            @NonNls String msg = "Could not find test runner src path";
            LOG.warn("Could not find test runner src path");
            throw new ExecutionException("Could not find test runner src path");
        }
        String string = basePath;
        if (string == null) {
            RakeRunConfigurationUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static String getLoadPath_PatchRoot_Bdd() throws ExecutionException {
        String string = RakeRunConfigurationUtil.getRootPath() + PATCH_FOLDER_BDD;
        if (string == null) {
            RakeRunConfigurationUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String getLoadPath_PatchRoot_Common() throws ExecutionException {
        String string = RakeRunConfigurationUtil.getRootPath() + PATCH_FOLDER_COMMON;
        if (string == null) {
            RakeRunConfigurationUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String getLoadPath_PatchRoot_TestUnit() throws ExecutionException {
        String string = RakeRunConfigurationUtil.getRootPath() + PATCH_FOLDER_TESTUNIT;
        if (string == null) {
            RakeRunConfigurationUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String getLoadPath_PatchRoot_RakeForRails4() throws ExecutionException {
        String string = RakeRunConfigurationUtil.getRootPath() + RAKE_FOR_RAILS;
        if (string == null) {
            RakeRunConfigurationUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static void configureTestFrameworksSupport(@NotNull Map<String, String> envMap, @NotNull Sdk sdk, @Nullable Module module, @NotNull List<SupportedTestFramework> attachedFrameworks) throws ExecutionException {
        if (envMap == null) {
            RakeRunConfigurationUtil.$$$reportNull$$$0(5);
        }
        if (sdk == null) {
            RakeRunConfigurationUtil.$$$reportNull$$$0(6);
        }
        if (attachedFrameworks == null) {
            RakeRunConfigurationUtil.$$$reportNull$$$0(7);
        }
        envMap.put("TEAMCITY_RAKE_RUNNER_MODE", "idea");
        RubySdkSystemAccessor accessor = RubySdkUtil.getRubySdkAdditionalData(sdk).getSdkSystemAccessor();
        String rubyLib = envMap.get("RUBYLIB");
        if (!attachedFrameworks.isEmpty()) {
            if (SupportedTestFramework.containsTestUnitBasedFramework(attachedFrameworks)) {
                String testUnitPath;
                String loadPathPatch = RubySdkUtil.convertToRemote(sdk, module, RakeRunConfigurationUtil.getLoadPath_PatchRoot_TestUnit());
                rubyLib = OSUtil.prependToRUBYLIBEnvVariable(accessor, rubyLib, loadPathPatch);
                if (RailsApp.fromModule(module) != null && RailsUtil.isRails40OrHigher(module)) {
                    String rakeForRailsPatchLoadPath = RakeRunConfigurationUtil.getLoadPath_PatchRoot_RakeForRails4();
                    rakeForRailsPatchLoadPath = RubySdkUtil.convertToRemote(sdk, module, rakeForRailsPatchLoadPath);
                    rubyLib = OSUtil.prependToRUBYLIBEnvVariable(accessor, rubyLib, rakeForRailsPatchLoadPath);
                }
                if ((testUnitPath = TC_RubySdkUtil.getSdkTestUnitScriptPath(sdk, module)) != null) {
                    String convertedTestUnitPath = RubySdkUtil.convertToRemote(sdk, module, testUnitPath);
                    LOG.debug("TEAMCIY_RAKE_TU_PATH", new Object[]{": ", convertedTestUnitPath});
                    envMap.put("TEAMCIY_RAKE_TU_PATH", convertedTestUnitPath);
                }
            }
            if (SupportedTestFramework.containsBddFramework(attachedFrameworks)) {
                rubyLib = OSUtil.prependToRUBYLIBEnvVariable(accessor, rubyLib, RubySdkUtil.convertToRemote(sdk, module, RakeRunConfigurationUtil.getLoadPath_PatchRoot_Bdd()));
            }
        }
        rubyLib = OSUtil.prependToRUBYLIBEnvVariable(accessor, rubyLib, RubySdkUtil.convertToRemote(sdk, module, RakeRunConfigurationUtil.getLoadPath_PatchRoot_Common()));
        LOG.debug("RUBYLIB", new Object[]{": ", rubyLib});
        envMap.put("RUBYLIB", rubyLib);
        String serializedAttachedFrameworks = SupportedTestFramework.serialize(attachedFrameworks);
        LOG.debug("TEAMCITY_RAKE_RUNNER_USED_FRAMEWORKS", new Object[]{": ", serializedAttachedFrameworks});
        envMap.put("TEAMCITY_RAKE_RUNNER_USED_FRAMEWORKS", serializedAttachedFrameworks);
    }

    public static void mergeWithCurrentOPTs(@NotNull Map<String, String> envMap, @NotNull String specRunnerInitString, @NotNull String envKey) {
        String userSPEC_OPTS;
        if (envMap == null) {
            RakeRunConfigurationUtil.$$$reportNull$$$0(8);
        }
        if (specRunnerInitString == null) {
            RakeRunConfigurationUtil.$$$reportNull$$$0(9);
        }
        if (envKey == null) {
            RakeRunConfigurationUtil.$$$reportNull$$$0(10);
        }
        String realSPEC_OPTS = (userSPEC_OPTS = envMap.get(envKey)) == null ? specRunnerInitString : userSPEC_OPTS + " " + specRunnerInitString;
        envMap.put(envKey, realSPEC_OPTS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/rake/runConfigurations/RakeRunConfigurationUtil";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envMap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachedFrameworks";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specRunnerInitString";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadPath_PatchRoot_Bdd";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadPath_PatchRoot_Common";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadPath_PatchRoot_TestUnit";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadPath_PatchRoot_RakeForRails4";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/runConfigurations/RakeRunConfigurationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "configureTestFrameworksSupport";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "mergeWithCurrentOPTs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

