/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake.runConfigurations;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.tasks.rake.RakeIcons;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfiguration;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfigurationFactory;

public final class RakeRunConfigurationType
implements ConfigurationType,
DumbAware {
    private final RakeRunConfigurationFactory myFactory = new RakeRunConfigurationFactory(this);
    @NonNls
    public static final String ID = "RakeRunConfigurationType";
    @NlsSafe
    private static final String DISPLAY_NAME = "Rake";

    public static RakeRunConfigurationType getInstance() {
        return (RakeRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(RakeRunConfigurationType.class);
    }

    @NotNull
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getConfigurationTypeDescription() {
        return RBundle.message((String)"run.configuration.rake.description");
    }

    public Icon getIcon() {
        return RakeIcons.RAKE_RUN_CONFIGURATION_ICON;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public RakeRunConfigurationFactory getRakeFactory() {
        return this.myFactory;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    public String getHelpTopic() {
        return "reference.dialogs.rundebug.RakeRunConfigurationType";
    }

    public RunnerAndConfigurationSettings createConfiguration(Module module, @NonNls String taskName) {
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)module.getProject()).createConfiguration(taskName, (ConfigurationFactory)this.myFactory);
        RakeRunConfiguration templateConfiguration = (RakeRunConfiguration)settings.getConfiguration();
        templateConfiguration.setModule(module);
        templateConfiguration.setTaskName(taskName);
        return settings;
    }
}

