/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake.runConfigurations;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractTestRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.TaskRunConfiguration;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtil;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunCommandLineState;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfigurationEditor;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfigurationExternalizer;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfigurationParams;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;

public class RakeRunConfiguration
extends AbstractTestRunConfiguration<RakeRunConfiguration>
implements RakeRunConfigurationParams,
TaskRunConfiguration {
    private String myTaskName = "";
    @NotNull
    private String myTaskArgs = "";
    private List<SupportedTestFramework> myFrameworks = Collections.emptyList();
    private boolean myOptionTraceEnabled;
    private boolean myOptionDryrunEnabled;
    private boolean myOptionPrereqsEnabled;
    private String myTestopts = "";

    public RakeRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
        this.registerLog("RUBY_RAKE");
    }

    @Override
    protected String getLogTitle() {
        return RBundle.message((String)"run.configuration.rake.configuration.log.tab.name");
    }

    @Override
    @NotNull
    protected String getDefaultLogFileName() {
        return this.getTestFramework().equals((Object)SupportedTestFramework.RAKE) ? "development.log" : "test.log";
    }

    public static void copyParams(RakeRunConfigurationParams fromParams, RakeRunConfigurationParams toParams) {
        toParams.setTaskName(fromParams.getTaskName());
        toParams.setTaskArgs(fromParams.getTaskArgs());
        toParams.setAttachedTestFrameworks(fromParams.getAttachedTestFrameworks());
        toParams.setOptionTrace(fromParams.isOptionTraceEnabled());
        toParams.setOptionDryrun(fromParams.isOptionDryrunEnabled());
        toParams.setOptionPrereqs(fromParams.isOptionPrereqsEnabled());
        toParams.setTestopts(fromParams.getTestopts());
    }

    @Override
    protected String getSerializationId() {
        return RakeRunConfigurationExternalizer.getInstance().getID();
    }

    @Override
    protected void validateConfiguration() throws RuntimeConfigurationException {
        RunConfigurationUtil.inspectSDK(this);
        RunConfigurationUtil.inspectWorkingDirectory(true, this);
        RakeRunConfiguration.inspectRakeTaskName(this);
        RakeRunConfiguration.inspectRakeExecutable(this);
        RakeRunConfiguration.inspectRakeFile(this);
    }

    private static void inspectRakeTaskName(RakeRunConfiguration configuration) throws RuntimeConfigurationError {
        if (StringUtil.isEmpty((String)StringUtil.notNullize((String)configuration.getTaskName()).trim())) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.rake.validation.error.no.task"));
        }
    }

    private static void inspectRakeExecutable(RakeRunConfiguration configuration) throws RuntimeConfigurationError {
        Sdk sdk = configuration.getSdk();
        assert (sdk != null);
        String scriptPath = RakeUtil.getRakeGemExecutableScriptPath(configuration.getModule(), sdk);
        if (scriptPath == null) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.rake.validation.error.no.gem", (Object[])new Object[]{sdk.getName()}));
        }
    }

    private static void inspectRakeFile(RakeRunConfiguration configuration) throws RuntimeConfigurationError {
        String workDirPath = configuration.getWorkingDirectory();
        assert (!StringUtil.isEmpty((String)workDirPath));
        if (!RakeUtil.rakeFileExists(LocalFileSystem.getInstance().findFileByPath(workDirPath))) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.rake.validation.error.no.rakefile"));
        }
    }

    @Override
    @NotNull
    protected SettingsEditor<RakeRunConfiguration> createConfigurationEditor() {
        return new RakeRunConfigurationEditor(this.getProject(), this);
    }

    @Override
    protected RubyAbstractCommandLineState createCommandLineState(@NotNull ExecutionEnvironment env) throws ExecutionException {
        if (env == null) {
            RakeRunConfiguration.$$$reportNull$$$0(0);
        }
        return new RakeRunCommandLineState(this, env);
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            RakeRunConfiguration.$$$reportNull$$$0(1);
        }
        super.readExternal(element);
        RakeRunConfigurationExternalizer.getInstance().readExternal(this, element);
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            RakeRunConfiguration.$$$reportNull$$$0(2);
        }
        super.writeExternal(element);
        RakeRunConfigurationExternalizer.getInstance().writeExternal(this, element);
    }

    void cleanUpTaskName() {
        Pattern pattern = Pattern.compile("(\\S+)(\\[\\S+])");
        Matcher matcher = pattern.matcher(this.myTaskName);
        if (matcher.matches()) {
            this.myTaskName = matcher.group(1);
        }
    }

    @Override
    public String getTaskName() {
        return this.myTaskName;
    }

    @Override
    @NotNull
    public String getTaskArgs() {
        String string = this.myTaskArgs;
        if (string == null) {
            RakeRunConfiguration.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public List<SupportedTestFramework> getAttachedTestFrameworks() {
        List<SupportedTestFramework> list = this.myFrameworks;
        if (list == null) {
            RakeRunConfiguration.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public void setTaskName(@Nullable String name) {
        this.myTaskName = StringUtil.notNullize((String)name);
    }

    @Override
    public void setTaskArgs(@Nullable String args) {
        this.myTaskArgs = StringUtil.notNullize((String)args);
    }

    @Override
    public void setAttachedTestFrameworks(@NotNull List<SupportedTestFramework> frameworks) {
        if (frameworks == null) {
            RakeRunConfiguration.$$$reportNull$$$0(5);
        }
        this.myFrameworks = frameworks;
    }

    @Override
    public boolean isOptionTraceEnabled() {
        return this.myOptionTraceEnabled;
    }

    @Override
    public boolean isOptionDryrunEnabled() {
        return this.myOptionDryrunEnabled;
    }

    @Override
    public boolean isOptionPrereqsEnabled() {
        return this.myOptionPrereqsEnabled;
    }

    @Override
    @NotNull
    public String getTestopts() {
        String string = this.myTestopts;
        if (string == null) {
            RakeRunConfiguration.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public void setOptionTrace(boolean enabled) {
        this.myOptionTraceEnabled = enabled;
    }

    @Override
    public void setOptionDryrun(boolean enabled) {
        this.myOptionDryrunEnabled = enabled;
    }

    @Override
    public void setOptionPrereqs(boolean enabled) {
        this.myOptionPrereqsEnabled = enabled;
    }

    @Override
    public void setTestopts(@NotNull String options) {
        if (options == null) {
            RakeRunConfiguration.$$$reportNull$$$0(7);
        }
        this.myTestopts = options;
    }

    @Override
    @NotNull
    public SupportedTestFramework getTestFramework() {
        SupportedTestFramework framework;
        List<SupportedTestFramework> list = this.getAttachedTestFrameworks();
        if (list.size() == 1 && (SupportedTestFramework.RSPEC.equals((Object)(framework = list.get(0))) || SupportedTestFramework.TEST_UNIT.equals((Object)framework) || SupportedTestFramework.CUCUMBER.equals((Object)framework))) {
            SupportedTestFramework supportedTestFramework = framework;
            if (supportedTestFramework == null) {
                RakeRunConfiguration.$$$reportNull$$$0(8);
            }
            return supportedTestFramework;
        }
        SupportedTestFramework supportedTestFramework = SupportedTestFramework.RAKE;
        if (supportedTestFramework == null) {
            RakeRunConfiguration.$$$reportNull$$$0(9);
        }
        return supportedTestFramework;
    }

    @Override
    public boolean shouldAttachTestRunnerConsole() {
        return !this.getAttachedTestFrameworks().isEmpty();
    }

    @Override
    @Nullable
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        if (executor == null) {
            RakeRunConfiguration.$$$reportNull$$$0(10);
        }
        return this.shouldAttachTestRunnerConsole() ? super.createTestConsoleProperties(executor) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/rake/runConfigurations/RakeRunConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworks";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/runConfigurations/RakeRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskArgs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachedTestFrameworks";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestopts";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFramework";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLineState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setAttachedTestFrameworks";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setTestopts";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 8, 9 -> new IllegalStateException(string);
        };
    }
}

