/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake.runConfigurations;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.rails.preload.zeus.ZeusUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtil;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunCommandLineModifierProvider;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfiguration;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfigurationUtil;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RAbstractTestsCommandLineState;

public class RakeRunCommandLineState
extends RAbstractTestsCommandLineState {
    @NonNls
    private static final String RAKE_RUNNER_PARAMS_GROUP_ID = "ruby.rake.runner";

    public RakeRunCommandLineState(RakeRunConfiguration runConfiguration, ExecutionEnvironment environment) {
        super(runConfiguration, environment);
    }

    @Override
    public RakeRunConfiguration getConfig() {
        return (RakeRunConfiguration)super.getConfig();
    }

    @Override
    protected RubyCommandLineData createRunCommandLine() throws ExecutionException {
        return RakeRunCommandLineState.createCommandLine(this.getConfig(), this.getRunnerId(), this.getConfig().shouldAttachTestRunnerConsole());
    }

    @Override
    @NotNull
    public ConsoleView createAndAttachConsole(@NotNull Project project, @NotNull ProcessHandler processHandler, @NotNull Executor executor) throws ExecutionException {
        if (project == null) {
            RakeRunCommandLineState.$$$reportNull$$$0(0);
        }
        if (processHandler == null) {
            RakeRunCommandLineState.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            RakeRunCommandLineState.$$$reportNull$$$0(2);
        }
        ConsoleView consoleView = super.createAndAttachConsole(project, processHandler, executor);
        processHandler.addProcessListener(new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                VirtualFileManager.getInstance().asyncRefresh();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/tasks/rake/runConfigurations/RakeRunCommandLineState$1", "processTerminated"));
            }
        });
        ConsoleView consoleView2 = consoleView;
        if (consoleView2 == null) {
            RakeRunCommandLineState.$$$reportNull$$$0(3);
        }
        return consoleView2;
    }

    public static RubyCommandLineData createCommandLine(@NotNull RakeRunConfiguration config, @NotNull String runnerId, boolean shouldAttachTestRunnerConsole) throws ExecutionException {
        boolean useSpring;
        boolean preLoaderAllowed;
        if (config == null) {
            RakeRunCommandLineState.$$$reportNull$$$0(4);
        }
        if (runnerId == null) {
            RakeRunCommandLineState.$$$reportNull$$$0(5);
        }
        RubyCommandLineData data = RakeRunCommandLineState.createDefaultCommandLine(config, runnerId);
        RubyCommandLine commandLine = data.getCommandLine();
        Map envMap = commandLine.getEnvironment();
        Sdk sdk = config.getSdk();
        assert (sdk != null);
        if (shouldAttachTestRunnerConsole) {
            RakeRunCommandLineState.configureRakeTestFrameworksSupport(envMap, config.getAttachedTestFrameworks());
        }
        boolean useZeus = (preLoaderAllowed = RakeRunCommandLineState.preLoaderAllowed(runnerId)) && PreLoadUtil.PreLoadServer.Zeus.isRunning(config.getModule());
        boolean bl = useSpring = preLoaderAllowed && SpringUtil.isSpringAvailable(config.getModule());
        String rakeGemExecutableScriptPath = useZeus ? ZeusUtil.getZeusExecutable(config.getModule(), sdk) : (useSpring && RakeRunCommandLineState.isExplicitSpringEnabled(runnerId) ? SpringUtil.getSpringExecutable(config.getModule(), sdk) : RakeUtil.getRakeGemExecutableScriptPath(config.getModule(), sdk));
        assert (rakeGemExecutableScriptPath != null) : "rake executable path must not be null here";
        ParamsGroup runnerParamsGroup = RakeRunCommandLineState.addExecutionScriptGroup(RAKE_RUNNER_PARAMS_GROUP_ID, data, commandLine, rakeGemExecutableScriptPath, sdk, config.getModule());
        if (useZeus || useSpring && RakeRunCommandLineState.isExplicitSpringEnabled(runnerId)) {
            String rakeExecutable = RakeUtil.getRakeExecutable(config.getModule());
            runnerParamsGroup.addParameter(rakeExecutable);
        }
        if (useZeus) {
            envMap.remove("RAILS_ENV");
        }
        if (config.isOptionTraceEnabled()) {
            runnerParamsGroup.addParameter("--trace");
        }
        if (config.isOptionDryrunEnabled()) {
            runnerParamsGroup.addParameter("--dry-run");
        }
        if (config.isOptionPrereqsEnabled()) {
            runnerParamsGroup.addParameter("--prereqs");
        }
        RakeRunCommandLineState.configureArguments(config, runnerParamsGroup);
        return data;
    }

    private static void configureArguments(@NotNull RakeRunConfiguration config, @NotNull ParamsGroup runnerParamsGroup) {
        if (config == null) {
            RakeRunCommandLineState.$$$reportNull$$$0(6);
        }
        if (runnerParamsGroup == null) {
            RakeRunCommandLineState.$$$reportNull$$$0(7);
        }
        ArrayList<String> keyValueArgs = new ArrayList<String>();
        ArrayList<String> bracketArgs = new ArrayList<String>();
        for (String parameter : config.getTaskArgs().split("\\s+")) {
            if (!StringUtil.isNotEmpty((String)parameter)) continue;
            if (parameter.matches("\\S+=\\S+")) {
                keyValueArgs.add(parameter);
                continue;
            }
            bracketArgs.add(parameter);
        }
        config.cleanUpTaskName();
        String presentableTaskName = config.getTaskName() + RakeRunCommandLineState.buildBracketArgs(bracketArgs);
        if (!presentableTaskName.isEmpty()) {
            runnerParamsGroup.addParameter(presentableTaskName);
        }
        for (String arg : keyValueArgs) {
            runnerParamsGroup.addParameter(arg);
        }
    }

    private static String buildBracketArgs(@NotNull List<String> bracketArgs) {
        if (bracketArgs == null) {
            RakeRunCommandLineState.$$$reportNull$$$0(8);
        }
        StringBuilder builder2 = new StringBuilder();
        if (!bracketArgs.isEmpty()) {
            int size = bracketArgs.size();
            builder2.append("[");
            for (int i = 0; i < size; ++i) {
                builder2.append(bracketArgs.get(i));
                if (i >= size - 1) continue;
                builder2.append(" ");
            }
            builder2.append("]");
        }
        return builder2.toString();
    }

    private static void configureRakeTestFrameworksSupport(@NotNull Map<String, String> envMap, @NotNull List<SupportedTestFramework> attachedTestFrameworks) {
        if (envMap == null) {
            RakeRunCommandLineState.$$$reportNull$$$0(9);
        }
        if (attachedTestFrameworks == null) {
            RakeRunCommandLineState.$$$reportNull$$$0(10);
        }
        if (attachedTestFrameworks.contains((Object)SupportedTestFramework.RSPEC)) {
            String specRunnerInitString = "--require teamcity/spec/runner/formatter/teamcity/formatter --format Spec::Runner::Formatter::TeamcityFormatter";
            RakeRunConfigurationUtil.mergeWithCurrentOPTs(envMap, "--require teamcity/spec/runner/formatter/teamcity/formatter --format Spec::Runner::Formatter::TeamcityFormatter", "SPEC_OPTS");
        }
        for (RakeRunCommandLineModifierProvider provider : RakeRunCommandLineModifierProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            provider.processCommandLine(attachedTestFrameworks, envMap);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/rake/runConfigurations/RakeRunCommandLineState";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerParamsGroup";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bracketArgs";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envMap";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachedTestFrameworks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/runConfigurations/RakeRunCommandLineState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAttachConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAndAttachConsole";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "configureArguments";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildBracketArgs";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "configureRakeTestFrameworksSupport";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

